;***	VMDPMD.INC
;
;
;	Mouse VDD/PDD shared structures/constants
;	Copyright (c) 1988,1989 Microsoft Corporation
;
;	For include file hierarchy, see VMD/PMD include file(s)
;
;
;	MODIFICATION HISTORY
;	10/21/88    JTP	    Created.
;


;***	VMD/PMD constants
;

PMD_NAME	EQU	"MOUSE$"	    ;registered name of PMD

PMDCMD_REGISTER		EQU	<PDDCMD_REGISTER>		;register VDD
PMDCMD_DEREGISTER	EQU	(PMDCMD_REGISTER+1)	;de-register VDD
PMDCMD_QUERYTYPE	EQU	(PMDCMD_REGISTER+2)	;query hwd info.
PMDCMD_SETSCREENSIZE	EQU	(PMDCMD_REGISTER+3)	;set screen size
PMDCMD_GRABACCESS	EQU	(PMDCMD_REGISTER+4) ;Get Exclusive Access

VMDCMD_NOTIFYEVENT	EQU	001h	;notification of event availability




;***	Event packet flags (as defined by PMD)
;

MEVSTAT_MOTION	EQU	00001h	;motion only
MEVSTAT_MOTIONLEFT	EQU	00002h	;motion while LEFT button down
MEVSTAT_LEFTDOWN	EQU	00004h	;LEFT button down
MEVSTAT_MOTIONRIGHT	EQU	00008h	;motion while RIGHT button down
MEVSTAT_RIGHTDOWN	EQU	00010h	;RIGHT button down
MEVSTAT_MOTIONCENTER	EQU	00020h	;motion while CENTER button down
MEVSTAT_CENTERDOWN	EQU	00040h	;CENTER button down
MEVSTAT_ALLMOTION	EQU	0002Bh	;mask for all motion events
MEVSTAT_ABSPIXEVENT	EQU	08000h	;absolute pixel coordinate event



;***	VMD-to-PMD communication structures
;
;   MHARDWARE is an output packet provided by VMD on the QUERYTYPE request,
;   and is filled in by the PMD with appropriate information about the mouse
;   hardware.  There is no input packet for this request.
;
;   MSSIZE is an input packet provided by VMD on the SETSCREENSIZE request
;   and contains the screen size of a given video mode.  This may be used
;   by the PMD to compute the coordinate range when reporting absolute pixel
;   events.
;

DefStruc ,mhw_s			;mhw
    USHORT  mhw_nb		       ;size of structure, in bytes (9)
    UCHAR   mhw_nMickeys	       ;mickeys per centimeter
    UCHAR   mhw_nButtons	       ;# of buttons
    UCHAR   mhw_irq		       ;IRQ #
    UCHAR   mhw_uType		       ;0=unk,1=bus,2=ser,3=inp,4=inboard
    UCHAR   mhw_ComNum		       ;0 if non-serial device
    USHORT  mhw_ComPort		       ;Com port address
EndStruc MHARDWARE

;*********************************************************************
; Defines for mhw_uType byte field in the MHARDWARE structure
;*********************************************************************
VMSE_UNKNOWN_DEVICE	EQU	0	   ;No pointing device
VMSE_BUS_DEVICE		EQU	1	   ;MS Bus mouse
VMSE_MSS_DEVICE		EQU	2	   ;MS Serial mouse
VMSE_INP_DEVICE		EQU	3	   ;MS Inport mouse
VMSE_PDI_DEVICE		EQU	4	   ;PS/2 style pointing device
VMSE_PSC_DEVICE		EQU	5	   ;8516 Touch Display device

; start of changes for PenPM EMI
DefStruc ,mss_s			;mss
    USHORT  mss_nb		       ;size of structure, in bytes (12)
    UCHAR   mss_type		       ;VIO type of the mode
    UCHAR   mss_color		       ;2 ** n number of colors (4 = 16)
    USHORT  mss_tcol_res	       ;number of text columns
    USHORT  mss_trow_res	       ;number of text rows
    USHORT  mss_gcol_res	       ;number of x or column pels
    USHORT  mss_grow_res	       ;number of y or row pels
EndStruc MSSIZE
; end of changes for PenPM EMI

DefStruc ,mougrab			;mougrab
    USHORT  uscMouGrab	       ;size of structure, in bytes (8)
    USHORT  usSG	       ;Screen Group
    BOOL    fMouGrab	       ;Flag to grab/release mouse
EndStruc MOUGRAB



;***	PMD-to-VMD communication structures
;
;   MEVENT is an input packet provided by the PMD on the NOTIFYEVENT request,
;   and indicates the VDM screen group to which the new event belongs.  There
;   is no output packet for this request.
;

;Note that the mouse event is always in unscaled raw mickeys no matter
;    what the SETVDMPARMS is programmed.  SETVDMPARMS only serves
;    the purpose of telling PMSE the resolution of posting mouse events.

DefStruc ,minfo_s			;minfo
    USHORT  minfo_fs		       ;button/motion states
    _SHORT   minfo_nx			;x, in delta mickeys or abs pixels
    _SHORT   minfo_ny			;y, in delta mickeys or abs pixels
    _SHORT   nxMickeys		;x, in delta mickeys, when saving counts
    _SHORT   nyMickeys		;y, in delta mickeys, when saving counts

EndStruc MINFO

DefType PMINFO,dd			;pminfo

DefStruc ,mev_s			;mev
    USHORT  mev_uSG		       ;VDM screen group ID
    MINFO   mev_mi		       ;mouse event info.
EndStruc MEVENT

DefType PMEV,dd			;pmev


