;***	vkbdpdd.inc
;
;
;	Keyboard PDD/VDD shared structures/constants
;	Copyright (c) 1988,1989 Microsoft Corporation
;
;	MODIFICATION HISTORY
;	    11/21/88 MTS	Created.
;

;KBD PDD component definitions

KBD_NAME	EQU	"KBD$"


;***	PDD function commands
;
;   Format:
;	(*fpfnPKVDDProc)(PKBDCMD_*, f16p1, f16p2)
;
;   PKBDCMD_REGISTER:
;	f16p1 == segment of 16:32 VDD entry point
;	f16p2 ==  offset of 16:32 VDD entry point
;
;   PKBDCMD_DEREGISTER:
;	f16p1 == F16PNULL
;	f16p2 == F16PNULL
;
;   PKBDCMD_VDMCREATED:
;	f16p1 -> KSGID	    (see packet below)
;	f16p2 == F16PNULL
;
;   PKBDCMD_QUERYID:
;	f16p1 == F16PNULL
;	f16p2 -> KID	    (see packet below)
;
;   PKBDCMD_QUERYINHIBIT:
;	f16p1 == F16PNULL
;	f16p2 -> KINH	    (see packet below)
;
;   PKBDCMD_SETLEDS:
;	f16p1 -> KLEDS	    (see packet below)
;	f16p2 == F16PNULL
;
;   PKBDCMD_SETREPEATRATE:
;	f16p1 -> KRPT	    (see packet below)
;	f16p2 == F16PNULL
;
;   PKBDCMD_TRANSLATE:
;	f16p1 -> KXLT	    (see packet below)
;	f16p2 == F16PNULL
;
;   PKBDCMD_VDMTERMINTED:
;	f16p1 -> KSGID	    (see packet below)
;	f16p2 == F16PNULL
;
;   PKBDCMD_FOCUS:
;	f16p1 -> KFOCUS	    (see packet below)
;	f16p2 == F16PNULL
;
;   PKBDCMD_QUERYREVXLATE:
;	f16p1 -> KQRX	    (see packet below)
;	f16p2 == F16PNULL
;

PKBDCMD_REGISTER	EQU	<PDDCMD_REGISTER>		;register VDD
PKBDCMD_DEREGISTER	EQU	(PKBDCMD_REGISTER+1) ;de-register VDD
PKBDCMD_VDMCREATED	EQU	(PKBDCMD_REGISTER+2) ;notify VDM is created
PKBDCMD_QUERYID		EQU	(PKBDCMD_REGISTER+3) ;query physical kbd ID
PKBDCMD_QUERYINHIBIT	EQU	(PKBDCMD_REGISTER+4) ;query inhibit state
PKBDCMD_SETLEDS		EQU	(PKBDCMD_REGISTER+5) ;set physical LEDs
PKBDCMD_SETREPEATRATE	EQU	(PKBDCMD_REGISTER+6) ;set physical repeat rate
PKBDCMD_TRANSLATE	EQU	(PKBDCMD_REGISTER+7) ;translate a scan code
PKBDCMD_VDMTERMINATED	EQU	(PKBDCMD_REGISTER+8) ;notify VDM termination
PKBDCMD_KFOCUS	EQU	(PKBDCMD_REGISTER+9) ;notify of focus change
PKBDCMD_QUERYREVXLATE	EQU	(PKBDCMD_REGISTER+10);query reverse xlate table
PKBDCMD_HOTKEY	EQU	(PKBDCMD_REGISTER+11);DCR 1195 notify of Hot Key setting


DefStruc ,ksgid_s
    USHORT  ksgid_len		       ;length of packet (4)
    SGID    ksgid_sgid		       ;screen group ID
EndStruc KSGID

DefType PKSGID,dd

KSGID_PKT_LEN EQU     SIZE ksgid_s


DefStruc ,kid_s
    USHORT kid_len		       ;length of packet (4)
    USHORT kid_ID		       ;keyboard ID
EndStruc KID

DefType PKID,dd

KID_PKT_LEN   EQU     SIZE kid_s


DefStruc ,kinh_s
    USHORT kinh_len		       ;length of packet (3)
    BBOOL  kinh_fInhibited	       ;TRUE if inhibited, FALSE if not
EndStruc KINH

DefType PKINH,dd

KINH_PKT_LEN  EQU     SIZE kinh_s


DefStruc ,kled_s
    USHORT kled_len		       ;length of packet (4)
    USHORT kled_fsLEDs		       ;bit0:SCROLL; bit1:NUM; bit2:CAPS
EndStruc KLEDS

DefType PKLEDS,dd

KLEDS_PKT_LEN EQU     SIZE kled_s

;DCR 1195
DefStruc ,khotkey_s
    USHORT khk_len
    USHORT khk_action
    ULONG khk_hotkeys
EndStruc KHOTKEYS

DefType PKHOTKEYS,dd

KHOTKEYS_PKT_LEN EQU	 SIZE khotkey_s


DefStruc ,krpt_s
    USHORT krpt_len		       ;length of packet (6)
    USHORT krpt_usDelay		       ;delay, in ms. (0 implies default)
    USHORT krpt_usRate		       ;rate, in cps (0 implies default)
EndStruc KRPT

DefType PKRPT,dd

KRPT_PKT_LEN  EQU     SIZE krpt_s


DefStruc ,kkey_s
    UCHAR  key_len		       ;length of packet (14)	  ;54113
    UCHAR  key_chOrgScan	       ;original scan code	  ;54113
    UCHAR  key_chChar		       ;ASCII code (output)
    UCHAR  key_chScan		       ;scan code (input)
    UCHAR  key_fbStatus		       ;(output, normally KEYSTATUS_FINAL)
    UCHAR  key_bNLSShift	       ;(reserved, set to zero on input)
    USHORT key_fsState		       ;shift states (input/output)
    ULONG  key_time		       ;timestamp (ignored)
    USHORT key_fsDDFlags	       ;device driver/monitor flags (output)
EndStruc KKEY

DefType PKKEY,dd
DefType F16PKKEY,dd

KKEY_PKT_LEN  EQU     SIZE kkey_s


DefStruc ,kxf_s
    USHORT kxf_len		       ;length of packet (9)
    UCHAR  kxf_fbXlate		       ;translation flags
    UCHAR  kxf_fbKey		       ;key flags
    UCHAR  kxf_fbSpec		       ;multi-keypacket events
    UCHAR  kxf_fbMode		       ;input mode
    UCHAR  kxf_fbAltNum		       ;Alt-keypad accumulator
    USHORT kxf_fsHotKey		       ;interrupt-time "hot key" shift state
    UCHAR  kxf_fbAccent		       ;DCR 1546 Extended Accent use
EndStruc KXF

DefType PKXF,dd
DefType F16PKXF,dd

KXF_PKT_LEN   EQU     SIZE kxf_s


DefStruc ,kxlt_s
    USHORT   kxlt_len		       ;length of packet (16)
    F16PKKEY kxlt_f16pKey1	       ;pointer to key pkt 1
    F16PKKEY kxlt_f16pKey2	       ;pointer to key pkt 2
    F16PKXF  kxlt_f16pKxf	       ;pointer to translation flags pkt
    USHORT   kxlt_usCodePage	       ;codepage to use
EndStruc KXLT

DefType PKXLT,dd

KXLT_PKT_LEN  EQU     SIZE kxlt_s

DefStruc ,kfocus_s
    USHORT kf_len		     ;length of packet (4)
    USHORT kf_fsFocus		     ;TRUE (set) FALSE (free) focus
EndStruc KFOCUS

DefType PKFOCUS,dd

KFOCUS_PKT_LEN EQU   SIZE kfocus_s

DefStruc ,rxentry_s
    UCHAR   rx_chScan
    UCHAR   rx_fbRXFlags
EndStruc RXENTRY

DefType PRX,dd
DefType F16PRX,dd

DefStruc ,shentry_s
    USHORT  sh_fsShift
    UCHAR   sh_scanShift
    UCHAR   sh_scanPrefix
EndStruc SHENTRY

DefType PSH,dd
DefType F16PSH,dd

SHENTRY_SIZE  EQU     SIZE shentry_s

DefType PNUM,dd
DefType F16PNUM,dd

NUM_RXENTRIES	EQU	256	;max. entries in rev. xlate table
NUM_SHENTRIES	EQU	6	;max. entries in shift table
NUM_NUMENTRIES	EQU	10	;max. entries in num scan table

DefType RXTABLE,RXENTRY
DefType SHTABLE,SHENTRY
DefType NUMTABLE,UCHAR

;RXFlags equates

RXFLAGS_NONKEY	EQU	0
RXFLAGS_LOWCASE		EQU	1
RXFLAGS_UPCASE	EQU	2
RXFLAGS_NOSHIFT		EQU	3
RXFLAGS_SHIFT	EQU	4
RXFLAGS_CTRL	EQU	5

;Shift Table indexes

SHINDX_LSHIFT	EQU	0
SHINDX_LCTRL	EQU	1
SHINDX_LALT	EQU	2
SHINDX_RSHIFT	EQU	3
SHINDX_RCTRL	EQU	4
SHINDX_RALT	EQU	5

DefStruc ,kqrx_s
    USHORT  kqrx_len		       ;length of packet (18)
    USHORT  kqrx_usCodePage	       ;code page number
    USHORT  kqrx_hCodePage	       ;codepage table handle
    F16PRX  kqrx_f16pRXTable	       ;pointer to rev. xlate table
    F16PSH  kqrx_f16pShTable	       ;pointer to shift table
    F16PNUM kqrx_f16pNumTable	       ;pointer to table for num pad scans
EndStruc KQRX

DefType PKQRX,dd

KQRX_PKT_LEN  EQU     SIZE kqrx_s


;***	VDD function commands
;
;   Format:
;	(*fpfnVKPDDProc)(VKBDCMD_*, f16p1, f16p2)
;
;   VKBDCMD_INTEVENT:
;	f16p1 -> KINT	    (see packet below)
;	f16p2 == NULL
;
;   VKBDCMD_CPCHANGED:
;	f16p1 -> KCPC	    (see packet below)
;	f16p2 == NULL
;
;   VKBDCMD_HOTPLUG
;	f16p1 -> KHP	    (see packet below)
;	f16p2 == NULL
;

VKBDCMD_INTEVENT	EQU	001h	;to notify of a scan code
VKBDCMD_CPCHANGED	EQU	002h	;to notify of a codepage changed
VKBDCMD_HOTPLUG		EQU	003h	;to notify of a hot plug occurance

DefStruc ,kint_s
    USHORT kint_len		       ;length of packet
    USHORT kint_chScan		       ;scan code
    USHORT kint_usSGID		       ;screen group ID
EndStruc KINT

DefType PKINT,dd

KINT_PKT_LEN  EQU     SIZE kint_s

DefStruc ,kcpc_s
    USHORT kcpc_len		       ;length of packet
    USHORT kcpc_usCodePage	       ;code page being changed
    USHORT kcpc_hCodePage	       ;code page handle
EndStruc KCPC

DefType PKCPC,dd

KCPC_PKT_LEN  EQU     SIZE kcpc_s

DefStruc ,khp_s
    USHORT khp_len		       ;length of packet
    USHORT khp_usKbdHWID	       ;current keyboard hw ID
EndStruc KHP

DefType PKHP,dd

KHP_PKT_LEN  EQU     SIZE khp_s


;Flags for various fields in the XLTPKT structure

KEYSTATUS_FINAL		EQU	040h	;key is final

KEYSTATE_RIGHTSHIFT	EQU	<BIOSKFLAG_RIGHTSHIFT>
KEYSTATE_LEFTSHIFT	EQU	<BIOSKFLAG_LEFTSHIFT>
KEYSTATE_EITHERCTRL	EQU	<BIOSKFLAG_CTRL>
KEYSTATE_EITHERALT	EQU	<BIOSKFLAG_ALT>
KEYSTATE_SCROLLLOCK	EQU	<BIOSKFLAG_SCROLLLOCK>
KEYSTATE_NUMLOCK	EQU	<BIOSKFLAG_NUMLOCK>
KEYSTATE_CAPSLOCK	EQU	<BIOSKFLAG_CAPSLOCK>
KEYSTATE_INSERT		EQU	<BIOSKFLAG_INSERT>
KEYSTATE_LEDMASK	EQU	(KEYSTATE_SCROLLLOCK + \
				 KEYSTATE_NUMLOCK    + \
				 KEYSTATE_CAPSLOCK)

KEYSTATE_LEFTCTRL	EQU	(BIOSKFLAG1_LEFTCTRL   * 00100h)
KEYSTATE_LEFTALT	EQU	(BIOSKFLAG1_LEFTALT    * 00100h)
KEYSTATE_RIGHTCTRL	EQU	(BIOSKFLAG3_RIGHTCTRL  * 00100h)
KEYSTATE_RIGHTALT	EQU	(BIOSKFLAG3_RIGHTALT   * 00100h)
KEYSTATE_SCROLLDOWN	EQU	(BIOSKFLAG1_SCROLLDOWN * 00100h)
KEYSTATE_NUMDOWN	EQU	(BIOSKFLAG1_NUMDOWN    * 00100h)
KEYSTATE_CAPSDOWN	EQU	(BIOSKFLAG1_CAPSDOWN   * 00100h)
KEYSTATE_SYSREQDOWN	EQU	(BIOSKFLAG1_SYSSHIFT   * 02000h)

KEYSTATE_LRSHIFTS	EQU	(KEYSTATE_LEFTSHIFT + KEYSTATE_RIGHTSHIFT + \
				 KEYSTATE_LEFTCTRL  + KEYSTATE_RIGHTCTRL  + \
				 KEYSTATE_LEFTALT   + KEYSTATE_RIGHTALT)

KEYSTATE_ALLSHIFTS	EQU	(KEYSTATE_LRSHIFTS + \
				 KEYSTATE_EITHERCTRL + KEYSTATE_EITHERALT)

KEYFLAGS_NORMAL		EQU	00000h	;any normal key
KEYFLAGS_ACK	EQU	00001h	;eg, SCAN_ACK
KEYFLAGS_SECPREFIX	EQU	00002h	;eg, 0E0h, 0E1h
KEYFLAGS_OVERRUN	EQU	00003h	;eg, SCAN_OVERRUN
KEYFLAGS_RESEND		EQU	00004h	;eg, SCAN_RESEND
KEYFLAGS_REBOOT		EQU	00005h	;never returned (PDD reboots)
KEYFLAGS_DUMP	EQU	00006h	;eg, Ctrl-Alt-NumLock (ignore)
KEYFLAGS_SHIFT	EQU	00007h	;eg, Shift, Ctrl, CapsLock, etc.
KEYFLAGS_PAUSE	EQU	00008h	;eg, Pause or Ctrl-Numlock
KEYFLAGS_PSPAUSE	EQU	00009h	;never returned (we're in RAW mode)
KEYFLAGS_WAKEUP		EQU	0000Ah	;only after PAUSE, never PSPAUSE
KEYFLAGS_BADACCENT	EQU	0000Bh	;eg, unaccentable key
KEYFLAGS_HOTKEY		EQU	0000Ch	;
KEYFLAGS_READPEEK	EQU	0000Dh	;
KEYFLAGS_ACCENT		EQU	00010h	;
KEYFLAGS_BREAK	EQU	00011h	;eg, Ctrl-Break
KEYFLAGS_PSBREAK	EQU	00012h	;never returned (we're in RAW mode)
KEYFLAGS_PRTSC	EQU	00013h	;eg, PrtSc
KEYFLAGS_PRTECHO	EQU	00014h	;eg, Ctrl-PrtSc
KEYFLAGS_PSPRTECHO	EQU	00015h	;never returned (we're in RAW mode)
KEYFLAGS_PRTFLUSH	EQU	00016h	;eg, Ctrl-Alt-PrtSc
KEYFLAGS_SYSREQ		EQU	00017h	;eg, SysReq
KEYFLAGS_UNDEFINED	EQU	0003Fh	;undefined (we map ignored keys here)
KEYFLAGS_TYPEMASK	EQU	0003Fh	;key type mask

KEYFLAGS_RELEASED	EQU	00040h	;this was a release, not a press
KEYFLAGS_SECONDARY	EQU	00080h	;key was preceded by SECPREFIX
KEYFLAGS_MULTIMAKE	EQU	00100h	;ie, repeat of a "toggle" key
KEYFLAGS_USEDACCENT	EQU	00200h	;key translated using previous accent

;Flags for various fields in the KXF structure

KXFXLATE_ACCENTMASK	EQU	007h	;previous accent # saved here
KXFXLATE_SGPAUSED	EQU	008h	;session currently paused
KXFXLATE_USECHAR3	EQU	010h	;use CHAR3 as index into accent tbl
KXFXLATE_CTRLEMULATED	EQU	020h	;CTRL key emulated by enhanced kbd
KXFXLATE_E1PREFIX	EQU	040h	;E1 prefix just seen
KXFXLATE_ACCENTINDEX3	EQU	080h	;chr3 of XlateTable index accent table

KXFKEY_DUMPKEYONCE	EQU	001h	;dump key sequence has been hit once
KXFKEY_PRTSCDOWN	EQU	002h	;PrtSc is down now
KXFKEY_SECPREFIX	EQU	004h	;E0 or E1 prefix just seen
KXFKEY_NORMALALTDOWN	EQU	008h	;normal Alt down (not AltGraph)

KXFSPEC_ALT2PAC		EQU	001h	;alt-pad: use two xlation key packets
KXFSPEC_E02PAC	EQU	002h	;E0: use two xlation key packets
KXFSPEC_ACCENT2PAC	EQU	004h	;accent: use two xlation key packets
KXFSPEC_ACCENT1PAC	EQU	008h	;accent: use one xlation key packets
KXFSPEC_USE2PAC		EQU	080h	;use two xlation key packets

KXFMODE_SHIFTREPORT	EQU	001h	;not needed for VDM support
KXFMODE_BINARY	EQU	080h	;set for normal VDM translation
