;***    Physical Timer Device (TIMER)
;*
;*      SCCSID = @(#)timer.h    6.2 91/02/18
;*
;*      Timer hardware constants declaration.  This includes port
;*      addresses, bit fields and interrupt constants.
;*
;*      Copyright (c) 1988,1989 Microsoft Corporation
;*
;*      MODIFICATION HISTORY
;*          12/19/88  MTS    Created.
;  
;  Ports (for both PC/AT and PS/2)
PORT_CNT0	EQU	40H     ; counter 0 data port
PORT_CNT1	EQU	41H     ; counter 1 data port
PORT_CNT2	EQU	42H     ; counter 2 data port
PORT_CW	EQU	43H     ; control word for all counters
PORT_SYSB	EQU	61H     ; system control port B
;  Values that can be written to PORT_CW
CW_BCD	EQU	01H     ; bit set => BCD counting; bit clear => binary
CW_CNTMODE	EQU	0eH     ; count mode 0 to 5
CW_RWMODE	EQU	30H     ; Read/Write modes
CW_SELCNT	EQU	0c0H     ; select counter
;  Values that can be written to the CW_CNTMODE field of PORT_CW
CM_MODE0	EQU	00H     ; Mode 0: Interrupt on terminal count
CM_MODE1	EQU	02H     ; Mode 1: Hardware retriggerable one-shot
CM_MODE2	EQU	04H     ; Mode 2: Rate generator
CM_MODE3	EQU	06H     ; Mode 3: Square wave mode
CM_MODE4	EQU	08H     ; Mode 4: S/W triggered strobe
CM_MODE5	EQU	0aH     ; Mode 5: H/W triggered strobe (retriggerable)
CM_CNT0	EQU	02H     ; Counter 0 in Read-Back command
CM_CNT1	EQU	04H     ; Counter 1 in Read-Back command
CM_CNT2	EQU	08H     ; Counter 2 in Read-Back command
;  Values that can be written to the CW_RWMODE field of PORT_CW
RW_LATCHCNT	EQU	00H     ; Latch counter command
RW_LSB	EQU	10H     ; Read/Write least significant byte only
RW_MSB	EQU	20H     ; Read/Write most significant byte only
RW_LSBMSB	EQU	30H     ; Read/Write LSB first, then MSB
RW_NOLATCHCOUNT	EQU	20H     ; No latch count in Read-Back command
RW_NOLATCHSTATUS	EQU	10H    ; No latch status in Read-Back command
;  Values that can be written to the CW_SELCNT field of PORT_CW
SC_CNT0	EQU	00H     ; Counter 0
SC_CNT1	EQU	40H     ; Counter 1
SC_CNT2	EQU	80H     ; Counter 2
SC_READBACK	EQU	0c0H     ; Read-Back command
;  Read-Back command format (write to PORT_CW)
RB_SELCNT0	EQU	02H     ; select counter 0
RB_SELCNT1	EQU	04H     ; select counter 1
RB_SELCNT2	EQU	08H     ; select counter 2
RB_NOLATCHSTATUS	EQU	10H    ; bit clear => latch status of counters
RB_NOLATCHCNT	EQU	20H     ; bit clear => latch count of counters
;  Status Byte format (read from corresponding counter data port)
STATUS_BCD	EQU	CW_BCD  ; counter is in BCD counting mode
STATUS_CNTMODE	EQU	CW_CNTMODE; counter mode (see CM_MODEx definitions)
STATUS_RWMODE	EQU	CW_RWMODE; Read/Write mode (see RW_* definitions)
STATUS_NULLCNT	EQU	40H     ; Null count (new count has not been loaded)
STATUS_OUTPUT	EQU	80H     ; state of output pin of counter
;  System Control Port B Format
SYSB_RESETIRQ0	EQU	80H     ; set this bit to reset IRQ0 (W)
SYSB_PARITYCHK	EQU	80H     ; parity check has occurred (R)
SYSB_CHNCHK	EQU	40H     ; channel check has occurred (R)
SYSB_SPKOUT	EQU	20H     ; speaker timer output state (R)
SYSB_REFREQ	EQU	10H     ; refresh request toggle (R)
SYSB_PARITYENABLE	EQU	08H   ; parity check enable (R/W)
SYSB_CHNCHKENABLE	EQU	04H   ; channel check enable (R/W)
SYSB_SPKENABLE	EQU	02H     ; speaker data enable (R/W)
SYSB_SPKGATE	EQU	01H     ; speaker timer gate enable (R/W)
SYSB_SPKBITS	EQU	03H     ; speaker bit mask
;  Miscellaneous constants
TIMERIRQ	EQU	00H     ; IRQ number of timer interrupt
TIMERFREQ	EQU	1193167  ; timer frequency in Hz
