; static char *SCCSID = "@(#)kbd.h      6.1 90/11/15";  
;***    Keyboard Device Driver (KBD)
;*
;*      SCCSID = @(#)kbd.h       13.11 90/08/02
;*
;*      KBD public constants.
;*      Copyright (c) 1988,1989 Microsoft Corporation
;*
;*      MODIFICATION HISTORY
;*          01/30/89  MTS    Created.
;  
;  Ports (for both PC/AT and PS/2)
PORT_BUFFER	EQU	60H 
PORT_CMD	EQU	64H 
PORT_STATUS	EQU	64H 
;  Output states for PORT_BUFFER (ie, which virtual byte it's pointing to)
PORTBUFF_KBD	EQU	0        ; normal condition
PORTBUFF_COMMAND	EQU	1        ; set by CMD_WRITECOMMAND
PORTBUFF_OUTPUT	EQU	2        ; set by CMD_WRITEOUTPUT
PORTBUFF_KYBD_OUTPUT	EQU	3        ; set by CMD_WRITE_KYBD_OUTPUT
;  Values that can be written to PORT_CMD
CMD_READCOMMAND	EQU	20H     ; supported
CMD_PS2_READMEMLO	EQU	21H     ; NOT SUPPORTED
CMD_PS2_READMEMHI	EQU	3fH     ; NOT SUPPORTED
CMD_WRITECOMMAND	EQU	60H     ; supported
CMD_PS2_WRITEMEMLO	EQU	61H     ; NOT SUPPORTED
CMD_PS2_WRITEMEMHI	EQU	7fH     ; NOT SUPPORTED
CMD_PS2_TESTPW	EQU	0a4H     ; NOT SUPPORTED
CMD_PS2_LOADPW	EQU	0a5H     ; NOT SUPPORTED
CMD_PS2_ENABLEPW	EQU	0a6H     ; NOT SUPPORTED
CMD_AUXILIARYLO	EQU	0a7H     ; NOT SUPPORTED
CMD_AUXILIARYHI	EQU	0a9H     ; NOT SUPPORTED
CMD_SELFTEST	EQU	0aaH     ; supported(always return SCAN_TESTDONE)
CMD_INTERFACETEST	EQU	0abH     ; supported (always return ZERO)
CMD_DIAGNOSTICDUMP	EQU	0acH     ; NOT SUPPORTED
CMD_DISABLEKBD	EQU	0adH     ; supported
CMD_ENABLEKBD	EQU	0aeH     ; supported
CMD_READINPUT	EQU	0c0H     ; supported
CMD_PS2_READINLO	EQU	0c1H     ; NOT SUPPORTED
CMD_PS2_READINHI	EQU	0c2H     ; NOT SUPPORTED
CMD_READOUTPUT	EQU	0d0H     ; supported
CMD_WRITEOUTPUT	EQU	0d1H     ; supported
CMD_WRITE_KYBD_OUTPUT	EQU	0d2H     ; supported
CMD_PS2_WRITEOUTLO	EQU	0d3H     ; NOT SUPPORTED
CMD_PS2_WRITEOUTHI	EQU	0d4H     ; NOT SUPPORTED
CMD_READTESTINPUT	EQU	0e0H     ; supported
CMD_PULSEOUTPUTLO	EQU	0f0H     ; supported
CMD_PULSEOUTPUTHI	EQU	0ffH     ; supported
;  Values that can be read from PORT_CMD (the Status byte)
STATUS_BUFFERFULL	EQU	01H     ; set when virtBuff is valid
STATUS_CMDFULL	EQU	02H     ; always clear
STATUS_SYSFLAG	EQU	04H     ; transferred from Command byte
STATUS_DATAEXPECTED	EQU	08H     ; set after write to PORT_CMD
STATUS_NOTINHIBITED	EQU	10H     ; keyboard is not inhibited (locked)
STATUS_XMITTIMEOUT	EQU	20H     ; always clear
STATUS_RECVTIMEOUT	EQU	40H     ; always clear
STATUS_PARITYERROR	EQU	80H     ; always clear
;  Values that can be written to PORT_BUFFER (when it's the Kbd byte)
KBD_SETLEDS	EQU	0edH     ; supported (responds SCAN_ACK)
KBD_ECHO	EQU	0eeH     ; supported (responds SCAN_ECHO)
KBD_NEW_SETSCAN	EQU	0f0H     ; NOT SUPPORTED
KBD_REPORTID	EQU	0f2H     ; supported (responds 1 or 2 ID bytes)
KBD_SETREPEAT	EQU	0f3H     ; supported (responds SCAN_ACK)
KBD_ENABLE	EQU	0f4H     ; supported (responds SCAN_ACK)
KBD_DEFDISABLE	EQU	0f5H     ; supported (responds SCAN_ACK)
KBD_SETDEFAULT	EQU	0f6H     ; supported (responds SCAN_ACK)
KBD_NEW_REPT	EQU	0f7H     ; ignored   (responds SCAN_ACK)
KBD_NEW_MAKEBRK	EQU	0f8H     ; ignored   (responds SCAN_ACK)
KBD_NEW_MAKEONLY	EQU	0f9H     ; ignored   (responds SCAN_ACK)
KBD_NEW_REPTMAKEBRK	EQU	0faH     ; ignored   (responds SCAN_ACK)
KBD_NEW_KEYREPT	EQU	0fbH     ; ignored   (responds SCAN_ACK)
KBD_NEW_KEYMAKEBRK	EQU	0fcH     ; ignored   (responds SCAN_ACK)
KBD_NEW_KEYMAKEONLY	EQU	0fdH     ; ignored   (responds SCAN_ACK)
KBD_RESEND	EQU	0feH     ; supported (responds w/last scan sent)
KBD_RESET	EQU	0ffH     ; supported (responds SCAN_ACK ...)
KBD_LOWEST	EQU	0edH     ; lowest keyboard command code
KBD_HIGHEST	EQU	0ffH     ; highest keyboard command code
;  Bit masks for the parameter of KBD_SETREPEAT
REPEAT_RATEMASK	EQU	1fH     ; typematic rate
REPEAT_DELAYMASK	EQU	60H     ; typematic delay
;  Values returned by KBD_REPORTID
KBDID_ENHANCED1	EQU	0abH     ; Common 1st ID byte for Enhanced.
KBDID_ENHANCED2	EQU	41H     ; Various 2nd ID bytes returned for
KBDID_ENHANCED2A	EQU	54H     ;   Enhanced keyboards.
KBDID_ENHANCED2B	EQU	85H 
;  Values that can be written to PORT_BUFFER (when it's the Command byte)
COMMAND_INTENABLE	EQU	01H     ; controls interrupt simulation
COMMAND_SYSFLAG	EQU	04H     ; transferred to Status byte
COMMAND_NOINHIBIT	EQU	08H     ; ignored (but retained in Command byte)
COMMAND_DISABLEKBD	EQU	10H     ; disables further data
COMMAND_PCMODE	EQU	20H     ; NOT SUPPORTED
COMMAND_XLTMODE	EQU	40H     ; NOT SUPPORTED
;  Values that can be read from PORT_BUFFER (when it's the Input byte)
INPUT_RESERVED	EQU	0fH     ; reserved bits
INPUT_256K	EQU	10H     ; generally always set (>=512k)
INPUT_NOJUMPER	EQU	20H     ; always set
INPUT_MONO	EQU	40H     ; always clear
INPUT_NOTINHIBITED	EQU	80H     ; set based on physical hardware
;  Values that can be read/written via PORT_BUFFER (when it's the Output byte)
OUTPUT_CPURESET	EQU	01H     ; NOT SUPPORTED
OUTPUT_A20	EQU	02H     ; state depends on VDMM A20 flag
OUTPUT_RESERVED	EQU	0cH     ; reserved bits
OUTPUT_BUFFERFULL	EQU	10H     ; forces STATUS_BUFFERFULL to go high
OUTPUT_CMDEMPTY	EQU	20H     ; forces STATUS_CMDFULL to inverse
OUTPUT_KBDDATA	EQU	40H     ; keyboard data (output)
OUTPUT_KBDCLOCK	EQU	80H     ; keyboard clock (output)
;  Bit masks of test inputs
TESTINPUT_T0	EQU	01H 
TESTINPUT_T1	EQU	02H 
;  LED state codes
LED_SCROLLLOCK	EQU	01H     ; set Scroll lock indicator on
LED_NUMLOCK	EQU	02H     ; set Num lock indicator on
LED_CAPSLOCK	EQU	04H     ; set Cap lock indicator on
LED_ALL	EQU	(LED_SCROLLLOCK + LED_NUMLOCK + LED_CAPSLOCK)
;  Common scan codes
SCAN_TESTDONE	EQU	55H     ; ???reply scan code after kbd test
SCAN_BATCOMPLETE	EQU	0aaH     ; reply scan code after BAT
SCAN_HIGHESTKEY	EQU	0e1H     ; highest that isn't treated specially
SCAN_E0PREFIX	EQU	0e0H     ; send as a prefix to some extended keys
SCAN_E1PREFIX	EQU	0e1H     ; send as a prefix to some extended keys
SCAN_ECHO	EQU	0eeH     ; reply scan code of an ECHO command
SCAN_ACK	EQU	0faH     ; send to acknowledge kbd commands
SCAN_BATFAIL	EQU	0fcH     ; send if BAT failed (not use in VDD)
SCAN_RESEND	EQU	0feH     ; send resend req. if input was invalid
SCAN_OVERRUN	EQU	0ffH     ; send when exceed buffer capacity
SCAN_BREAKMASK	EQU	80H     ; key break mask of scan code
;  Interface Test result codes
IFTEST_NOERROR	EQU	00H     ; no error detected
IFTEST_CLOCKLOW	EQU	01H     ; keyboard clock line is stuck low
IFTEST_CLOCKHIGH	EQU	02H     ; keyboard clock line is stuck high
IFTEST_DATALOW	EQU	03H     ; keyboard data line is stuck low
IFTEST_DATAHIGH	EQU	04H     ; keyboard data line is stuck high
;  Miscellaneous constants
KBD_IRQ	EQU	1        ; keyboard IRQ number
KBDBEEP_FREQ	EQU	1000     ; keyboard beep frequency in Hz
KBDBEEP_DURATION	EQU	13       ; keyboard beep duration in ms
KBDID_UNKNOWN	EQU	0000H 
KBDID_PCAT	EQU	0100H 
KBDID_ENHANCED	EQU	41abH 
