;***	Virtual DMA Device Driver (VDMA)
;
;
;	DMA hardware constants declaration.
;	Copyright (c) 1988,1989 Microsoft Corporation
;
;
;	MODIFICATION HISTORY
;	    04/18/89  MTS    Created.
;	    05/21/90  SB     Separated out different classes and added EISA
;

MAX_DMA_CHANNEL		EQU	8

;******		   AT-Specific DMA ports     *********************

PORT_Chn0MemAddr	EQU	00000h	;Channel 0 MemAddr port
PORT_Chn0XferCnt	EQU	00001h	;Channel 0 XferCnt port
PORT_Chn1MemAddr	EQU	00002h	;Channel 1 MemAddr port
PORT_Chn1XferCnt	EQU	00003h	;Channel 1 XferCnt port
PORT_Chn2MemAddr	EQU	00004h	;Channel 2 MemAddr port
PORT_Chn2XferCnt	EQU	00005h	;Channel 2 XferCnt port
PORT_Chn3MemAddr	EQU	00006h	;Channel 3 MemAddr port
PORT_Chn3XferCnt	EQU	00007h	;Channel 3 XferCnt port
PORT_Status1	EQU	00008h	;Status for channel 0-3
PORT_WriteReq1	EQU	00009h	;DMA 1 write request port
PORT_SetResetMask1	EQU	0000ah	;DMA 1 set/reset mask port
PORT_Mode1	EQU	0000bh	;DMA 1 mode port
PORT_BytePtrFF1		EQU	0000ch	;DMA 1 byte ptr reset port
PORT_MasterClear1	EQU	0000dh	;DMA 1 master clear port
PORT_ClearMask1		EQU	0000eh	;DMA 1 clear mask bit port
PORT_WriteMask1		EQU	0000fh	;DMA 1 write mask bit port
PORT_Chn2PageAddr	EQU	00081h	;Channel 2 page address port
PORT_Chn3PageAddr	EQU	00082h	;Channel 3 page address port
PORT_Chn1PageAddr	EQU	00083h	;Channel 1 page address port
PORT_Chn0PageAddr	EQU	00087h	;Channel 0 page address port
PORT_Chn6PageAddr	EQU	00089h	;Channel 6 page address port
PORT_Chn7PageAddr	EQU	0008ah	;Channel 7 page address port
PORT_Chn5PageAddr	EQU	0008bh	;Channel 5 page address port
PORT_Chn4PageAddr	EQU	0008fh	;Channel 4 page address port
PORT_Chn4MemAddr	EQU	000c0h	;Channel 4 MemAddr port
PORT_Chn4XferCnt	EQU	000c2h	;Channel 4 XferCnt port
PORT_Chn5MemAddr	EQU	000c4h	;Channel 5 MemAddr port
PORT_Chn5XferCnt	EQU	000c6h	;Channel 5 XferCnt port
PORT_Chn6MemAddr	EQU	000c8h	;Channel 6 MemAddr port
PORT_Chn6XferCnt	EQU	000cah	;Channel 6 XferCnt port
PORT_Chn7MemAddr	EQU	000cch	;Channel 7 MemAddr port
PORT_Chn7XferCnt	EQU	000ceh	;Channel 7 XferCnt port
PORT_Status2	EQU	000d0h	;Status for channel 4-7
PORT_WriteReq2	EQU	000d2h	;DMA 2 write request port
PORT_SetResetMask2	EQU	000d4h	;DMA 2 set/reset mask port
PORT_Mode2	EQU	000d6h	;DMA 2 mode port
PORT_BytePtrFF2		EQU	000d8h	;DMA 2 byte ptr reset port
PORT_MasterClear2	EQU	000dah	;DMA 2 master clear port
PORT_ClearMask2		EQU	000dch	;DMA 2 clear mask bit port
PORT_WriteMask2		EQU	000deh	;DMA 2 write mask bit port


;******	  PS/2-Specific DMA ports and extensions *********************

PORT_ExtFunc	EQU	00018h	;Extended function port
PORT_ExtExec	EQU	0001ah	;Extended execute port


;Note: PS/2 does'nt support the following AT ports
;
;PORT_WriteReq1
;PORT_WriteReq2
;

;
;  PS/2 extended commands
;

Set_IO_Adr	EQU	00000h
Set_Mem_Adr	EQU	00020h
Get_Mem_Adr	EQU	00030h
Set_Count	EQU	00040h
Get_Count	EQU	00050h
Get_Status	EQU	00060h
Set_Mode	EQU	00070h
Set_Arbus	EQU	00080h
Set_Chn_Mask	EQU	00090h
Reset_Chn_Mask	EQU	000A0h
Master_Clear	EQU	000D0h



;********* EISA specific DMA extensions ********************************

;***
;    Channel Interrupt Status Register: (READ) (40Ah)
;
;    76543210
;    xxxxxxxx---> Interrupt on channel 0
;     OR  OR  OR  OR  OR  OR  OR ----> Interrupt on channel 1
;     OR  OR  OR  OR  OR  OR -----> Interrupt on channel 2
;     OR  OR  OR  OR  OR ------> Interrupt on channel 3
;     OR  OR  OR  OR -------> reserved
;     OR  OR  OR --------> Interrupt on channel 5
;     OR  OR ---------> Interrupt on channel 6
;     OR ----------> Interrupt on channel 7
;
;    Chaining Mode Status Register: (READ) (4D4h)
;
;    76543210
;    xxxxxxxx---> Channel 0 enabled
;     OR  OR  OR  OR  OR  OR  OR ----> Channel 1 enabled
;     OR  OR  OR  OR  OR  OR -----> Channel 2 enabled
;     OR  OR  OR  OR  OR ------> Channel 3 enabled
;     OR  OR  OR  OR -------> reserved
;     OR  OR  OR --------> Channel 5 enabled
;     OR  OR ---------> Channel 6 enabled
;     OR ----------> Channel 7 enabled
;
;    Chaining Mode Register: (WRITE) (40Ah & 4D4h)
;
;    76543210
;    xxxxxxxx
;     OR  OR  OR  OR  OR  OR  OR  OR ---> Channel 0-3 selected
;     OR  OR  OR  OR  OR  OR -----> 0-Disable, 1-Enable, 2-illegal, 3-Programming complete
;     OR  OR  OR  OR
;     OR  OR  OR  OR -------> reserved
;
;

DMA_E_IS	EQU	0040Ah	;Channel ISR (read only)
DMA_E_CS	EQU	004D4h	;Chaining mode status register (read only)

DMA_E_CH1	EQU	0040Ah	;ChainMode for channels 0-3 (write only)
DMA_E_CH2	EQU	004D4h	;ChainMode for channels 5-7 (write only)

;***   DMA Extended Mode Register: (WRITE) (40Bh & 4D6h)
;
;    76543210
;    xxxxxxxx
;     OR  OR  OR  OR  OR  OR  OR  OR ---> Channel 0-3 selected
;     OR  OR  OR  OR  OR  OR -----> 0-8/byte, 1-16/word, 2-32/byte, 3-16/byte
;     OR  OR  OR  OR -------> 0-ISA, 1-"A", 2-"B", 3-"C" (Burst)
;     OR  OR ---------> T-C is an input for this channel
;     OR ----------> Stop register disabled
;
;

DMA_E_EM1	EQU	0040Bh	    ;Extended Mode for channels 0-3
DMA_E_EM2	EQU	004D6h	    ;Extended Mode for channels 5-7

DMA_EM_Chan_Mask	EQU	00003h
DMA_EM_Chan_Size	EQU	0000ch
DMA_EM_8bit	EQU	00000h	    ;byte transfer with byte adr & cnt
DMA_EM_16bit_wc		EQU	00004h	    ;word transfer with word adr & cnt
DMA_EM_32bit	EQU	00008h	    ;dword transfer with byte adr & cnt
DMA_EM_16bit	EQU	0000ch	    ;word transfer with byte adr & cnt

DMA_E_Hoff	EQU	00400h

DMA_E_P0	EQU	00487h	    ;HiPage0 (Bits: <31.24>)
DMA_E_P1	EQU	00483h	    ;HiPage1
DMA_E_P2	EQU	00481h	    ;HiPage2
DMA_E_P3	EQU	00482h	    ;HiPage3
DMA_E_P5	EQU	0048Bh	    ;HiPage5
DMA_E_P6	EQU	00489h	    ;HiPage6
DMA_E_P7	EQU	0048Ah	    ;HiPage7

DMA_E_C0	EQU	00401h	    ;HiCount0 (Bits: <23.16>)
DMA_E_C1	EQU	00403h	    ;HiCount1
DMA_E_C2	EQU	00405h	    ;HiCount2
DMA_E_C3	EQU	00407h	    ;HiCount3
DMA_E_C5	EQU	004C6h	    ;HiCount5
DMA_E_C6	EQU	004CAh	    ;HiCount6
DMA_E_C7	EQU	004CEh	    ;HiCount7

DMA_E_S00	EQU	004E0h	    ;Stop channel 0 (Bits: <7:2> )
DMA_E_S01	EQU	004E1h	    ;Stop channel 0 (Bits: <15.8> )
DMA_E_S02	EQU	004E2h	    ;Stop channel 0 (Bits: <23.16> )
DMA_E_S10	EQU	004E4h	    ;Stop channel 1 (Bits: <7:2> )
DMA_E_S11	EQU	004E5h	    ;Stop channel 1 (Bits: <15.8> )
DMA_E_S12	EQU	004E6h	    ;Stop channel 1 (Bits: <23.16> )
DMA_E_S20	EQU	004E8h	    ;Stop channel 2 (Bits: <7:2> )
DMA_E_S21	EQU	004E9h	    ;Stop channel 2 (Bits: <15.8> )
DMA_E_S22	EQU	004EAh	    ;Stop channel 2 (Bits: <23.16> )
DMA_E_S30	EQU	004ECh	    ;Stop channel 3 (Bits: <7:2> )
DMA_E_S31	EQU	004EDh	    ;Stop channel 3 (Bits: <15.8> )
DMA_E_S32	EQU	004EEh	    ;Stop channel 3 (Bits: <23.16> )
DMA_E_S50	EQU	004F4h	    ;Stop channel 5 (Bits: <7:2> )
DMA_E_S51	EQU	004F5h	    ;Stop channel 5 (Bits: <15.8> )
DMA_E_S52	EQU	004F6h	    ;Stop channel 5 (Bits: <23.16> )
DMA_E_S60	EQU	004F8h	    ;Stop channel 6 (Bits: <7:2> )
DMA_E_S61	EQU	004F9h	    ;Stop channel 6 (Bits: <15.8> )
DMA_E_S62	EQU	004FAh	    ;Stop channel 6 (Bits: <23.16> )
DMA_E_S70	EQU	004FCh	    ;Stop channel 7 (Bits: <7:2> )
DMA_E_S71	EQU	004FDh	    ;Stop channel 7 (Bits: <15.8> )
DMA_E_S72	EQU	004FEh	    ;Stop channel 7 (Bits: <23.16> )


;  mode bits
;

DMA_TYPE_VERIFY		EQU	000h
DMA_TYPE_WRITE	EQU	004h
DMA_TYPE_READ	EQU	008h
DMA_AUTOINIT	EQU	010h
DMA_ADRDEC	EQU	020h

DMA_DEMAND_MODE		EQU	000h
DMA_SINGLE_MODE		EQU	040h
DMA_BLOCK_MODE	EQU	080h
DMA_CASCADE_MODE	EQU	0c0h

DMA_MODE_MASK	EQU	0c0h

DMA_CHANNEL_SEL		EQU	003h


;extended mode bits

PROGRAMMED_IO	EQU	1
TRANSFER_DATA	EQU	4
WRITE_MEM	EQU	8
XFER_16_BIT	EQU	64
XFER_BIT_16	EQU	6

;Mask Bits

DMA_MASK_SET	EQU	4


;PS/2 Function Register Channel Mask and Command Mask

EXTFUNC_CHNL_MASK	EQU	007h
EXTFUNC_CMD_MASK	EQU	0f0h
