.\" $Header: decode.1,v 2.22 88/04/06 11:48:07 mee content6 $
.\" @(#) decode.1 1.4  @(#)decode.1	1.4  12/11/85  1   
.TH DECODE 1 "" "" HP-UX
.SH NAME
decode \- symbol file decoder for gardens point modula
.SH SYNOPSIS
.br
.B decode
[
.B \-vV
]
.I file
.SH DESCRIPTION
.B decode
is a symbol file decoder for .syx files produced by 
.B gpm(1)
\&. The program understands the 
extremely compressed format of the .syx
file, and attempts to expand this back out and ``pretty print''
the result to the standard output stream.

It is of particular use in cases where long chains of type redefinitions
and procedure constant aliases have sowed the seeds of confusion in the
user. The output of the program lists type definitions together with the 
actual type name. For example if a type is an alias for another type
which in turn is an alias for 
REAL
the decode output will show that the type is actually
type REAL.
There is lots of other useful information, such as the ordinal values of 
enumeration constants.

.SS Command line options
Command line options \-v and \-V provide increasing degrees of verbosity
of output. The verbose output includes such information as type sizes and
the key values for the various modules.

.SH BUGS AND CAVEATS
The program is unable to reconstruct information, such as the dummy names of 
formal paramters which are not preserved in the symbol file.

The symbol file is designed to be a compact representation of the abstract
data structure which represents the definition descriptors of the program.
This structure is, in general a directed graph. The symbol file represents
the result of a depth\-first traversal of this graph. 
In the case of complex recursive types the output may
contain very deeply nested type definitions which do not reflect the 
original definition order, or the declaration before use rule. Deeply
nested variant records are particularly difficult for the human reader.
