/*
 *   strstream.h
 *
 *   C++ IOStreams specialized for use with strings.
 *
 *           Copyright (c) 1991-1992, MetaWare Incorporated
 */

#ifndef __STRSTREAM_H
#define __STRSTREAM_H
#pragma push_align_members(64);

#if _MSDOS && !__EXCEPTIONS__
    #pragma off(exception_aware_class);
#elif _MSDOS || _MSNT || _OS2
    #pragma on(exception_aware_class);
#endif

#if _MSNT && _DLL && !_DLLBUILD
    #pragma on(dllimport);
#endif

#c_include <iostream.h>

#pragma on(nodebug);

class strstreambuf : public streambuf {
private:
	void		init(char* __base, int __len,char* __put_origin);
	void*		(*alloc_fcn)(long);	// fcn used to allocate space
	void		(*free_fcn)(void*);	// fcn used to free space
	enum strflags	{
			  ignore_oflow =  0x01,	// Ignore overflow condition
			  auto_extend  =  0x02,	// Reallocate buffer when full
			  frozen       =  0x04	// Buffer frozen--inserts fail
			};
	long		_strflags;		// status flags
	int		next_min_alloc;

public: 
			strstreambuf();
			strstreambuf(int __min_size);
			strstreambuf(void* (*__alloc)(long),
					void (*__free)(void*));
			strstreambuf(char* __base, int __len,
					char* __put_origin = 0 );
			strstreambuf(unsigned char* __base, int __len,
					unsigned char* __put_origin = 0 );
			~strstreambuf();

	void		_UNSAFE(freeze)(int __frozen=1);
	char*		str();
	// nothing to do in sync(), since external representation of a string
	// stream buffer is the stream buffer itself and the buffer pointers
	// are already in sync.
        int             _UNSAFE(sync)() {
                                return 0;
                        }
	virtual int	_UNSAFE(doallocate)();
	virtual int	_UNSAFE(overflow)(int __c);
	virtual int	_UNSAFE(underflow)();
	virtual streambuf*
			setbuf(char*, int __len);
	virtual streampos
			_UNSAFE(seekoff)(streamoff __offset,
				ios::seek_dir __dir, long __mode);

#if _MT
public:
	void		freeze(int __frozen=1);
	int		sync(){
				return(sync_unsafe());
			}
	virtual int	doallocate();
	virtual int	overflow(int __c);
	virtual int	underflow();
	virtual streampos
			seekoff(streamoff __offset, ios::seek_dir __dir,
					long __mode);
#endif
	};

class strstreambase : public virtual ios {
private:
	strstreambuf	buf; 
protected:	
			strstreambase(char* __base, int __len,
					char* __put_origin);
			strstreambase();
			~strstreambase();
public:
	strstreambuf*	rdbuf();
	};

class istrstream : public strstreambase, public istream {
public:
			istrstream(char* __base);
			istrstream(char* __base, int __len);
			~istrstream();
	};

class ostrstream : public strstreambase, public ostream {
public:
			ostrstream(char* __base, int __len,
					int __mode=ios::out);
			ostrstream();
			~ostrstream();
	char*		str();
	int		pcount();
	};


class strstream : public strstreambase, public iostream {
public:
			strstream();
			strstream(char* __base, int __len, int __mode);
			~strstream();
	char*		str();
	};

#pragma pop(nodebug);

#if _MSNT && _DLL && !_DLLBUILD
    #pragma pop(dllimport);
#endif

#if _MSDOS || _MSNT || _OS2
    #pragma pop(exception_aware_class);
#endif

#pragma pop_align_members();
#endif __STRSTREAM_H

/**          Copyright (c) 1991-1992, MetaWare Incorporated             **/
