/*
 *   stdiostr.h
 *
 *   C++ IOStreams specialized for use in conjunction with
 *   stdio FILEs.
 *
 *           Copyright (c) 1991-1992, MetaWare Incorporated
 */

#ifndef __STDIOSTREAM_H
#define __STDIOSTREAM_H
#pragma push_align_members(64);

#if _MSDOS && !__EXCEPTIONS__
    #pragma off(exception_aware_class);
#elif _MSDOS || _MSNT || _OS2
    #pragma on(exception_aware_class);
#endif

#if _MSNT && _DLL && !_DLLBUILD
    #pragma on(dllimport);
#endif

#c_include <iostream.h>
#c_include <stdio.h>

#pragma on(nodebug)

/*
 *  Class stdiobuf is provided to support concurrent use of the C stdio
 *  and C++ iostreams standard input and output streams.  Using stdiobufs
 *  can cause a severe degradation in performance.  It should not be
 *  necessary to use stdiobufs if the standard output streams are set for
 *  unit buffering (ios::unitbuf) and all input operations on cin are
 *  line-oriented on a cooked input stream.
 *
 *  Use of class stdiobuf should be avoided whenever possible.
 */

class stdiobuf : public streambuf {

private:
	FILE*		_fp;			
	char		_tmp_buf[2];

public:
	virtual int	_UNSAFE(overflow)(int=EOF);
	virtual int	_UNSAFE(underflow)();
	virtual int	_UNSAFE(sync)();
	virtual streampos
			_UNSAFE(seekoff)(streamoff,ios::seek_dir,long);
	virtual int	pbackfail(int __c);

			stdiobuf(FILE* __fp);
	FILE*		stdiofile() { return _fp; }
	virtual		~stdiobuf();
#if _MT
	virtual int	overflow(int=EOF);
	virtual int	underflow();
	virtual int	sync();
	virtual streampos
			seekoff(streamoff,ios::seek_dir,long);
#endif
	};

class stdiostream : public ios {
private:
	stdiobuf	_buf;

public:
			stdiostream(FILE* __fp);
			~stdiostream();
	stdiobuf*	rdbuf() { return &_buf; }
	};

#pragma pop(nodebug)


#if _MSNT && _DLL && !_DLLBUILD
    #pragma pop(dllimport);
#endif

#if _MSDOS || _MSNT || _OS2
    #pragma pop(exception_aware_class);
#endif

#pragma pop_align_members();
#endif __STDIOSTREAM_H

/**          Copyright (c) 1991-1993, MetaWare Incorporated             **/
