/*************************************************************************
*
* filename		: sample.cpp
*
* description	: show the use of class EDITOR
*
* functions     : main			- create a little editor
*				  procTest		- editor's message processing
*
* APIs			: WinSetPointer         WinInitialize
*				  WinCreateMsgQueue		WinRegisterClass
*                 WinCreateStdWindow	WinSetWindowPos
*				  WinShowWindow			WinGetMsg
*				  WinDispatchMsg		WinDestroyMsgQueue
*				  WinTerminate			WinBeginPaint
*				  WinFillRect			WinEndPaint
*				  WinPostMsg			WinDefWindowProc
*
* Used Classes	: class EDITOR
*
* copyright (C) 1993 Jrg Caumanns (caumanns@cs.tu-berlin.de)
*
*************************************************************************/
#define INCL_WINWINDOWMGR
#define INCL_WINDIALOGS
#define INCL_WINFRAMEMGR
#define INCL_WINMESSAGES
#define INCL_WINPOINTERS
#include <os2.h>

#include "editor.h"
#include "sample.h"

/*
* forward declarations
*/
MRESULT	EXPENTRY procTest(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);


/*************************************************************************
*
* Name	: main
*
* Descr.: Create the editor main-window
*
* Impl. : Create a standard-window with 'File' and 'Edit' menus
*
* APIs 	: WinSetPointer         	WinInitialize
*	   	  WinCreateMsgQueue			WinRegisterClass
*         WinCreateStdWindow		WinSetWindowPos
*	   	  WinShowWindow				WinGetMsg
*	   	  WinDispatchMsg			WinDestroyMsgQueue
*	   	  WinTerminate
*
* Class.: [none]
*
* Param.: [none]
*
* Return: fSuccess
*
*************************************************************************/
int main(void)	{

	/*
	* change icon to clock
	*/
	WinSetPointer(HWND_DESKTOP,
					WinQuerySysPointer(HWND_DESKTOP, SPTR_WAIT, FALSE));

	/*
	* create message queue
	*/
	HAB hab;
	if((hab = WinInitialize(0)) == NULLHANDLE)	{ return 0;	}

	HMQ hmq;
	if((hmq = WinCreateMsgQueue(hab, 0)) == NULLHANDLE)	{ return 0;	}

	/*
	* register window class
	*/
	if(!WinRegisterClass(hab,
						 "TEST_MLE",
						 (PFNWP)procTest,
						 CS_SIZEREDRAW | CS_CLIPCHILDREN,
						 32L))	{
		WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
					  "Can't register window class!", "FATAL ERROR",
					  0, MB_ERROR | MB_CANCEL);
		WinDestroyMsgQueue(hmq);
		WinTerminate(hab);
		return 0;
		}

	/*
	* create main-window
	*/
	HWND hwndFrame, hwndClient;
	ULONG fctlFrame = FCF_BORDER | FCF_MENU | FCF_TASKLIST | FCF_TITLEBAR;

	if((hwndFrame = (HWND)WinCreateStdWindow(HWND_DESKTOP,
											WS_VISIBLE,
											&fctlFrame,
											"TEST_MLE",
											"MiniEditor",
											0,
											(HMODULE)NULL,
											IDR_TEST,
											&hwndClient)) == NULLHANDLE)	{
		WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
					  "Can't create window!", "FATAL ERROR",
					  0, MB_ERROR | MB_CANCEL);
		WinDestroyMsgQueue(hmq);
		WinTerminate(hab);
		return 0;
		}

	SWP swp;
	WinQueryWindowPos(HWND_DESKTOP, &swp);
	WinSetWindowPos(hwndFrame,
					HWND_TOP,
					swp.x + swp.cx - 160,
					swp.y + swp.cy - 40,
					160,
					40,
					SWP_MOVE | SWP_SIZE | SWP_ACTIVATE);
	WinShowWindow(hwndFrame, 1);

	/*
	* Message-Loop
	*/
	QMSG  qmsg;
	while(WinGetMsg(hmq, (PQMSG)&qmsg, NULLHANDLE, 0, 0))
		WinDispatchMsg(hmq, (PQMSG)&qmsg);

	/*
	* Termination
	*/
	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	return 1;
	}


/*************************************************************************
*
* Name	: procTest
*
* Descr.: Main-window message-processing
*
* Impl. : Create an instance of class EDITOR and send all menu-commands
*		  to it.
*
* APIs	: WinPostMsg				WinBeginPaint
*		  WinFillRect				WinEndPaint
*		  WinDefWindowProc
*
* Class.: class EDITOR	- create and manage MLEs
*
* Param.: HWND	 hwnd	 - window handle (client area)
*		  ULONG  msg  	 - message ID
*		  MPARAM mp1,mp2 - message parameters
*
* return: message result
*
*************************************************************************/
MRESULT	EXPENTRY procTest(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)	{
	HPS hps;
	RECTL rcl;
	static EDITOR *fm;

	switch(msg)	{

		/*
		* client window creation
		*/
		case WM_CREATE:
			fm = new EDITOR;
			break;

		/*
		* repaint the client area
		*/
		case WM_PAINT:
			hps = WinBeginPaint(hwnd, (HPS)NULL, &rcl);
			WinFillRect(hps, &rcl, CLR_BACKGROUND);
			WinEndPaint(hps);
			break;

		/*
		* a menu was selected
		*/
		case WM_COMMAND:

			switch(SHORT1FROMMP(mp1))	{
				case IDM_NEW:
					fm->NewFile();  	// create an empty MLE
					break;

				case IDM_OPEN:
					fm->OpenFile();		// create an MLE and load a file
					break;				// into it

				case IDM_SAVE:
					fm->SaveFile();		// save the contents of the
					break;				// active MLE

				case IDM_SAVEAS:        // save the contents of the
					fm->SaveFileAs();	// active MLE after asking for
					break;				// a new filename

				case IDM_EXIT:
					WinPostMsg(hwnd, WM_CLOSE, MPVOID, MPVOID);
					break;

				case IDM_CUT:			// cut, copy, paste and clear
					fm->Cut();			// do the appropriate actions
					break;				// on the marked area of the
				case IDM_COPY:			// active MLE.
					fm->Copy();
					break;
				case IDM_PASTE:
					fm->Paste();
					break;
				case IDM_CLEAR:
					fm->Clear();
					break;

				case IDM_BLUEWHITE:		// change MLE colors
					fm->SetColor(CLR_DARKBLUE, CLR_WHITE);
					break;
				case IDM_WHITEBLUE:
					fm->SetColor(CLR_WHITE, CLR_DARKBLUE);
					break;
				default:
					break;
				}
			break;

		case WM_CLOSE:					// close all open MLEs (and ask
			fm->CloseAllFiles();		// the user if its contents
										// should be saved
		default:
			return(WinDefWindowProc(hwnd, msg, mp1, mp2));
		}
	return((MRESULT)NULL);
	}


