/*************************************************************************
*
* filename		: editor.h
*
* description	: header file for class EDITOR
*
* exp. types	: struct MLE_LIST	- chain MLEs together
*				  class  EDITOR		- handle many MLEs
*
* used classes	: class  MLE
*
* copyright (C) 1993 Jrg Caumanns (caumanns@cs.tu-berlin.de)
*
*************************************************************************/
#ifndef _EDITOR_INCLUDED
#define _EDITOR_INCLUDED

#include <os2def.h>
#include "mle.h"

/**
* struct MLE_LIST: class EDITOR handles a linked list of MLEs (Multi-Line
*				   entry-fields). MLE_LIST is used to link the MLEs.
**/
struct MLE_LIST	{
	MLE			*pmle;
	MLE_LIST    *next;
	};


/*************************************************************************
*
* class	: EDITOR
*
* descr.: manage a list of Multi-Line Entryfields (e.g for "file"-menus)
*
* method: NewFile		Create an empty MLE. This method could e.g. be
*						called after menu "file / new" was selected.
*		  OpenFile		Create an MLE and load a file to it. If no
*					    filename is specified, the user is asked to enter
*						a name ("open"-dialogbox). The method could be
*						called with no parameter as a responce to
*					    menu "file / open...".
*		  SaveFile		If a filename is given as an argument the
*						contents of the MLE to which this file was loaded
*						is saved. If no argument is given, the contents
*						of the active MLE is saved. If no file is associated
*					    with this MLE (e.g. it was created by "NewFile"),
*						the user is asked to enter a filename
*						("save as"-dialogbox). This method could be used
*					    for menu "file / save".
*		  SaveFileAs	If a filename is given as an argument the
*						contents of the MLE to which this file was loaded
*						is saved. If no argument is given, the contents
*						of the active MLE is saved. Before saving the user
*					    the user is asked to enter a new name for the
*						file ("save as"-dialogbox). This method could
*					    be used for menu "file / save as...".*		  SaveAllFiles  The contents of all MLEs are saved. If an MLE
*					    is not associated with a file, the user is asked
*						to enter a filename ("save as"-dialogbox). This
*						method could be used for menu "file / save all".
*		  CloseFile     If a filename is given as an argument the MLE
*						to which this file aws loaded is closed. If no
*						argument is given, the active MLE is closed.
*						If the contents of the MLE to be closed has
*						changed, "SaveFile" is called by this method
*						before closing the MLE.
*		  CloseAllFiles "CloseFile" is called for all MLEs. This method
*						should be called before terminating an
*						application that used class EDITOR.
*		  Cut			Remove the selected text of the active MLE and put
*						it in the clipboard. (menu "edit / cut")
*		  Copy          Copy the selected text of the active MLE to the
*						clipboard. (menu "edit / copy")
*		  Paste			Insert text from the clipboard at the cursor-
*						position of the active MLE (menu "edit / paste").
*		  Clear			Delete the selected text of the active MLE
*						(menu "edit / clear").
*
* uses	: class MLE
*
*************************************************************************/
class EDITOR	{
		MLE_LIST *pmlelist;
		MLE  *WindowFromFile(CHAR *);
		MLE  *ActiveWindow(VOID);
	public:
		EDITOR();
		BOOL NewFile(VOID);
		BOOL OpenFile(CHAR *pszFile = (CHAR *)0);
		BOOL SaveFile(CHAR *pszFile = (CHAR *)0);
		BOOL SaveFileAs(CHAR *pszFile = (CHAR *)0);
		BOOL SaveAllFiles(VOID);
		BOOL CloseFile(CHAR *pszFile = (CHAR *)0);
		BOOL CloseAllFiles(VOID);
		VOID Cut(VOID);
		VOID Copy(VOID);
		VOID Paste(VOID);
		VOID Clear(VOID);
		VOID SetColor(LONG clrForeground, LONG clrBackground);
		~EDITOR();
		};

/*
* inline methods of class EDITOR
*/
inline EDITOR::EDITOR()	{			// constructor
	pmlelist = (MLE_LIST *)0;
	}

#endif 	/* !_EDITOR_INCLUDED	*/
