/*----------------------------------------------------------------------*/
/* Copyright(C) 1997, Tomoki Yoshioka. All rights reserved.             */
/* TvF\[X݂̂̂ckk쐬B                           */
/* ֐ꗗFstatic int  Usage(char *)                                  */
/* @@@@Fstatic int  load_resource(char *)                          */
/* @@@@Fstatic int  save_file(char *, char *, ULONG)               */
/* @@@@Fstatic int  make_obj(char *, char *)                       */
/* @@@@Fstatic void get_base_name(char *, char *, char *)          */
/* @@@@Fstatic int  make_def_file(char *, char *)                  */
/* @@@@Fstatic int  link_obj(char *, char *, char *)               */
/* @@@@Fstatic int  make_dll(char *, char *)                       */
/* @@@@Fstatic int  make_dll_main(char *, char *, char *)          */
/* @@@@Fextern int  main(int, char *[])                            */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <io.h>
#include <fcntl.h>
#define INCL_DOS
#include <os2.h>
#include "mkresdll.h"


#define NO_ERROR	(0)
#define ERROR		(-1)


/*----------------------------------------------------------------------*/
/* ֐Fint  Usage(szPrgName) ;                                      */
/* @\@Fg\B                                           */
/* ́@Fchar  *szPrgName ; vO                              */
/* ó@FȂ                                                         */
/* AlF0 Ԃ܂B                                               */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
int Usage(char *szPrgName)
{
	char  szDrive[_MAX_DRIVE] ;
	char  szDir[_MAX_DIR] ;
	char  szFName[_MAX_FNAME] ;
	char  szExt[_MAX_EXT] ;
	_splitpath(szPrgName, szDrive, szDir, szFName, szExt) ;

	printf("Usage : %s  RCFileName\n", szFName) ;

	return NO_ERROR ;
}


/*----------------------------------------------------------------------*/
/* ֐Fint  load_resource(buffer) ;                                 */
/* @\@Fckk쐬pIuWFNgt@C\[XoB     */
/* ́@Fchar  *buffer ; \[Xǂݍݗpobt@̃AhX         */
/* @@@FULONG *pnSize ; obt@̃TCY                             */
/* ó@Fchar *buffer  ; \[Xǂݍ .OBJ t@C̃f[^ */
/* @@@FULONG *pnSize ; \[Xǂݍ .OBJ t@C̃TCY */
/* AlFG[R[h                                                 */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
static int  load_resource(char *buffer, ULONG *pnSize)
{
	int  rc ;
	ULONG ulResSize ;
	PBYTE pbResource = NULL ;

	rc = (int)DosQueryResourceSize(
						NULLHANDLE, RT_MAKEDLL, IDR_MAKEDLL, &ulResSize) ;
	if (rc != NO_ERROR) return rc ;
	if (ulResSize > *pnSize) return ERROR ;
	/* \[Xւ̃|C^擾܂B*/
	rc = (int)DosGetResource(
						NULL, RT_MAKEDLL, IDR_MAKEDLL, (PPVOID)&pbResource) ;
	if (rc != NO_ERROR) return rc ;
	/* \[Xɓǂݍ݂܂B*/
	memcpy(buffer, pbResource, ulResSize) ;
	/* \[XB*/
	DosFreeResource(pbResource) ;
	/* ǂݍ񂾃\[X̃TCYi[B*/
	*pnSize = ulResSize ;
	/* ʂԂB*/
	return rc ;
}


/*----------------------------------------------------------------------*/
/* ֐Fint  save_file(szFileName, buffer, size) ;                   */
/* @\@Ft@CɏoB                                         */
/* ́@Fchar  *szFileName ; t@C                               */
/* @@@Fchar  *buffer ; of[^                               */
/* @@@FULONG size ; f[^̃TCY                                  */
/* ó@FȂ                                                         */
/* AlFG[R[h                                                 */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
static int save_file(char *szFileName, char *buffer, ULONG size)
{
	int fd ;
	fd = open(szFileName, O_WRONLY | O_CREAT | O_EXCL, S_IREAD | S_IWRITE) ;
	if (fd == -1) return ERROR ;
	if (write(fd, buffer, size) != size) {
		close(fd) ;
		return ERROR ;
	}
	close(fd) ;
	return NO_ERROR ;
}


/*----------------------------------------------------------------------*/
/* ֐Fint  make_obj(szPath, szObjName) ;                           */
/* @\@Fckk쐬pIuWFNgt@C\[XoB     */
/* ́@Fchar *szPath ; IuWFNgt@Ci[pX                  */
/* @@@Fchar *szObjName ; IuWFNgt@Ci[̈             */
/* ó@Fchar *szObjName ; IuWFNgt@C                     */
/* AlFG[R[h                                                 */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
static int make_obj(char *szPath, char *szObjName)
{
	int   rc ;
	ULONG size ;
	char  szDrive[_MAX_DRIVE] ;
	char  szDir[_MAX_DIR] ;
	char  szFName[_MAX_FNAME] ;
	char  szExt[_MAX_EXT] ;
	char  buffer[128] ;
	/* IuWFNgi[pX擾B*/
	_splitpath(szPath, szDrive, szDir, szFName, szExt) ;
	/* IuWFNgt@C𐶐B*/
	_makepath(szObjName, szDrive, szDir, "MKRESBAS", ".OBJ") ;
	/* \[XIuWFNgt@CǂݍށB*/
	size = sizeof(buffer) ;
	rc = load_resource(buffer, &size) ;
	if (rc != NO_ERROR) return rc ;
	/* ǂݍ񂾃f[^t@CɏށB*/
	return save_file(szObjName, buffer, size) ;
}


/*----------------------------------------------------------------------*/
/* ֐Fvoid get_base_name(src, path, name) ;                        */
/* @\@Ft@C̃x[Xt@C擾B                       */
/* ́@Fchar *src  ; \[X`t@C                          */
/* @@@Fchar *path ; pXi[̈                                  */
/* @@@Fchar *name ; W[i[̈                            */
/* ó@Fchar *path ; pX                                          */
/* @@@Fchar *name ; W[                                    */
/* AlFȂ                                                         */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
static void get_base_name(char *src, char *path, char *name)
{
	char szDrive[_MAX_DRIVE] ;
	char szDir[_MAX_DIR] ;
	char szFName[_MAX_FNAME] ;
	char szExt[_MAX_EXT] ;
	/* t@C𕪉 */
	_splitpath(src, szDrive, szDir, szFName, szExt) ;
	/* pXi[B*/
	strcpy(path, szDrive) ;
	strcat(path, szDir) ;
	/* W[i[B*/
	strcpy(name, szFName) ;
}


/*----------------------------------------------------------------------*/
/* ֐Fint  make_def_file(szDefFile, szModule) ;                    */
/* @\@F.DEF t@C쐬B                                    */
/* ́@Fchar *szDefFile; .DEF t@C                             */
/* @@@Fchar *szModule ; W[                                */
/* ó@FȂ                                                         */
/* AlFG[R[h                                                 */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
static int make_def_file(char *szDefFile, char *szModule)
{
	int fd ;
	int len ;
	char buffer[256] ;

	/* .DEF t@CJ */
	fd = open(szDefFile, O_WRONLY | O_CREAT | O_EXCL, S_IREAD | S_IWRITE) ;
	if (fd == -1) return ERROR ;
	len = sprintf(buffer, "LIBRARY %s\n", szModule) ;
	if (write(fd, buffer, len) != len) {
		close(fd) ;
		return ERROR ;
	}
	len = sprintf(buffer, "PROTMODE\n") ;
	if (write(fd, buffer, len) != len) {
		close(fd) ;
		return ERROR ;
	}
	close(fd) ;
	return NO_ERROR ;
}


/*----------------------------------------------------------------------*/
/* ֐Fint  link_obj(szObjName, szDefFile, szDllName) ;             */
/* @\@F.OBJ, .DEF t@CNA.DLL 𐶐B             */
/* ́@Fchar *szObjName ; .OBJ t@C                            */
/* @@@Fchar *szDefFile ; .DEF t@C                            */
/* @@@Fchar *szDllName ; .DLL t@C                            */
/* ó@FȂ                                                         */
/* AlFG[R[h                                                 */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
static int link_obj(char *szObjName, char *szDefFile, char *szDllName)
{
	static char lkcmd[] = "link386" ;
	char buffer[_MAX_PATH * 2] ;
	sprintf(buffer, "%s,%s,nul,,%s", szObjName, szDllName, szDefFile) ;
	return spawnlp(P_WAIT, lkcmd, lkcmd, buffer, NULL) ;
}


/*----------------------------------------------------------------------*/
/* ֐Fint  make_dll(szRcName, szDllName) ;                         */
/* @\@F.RC, .DLL t@CA\[Xt.DLL 𐶐B  */
/* ́@Fchar *szRcName  ; .RC  t@C                            */
/* @@@Fchar *szDllName ; .DLL t@C                            */
/* ó@FȂ                                                         */
/* AlFG[R[h                                                 */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
static int make_dll(char *szRcName, char *szDllName)
{
	static char rccmd[] = "rc" ;
	return spawnlp(P_WAIT, rccmd, rccmd, szRcName, szDllName, NULL) ;
}


/*----------------------------------------------------------------------*/
/* ֐Fint  make_dll_main(szObjName, szPath, szModule) ;            */
/* @\@F쐬ckk̃x[Xt@C擾B                 */
/* ́@Fchar *szObjName ; ckk쐬Ɏgp.OBJt@C         */
/* @@@Fchar *szPath ; t@C쐬pX                        */
/* @@@Fchar *szModule ; W[                                */
/* ó@FȂ                                                         */
/* AlFG[R[h                                                 */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
static int make_dll_main(char *szObjName, char *szPath, char *szModule)
{
	int rc ;
	char szTmpName[_MAX_PATH] ;
	char szDllName[_MAX_PATH] ;
	strcpy(szTmpName, szPath) ;
	strcat(szTmpName, szModule) ;
	strcpy(szDllName, szTmpName) ;
	strcat(szTmpName, ".DEF") ;
	strcat(szDllName, ".DLL") ;
	/*--------------------------------------------------------------*/
	/* .DEF t@C쐬B                                    */
	/*--------------------------------------------------------------*/
	rc = make_def_file(szTmpName, szModule) ;
	if (rc != NO_ERROR) return rc ;
	/*--------------------------------------------------------------*/
	/* .OBJ + .DEF -> .DLL 쐬B                             */
	/*--------------------------------------------------------------*/
	rc = link_obj(szObjName, szTmpName, szDllName) ;
	remove(szTmpName) ;
	if (rc != NO_ERROR) return rc ;
	/*--------------------------------------------------------------*/
	/* .DLL + .RC -> .DLL 쐬B                              */
	/*--------------------------------------------------------------*/
	strcpy(szTmpName, szPath) ;
	strcat(szTmpName, szModule) ;
	rc = make_dll(szTmpName, szDllName) ;
	strcat(szTmpName, ".RES") ;
	remove(szTmpName) ;
	/*--------------------------------------------------------------*/
	/* ʂԂB                                                 */
	/*--------------------------------------------------------------*/
	return rc ;
}


/*----------------------------------------------------------------------*/
/* ֐Fint main(argc, argv) ;                                       */
/* @\@FSet Icon C                                              */
/* ́@Fint  argc    ; p[^                                  */
/* @@@Fchar *argv[] ; p[^                                    */
/* ó@FȂ                                                         */
/* AlFTRUE  ; I                                             */
/* @@@FFALSE ; ُI                                             */
/*----------------------------------------------------------------------*/
/* XV                                                             */
/* Ver.0.00 1997/10/11                                                  */
/* Eō쐬                                                           */
/*----------------------------------------------------------------------*/
int main(int argc, char *argv[])
{
	int rc ;
	if (argc < 2) {
		rc = Usage(argv[0]) ;
	} else {
		int rc ;
		char szObjName[_MAX_PATH] ;
		rc = make_obj(argv[0], szObjName) ;
		if (rc != NO_ERROR) {
			fprintf(stderr, "ERROR!:Can't make .obj file(%d)\n", rc) ;
		}
		else {
			int i ;
			for (i = 1 ; i < argc ; i++) {
				char szPath[_MAX_PATH] ;
				char szModule[_MAX_FNAME] ;
				/* 쐬ckk̃x[Xt@C擾B*/
				get_base_name(argv[i], szPath, szModule) ;
				/* ckk쐬B*/
				rc = make_dll_main(szObjName, szPath, szModule) ;
				if (rc != NO_ERROR) {
					fprintf(stderr, "ERROR!:%s(%d)\n", argv[i], rc) ;
				}
			}
			/* ckk쐬ɎgpIuWFNgt@C폜B*/
			remove(szObjName) ;
		}
	}
	return rc ;
}
