#===================================================================
#   Makefile for MakeDCE examples 
#===================================================================
.SUFFIXES:
.SUFFIXES: .obj .c 
#===================================================================
# Default compilation macros
#
# Compile switchs  that are enabled
# /C       compile don't link
# /Gd+   use dynamic link libraries at run-time
# /Ms     use system linkage for functions
# /Q+     do not display logo at compilation time
# /W3    produce all message types
# /O-    Do not optimize code
# /Ss+    allow  "//" for comment lines
# /Sem     allow cset and migration extensions
#
#DCELOCAL = D:\OPT\DCELOCAL
#MAKEDCE  = D:\MAKEDCE
#
DCEINC    = $(DCELOCAL)\include
IDL       = $(DCELOCAL)\bin\idl
UUIDGEN   = $(DCELOCAL)\bin\uuidgen
GLUEINC   = $(MAKEDCE)\include
IDLGEN    = $(MAKEDCE)\bin\idlgen
GLUEGEN   = $(MAKEDCE)\bin\gluegen
SED       = $(MAKEDCE)\bin\sed.exe

COPY    = copy
REM     = REM
ECHO    = ECHO
CSTUB   = $(CLIENT)_gstub.obj  $(IDLFILE)_cstub.obj
SSTUB   = $(SERVER)_gstub.obj  $(IDLFILE)_sstub.obj
FMAINARG =

IDLFLAGS = -no_cpp -keep c_source
IDLGENFLAGS = -stdin -ibd +v -interface $(IDLFILE)
GLUEGENFLAGS = -keep c_source /I$(GLUEINC) $(FMAINARG)

#===================================================================
#   CFLAGS for CC command
#
CARGS       = /C /Gd+ /Ms /Q+ /W3 /O- /Sd+ /Sem /U4

INCLUDES    = /I. /I$(DCEINC) /I$(GLUEINC)

#SO32FLAGS   = /DMPTN /DMT /DSO32 /DOS2 /DBSD_SELECT
#THREADFLAGS = /D_CMA_PROTO_ /D_CMA_NOWRAPPERS_ /DCMA_UNIPROCESSOR
DSSFLAGS    = /DINTEL80x86 /DIBMOS2 /D__STDC__ /DIDL_PROTOTYPES
DEFINES     = $(DSSFLAGS) $(SO32FLAGS) $(THREADFLAGS)

CFLAGS      = $(CARGS) $(DEFINES) $(INCLUDES)

#===================================================================
#   LDFLAGS for LINK  command
# 
#LDOSFLAGS = /A:16 /BASE:0x10000 /EXEPACK /STACK:64000 /PM:VIO
LDFLAGS   = /PM:VIO /BATCH /E /MAP /NOI /NOL /NOD /DE /CO $(LIBFLAGS)


#===================================================================
#   LDLIBS for LINK  command
# 
MPTNLIBS = so32dll.lib
DCELIBS  = dceos2.lib
OS2LIBS  = dde4mbs.lib os2386.lib
GLUELIB  = $(MAKEDCE)\lib\glue.lib
LDLIBS   = $(GLUELIB) $(DCELIBS) $(MPTNLIBS) $(OS2LIBS)

LINK     = LINK386  $(LDFLAGS)
CC       = ICC $(CFLAGS)

.c.obj:
    @echo Compiling $*.c file
    $(CC) -Fo$*.obj $*.c

help:
   @echo Do one of the following:
   @echo 1. nmake help  - to display this message
   @echo 2. nmake $(PROGRAM) - to make the Non-DCE '$(PROGRAM)' program
   @echo 3. nmake $(IDLFILE).idl - to make the IDL file for $(MANAGER).c
   @echo 4. nmake stubs - to make all stubs (glue and idl).
   @echo 5. nmake cstub - to make client GLUEGEN and DCE stubs. 
   @echo 6. nmake sstub - to make server GLUEGEN and DCE stubs. 
   @echo 7. nmake /C $(CLIENT) - to make the $(CLIENT) application
   @echo 8. nmake /C $(SERVER) - to make the $(SERVER) application
   @echo 9. nmake clean - to clean all non-source files.

$(IDLFILE).idl: $(MANAGER).c
   @echo "-->Making $(IDLFILE).idl"
   $(UUIDGEN) -i | $(IDLGEN) $(IDLGENFLAGS) /I$(GLUEINC) $(DEFINES) $(MANAGER).c > $(IDLFILE).idl

$(IDLFILE)_cstub.c: $(IDLFILE).idl
   @echo "--> Making client DCE stub for $(IDLFILE).idl"
   $(IDL) $(IDLFILE).idl $(IDLFLAGS) -server none

$(IDLFILE)_sstub.c: $(IDLFILE).idl
   @echo "--> Making  server DCE stub for $(IDLFILE).idl"
   $(IDL) $(IDLFILE).idl $(IDLFLAGS) -client none

$(APFFILE).apf: $(IDLFILE).idl

$(CLIENT)_gstub.c $(IDLFILE).acf: $(APFFILE).apf
   @echo "--> Making glue stub for $(CLIENT) application"
   $(GLUEGEN) $(APFFILE).apf $(CLIENT) $(GLUEGENFLAGS)

$(SERVER)_gstub.c $(IDLFILE).acf: $(APFFILE).apf
   @echo "--> Making glue stub for $(SERVER) application"
   $(GLUEGEN) $(APFFILE).apf $(SERVER) $(GLUEGENFLAGS)

client_OFILES = $(CSTUB) $(CAUX) fmain.obj $(CLIENT).obj $(OTHER_CLIENT_OFILES)

server_OFILES = $(SSTUB) $(SAUX) $(SERVER).obj $(MANAGER).obj $(OTHER_SERVER_OFILES)

stubs: $(CSTUB) $(SSTUB)
   @echo "--> made all stubs"

cstub: $(CSTUB)
   @echo "--> made client stubs"

sstub: $(SSTUB)
   @echo "--> made server stubs"

$(CLIENT): $(client_OFILES) fmain.c client.exe

client.exe: 
   @echo "-->Linking $(CLIENT) application"
   $(LINK) $(client_OFILES),$(CLIENT),$(CLIENT),$(LDLIBS);
   @echo Making $(CLIENT) application completed

$(SERVER): $(server_OFILES) server.exe

server.exe: 
   @echo "-->Linking $(SERVER) application"
   $(LINK) $(server_OFILES),$(SERVER),$(SERVER),$(LDLIBS);
   @echo Making $(SERVER) application completed

$(PROGRAM): $(PROGRAM_OFILES)
   @echo "-->Making $(PROGRAM) application"
   @$(LINK) $(PROGRAM_OFILES),$(PROGRAM),$(PROGRAM),$(LDLIBS);

.IGNORE:

fmain.c : $(PROGRAM).c
   @echo "-->Making fmain.c"
   @cmd /C "$(SED) -e "s/main/fmain/" $(PROGRAM).c  > fmain.c"

.IGNORE:

RMFILES = *.obj uuidgen.idl *.map copy.lst fmain.c core \
          *_gstub* *_cstub* *_sstub* *_caux* *_saux* \
          $(IDLFILE).h $(CLIENT).exe $(SERVER).exe $(PROGRAM).exe \
          $(CLIENT).c $(SERVER).c 

.IGNORE:

clean:
   @cmd /C del $(RMFILES)  2> /dev/nul

cl:
   @cmd /C del $(RMFILES)  2> /dev/nul
   @rm *.idl *.acf

.IGNORE:

touch:
    touch $(IDLFILE).idl $(PROGRAM).apf

fmain.obj: fmain.c



