/*
*/
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
/*
#include <dce/cma.h>
#include <dce/rpcexc.h>
#include <dce/cmalib_crtlx.h>
*/

#include "rcmd.h"     

typedef unsigned char byte;

#define FAILED_MESSAGE "Server Could not Execute Command: "
#define NULL_COMMAND   "Server Cannot Execute NULL Command"

#define MANAGER_BUFFER_SIZE 2048
byte manager_buffer[MANAGER_BUFFER_SIZE];
byte command_buffer[MANAGER_BUFFER_SIZE];

static char *pipe_out;

void rcmd (
    /* [in] */handle_t h,
    /* [in] */pipe_of_chars in_pipe,
    /* [out] */pipe_of_chars out_pipe,
    /* [out] */ndr_long_int *out_long
)
{
    FILE   *file_handle;
    int      status;
    unsigned long data_count;
    unsigned long cmdlen = 0;

    pipe_out = tmpnam(NULL);
    while (true)
    {
       (*in_pipe.pull)(in_pipe.state,manager_buffer,MANAGER_BUFFER_SIZE,
                   &data_count);

       if (data_count == 0)
          break;
 
       cmdlen = data_count;
       strcpy(command_buffer, manager_buffer);

    }

    if (cmdlen > 0)
    {
        printf("Executing Command: %s\n", command_buffer);
        strcat(command_buffer, " > ");
        strcat(command_buffer, pipe_out);
        status = system(command_buffer);
        if (status != 0)
        {
            file_handle = fopen(pipe_out, "w");
            fwrite(FAILED_MESSAGE, 1, strlen(FAILED_MESSAGE), file_handle);
            fwrite(command_buffer, 1, cmdlen, file_handle);
            fclose(file_handle);
        }
    }
    else
    {
        file_handle = fopen(pipe_out, "w");
        fwrite(NULL_COMMAND, 1, strlen(NULL_COMMAND), file_handle);
        fclose(file_handle);
    }

    file_handle = fopen(pipe_out, "r");
    if (!file_handle)
    {
        printf("Server cannot open command output: %s\n", pipe_out); 
        exit(0);
    }

    while (1)
    {
        data_count = fread(manager_buffer,1, MANAGER_BUFFER_SIZE, file_handle);
#ifdef DEBUG
        fwrite(manager_buffer, data_count, 1, stdout);
#endif

        (*out_pipe.push)(out_pipe.state,manager_buffer,data_count);
        if (data_count == 0)
            break;
    }

    fclose(file_handle);
    remove(pipe_out);

    *out_long = 1024;
}
