/*
*/
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>
#include "rcmd.h"

typedef unsigned char byte;

#define CLIENT_BUFFER_SIZE 2048
static byte client_buffer[CLIENT_BUFFER_SIZE];

typedef struct client_pipe_state_t {
    ndr_boolean file_open;
    int file_handle;
} client_pipe_state_t;

client_pipe_state_t client_in_pipe_state = {false, 0};
client_pipe_state_t client_out_pipe_state = {false, 0};

char *pipe_out = "pt.out";

char *command_buf_ptr;

void client_pull (rpc_ss_pipe_state_t state_arg,
		  byte *buf,
		  unsigned long esize,
		  unsigned long *ecount)
{
    client_pipe_state_t *state = state_arg;

    if (! state->file_open)
    {
         state->file_open = true;
         *ecount = strlen(command_buf_ptr) + 1;
         strcpy(buf, command_buf_ptr);
    }
    else
    {
         state->file_open = false;
         *ecount = 0;
    }
}

void client_push (rpc_ss_pipe_state_t state_arg,
		  byte *buf,
		  unsigned long ecount)
{
    client_pipe_state_t *state = state_arg;

    if (ecount == 0)
        state->file_open = false;
    else
    {
        state->file_open = true;
        fwrite(buf, ecount, 1, stdout); 
    }
}
                      
void client_alloc (rpc_ss_pipe_state_t state,
		   unsigned long bsize,
		   byte **buf,
		   unsigned long *bcount)
{
    *buf = client_buffer;
    *bcount = CLIENT_BUFFER_SIZE;
}

int client_aux(handle_t h, char *cmd)
{
    pipe_of_chars client_in_pipe;
    pipe_of_chars client_out_pipe;
    long status;
    error_status_t st;
    int rc = 0;

    command_buf_ptr = cmd;
    client_in_pipe.pull = client_pull ;
    client_in_pipe.alloc = client_alloc;
    client_in_pipe.state = (client_pipe_state_t *) &client_in_pipe_state;
    client_out_pipe.push = client_push;
    client_out_pipe.alloc = client_alloc;
    client_out_pipe.state = (client_pipe_state_t *)&client_out_pipe_state;

    rcmd ( h, client_in_pipe, client_out_pipe, &status );
    if (status != 1024)
    {
      printf("***FAILURE***: Returned to client with status %d, expecte 1024\n", status);
      rc = status;
    }
                     
    return (rc);
}
