#===================================================================
#   Makefile for MakeDCE examples 
#===================================================================
.SUFFIXES:
.SUFFIXES: .obj .c 
#===================================================================
# Default compilation macros
#
# Compile switchs  that are enabled
# /C       compile don't link
# /Gd+   use dynamic link libraries at run-time
# /Mp     use optlink linkage for functions
# /Q+     do not display logo at compilation time
# /W3    produce all message types
# /O-    Do not optimize code
# /Ss+    allow  "//" for comment lines
# /Sem     allow cset and migration extensions
#
#DCELOCAL = D:\OPT\DCELOCAL
#MAKEDCE  = D:\MAKEDCE
#
DCEINC    = $(DCELOCAL)\include
IDL       = $(DCELOCAL)\bin\idl
UUIDGEN   = $(DCELOCAL)\bin\uuidgen
GLUEINC   = $(MAKEDCE)\include
IDLGEN    = $(MAKEDCE)\bin\idlgen
GLUEGEN   = $(MAKEDCE)\bin\gluegen
SED       = $(MAKEDCE)\bin\sed.exe

COPY    = copy
REM     = REM
ECHO    = ECHO
CSTUB   = $(CLIENT)_gstub.obj  $(IDLFILE1)_cstub.obj $(IDLFILE2)_cstub.obj
SSTUB1  = $(SERVER1)_gstub.obj  $(IDLFILE1)_sstub.obj
SSTUB2  = $(SERVER2)_gstub.obj  $(IDLFILE2)_sstub.obj
FMAINARG =

IDLFLAGS = -no_cpp  -keep c_source
IDLGENFLAGS = -ibd +v 
GLUEGENFLAGS = -keep c_source /I$(GLUEINC) $(FMAINARG)

#===================================================================
#   CFLAGS for CC command
#
CARGS       = /C /Gd+ /Ms /Q+ /W3 /O- /Ss+ /Sem

INCLUDES    = /I. /I$(DCEINC) /I$(GLUEINC)

#SO32FLAGS   = /DMPTN /DMT /DSO32 /DOS2 /DBSD_SELECT
#THREADFLAGS = /D_CMA_PROTO_ /D_CMA_NOWRAPPERS_ /DCMA_UNIPROCESSOR
DSSFLAGS    = /DINTEL80x86 /DIBMOS2 /D__STDC__ /D_IDL_PROTOTYPES
DEFINES     = $(DSSFLAGS) $(SO32FLAGS) $(THREADFLAGS)

CFLAGS      = $(CARGS) $(DEFINES) $(INCLUDES)

#===================================================================
#   LDFLAGS for LINK  command
# 
#LDOSFLAGS = /A:16 /BASE:0x10000 /EXEPACK /STACK:64000 /PM:VIO
LDFLAGS   = /PM:VIO /BATCH /E /MAP /NOI /NOL /NOD /DE /CO $(LIBFLAGS)


#===================================================================
#   LDLIBS for LINK  command
# 
MPTNLIBS = so32dll.lib
DCELIBS  = dceos2.lib
OS2LIBS  = dde4mbs.lib os2386.lib 
GLUELIB  = $(MAKEDCE)\lib\glue.lib
LDLIBS   = $(GLUELIB) $(DCELIBS) $(MPTNLIBS) $(OS2LIBS)

LINK     = LINK386  $(LDFLAGS)
CC       = ICC $(CFLAGS)

.c.obj:
    @echo Compiling $*.c file
    @$(CC) -Fo$*.obj $*.c

help:
   @echo Do one of the following:
   @echo 1. nmake help  - to display this message
   @echo 2. nmake $(PROGRAM) - to make the Non-DCE '$(PROGRAM)' program
   @echo 3. nmake $(IDLFILE1).idl - to make the IDL file for $(MANAGER1).c
   @echo 4. nmake $(IDLFILE2).idl - to make the IDL file for $(MANAGER2).c
   @echo 5. nmake /C $(CLIENT) - to make the $(CLIENT) application
   @echo 6. nmake /C $(SERVER1) - to make the $(SERVER1) application
   @echo 7. nmake /C $(SERVER2) - to make the $(SERVER2) application
   @echo 8. nmake clean - to clean all non-source files.

$(IDLFILE1).idl: $(MANAGER1).c
   @echo "-->Making $(IDLFILE1).idl"
   @$(UUIDGEN) -i > uuidgen.idl
   $(IDLGEN) $(IDLGENFLAGS) -interface $(IDLFILE1) /I$(GLUEINC) $(DEFINES) uuidgen.idl $(MANAGER1).c > $(IDLFILE1).idl

$(IDLFILE2).idl: $(MANAGER2).c
   @echo "-->Making $(IDLFILE2).idl"
   @$(UUIDGEN) -i > uuidgen.idl
   $(IDLGEN) $(IDLGENFLAGS) -interface $(IDLFILE2) /I$(GLUEINC) $(DEFINES) uuidgen.idl $(MANAGER2).c > $(IDLFILE2).idl

$(IDLFILE1)_cstub.c: $(IDLFILE1).idl
   @echo "--> Making client DCE stub for $(IDLFILE1).idl"
   $(IDL) $(IDLFILE1).idl $(IDLFLAGS) -server none

$(IDLFILE2)_cstub.c: $(IDLFILE2).idl
   @echo "--> Making client DCE stub for $(IDLFILE2).idl"
   $(IDL) $(IDLFILE2).idl $(IDLFLAGS) -server none

$(IDLFILE1)_sstub.c: $(IDLFILE1).idl
   @echo "--> Making  server DCE stub for $(IDLFILE1).idl"
   $(IDL) $(IDLFILE1).idl $(IDLFLAGS) -client none

$(IDLFILE2)_sstub.c: $(IDLFILE2).idl
   @echo "--> Making  server DCE stub for $(IDLFILE2).idl"
   $(IDL) $(IDLFILE2).idl $(IDLFLAGS) -client none

$(APFFILE).apf: $(IDLFILE1).idl $(IDLFILE2).idl

$(CLIENT)_gstub.c $(IDLFILE1).acf $(IDLFILE2).acf: $(APFFILE).apf
   @echo "--> Making glue stub for $(CLIENT) application"
   $(GLUEGEN) $(APFFILE).apf $(CLIENT) $(GLUEGENFLAGS)

$(SERVER1)_gstub.c $(IDLFILE1).acf: $(APFFILE).apf
   @echo "--> Making glue stub for $(SERVER1) application"
   $(GLUEGEN) $(APFFILE).apf $(SERVER1) $(GLUEGENFLAGS)

$(SERVER2)_gstub.c $(IDLFILE2).acf: $(APFFILE).apf
   @echo "--> Making glue stub for $(SERVER2) application"
   $(GLUEGEN) $(APFFILE).apf $(SERVER2) $(GLUEGENFLAGS)

client_OFILES = $(CSTUB) $(CAUX) fmain.obj $(CLIENT).obj $(OTHER_CLIENT_OFILES)

server1_OFILES = $(SSTUB1) $(SAUX) $(SERVER1).obj $(MANAGER1).obj $(OTHER_SERVER_OFILES)

server2_OFILES = $(SSTUB2) $(SAUX) $(SERVER2).obj $(MANAGER2).obj $(OTHER_SERVER_OFILES)

$(CLIENT): $(client_OFILES) fmain.c client.exe

client.exe: 
   @echo "-->Linking $(CLIENT) application"
   @$(LINK) $(client_OFILES),$(CLIENT),$(CLIENT),$(LDLIBS);
   @echo Making $(CLIENT) application completed

$(SERVER1): $(server1_OFILES) server1.exe

$(SERVER2): $(server2_OFILES) server2.exe

server1.exe:
   @echo "-->Linking $(SERVER1) application"
   @$(LINK) $(server1_OFILES),$(SERVER1),$(SERVER1),$(LDLIBS);
   @echo Making $(SERVER1) application completed

server2.exe:
   @echo "-->Linking $(SERVER2) application"
   @$(LINK) $(server2_OFILES),$(SERVER2),$(SERVER2),$(LDLIBS);
   @echo Making $(SERVER2) application completed

$(PROGRAM): $(PROGRAM_OFILES)
   @echo "-->Making $(PROGRAM) application"
   @$(LINK) $(PROGRAM_OFILES),$(PROGRAM),$(PROGRAM),$(LDLIBS);

.IGNORE:

fmain.c : $(PROGRAM).c
   @echo "-->Making fmain.c"
   @cmd /C "$(SED) -e "s/main/fmain/" $(PROGRAM).c  > fmain.c"

.IGNORE:

RMFILES = *.obj *.acf uuidgen.idl *.map copy.lst fmain.c core \
          *_gstub* *_cstub* *_sstub* *_caux* *_saux* \
          $(IDLFILE1).h $(IDLFILE2).h $(CLIENT).exe $(SERVER1).exe $(SERVER2).exe \
          $(PROGRAM).exe $(CLIENT).c $(SERVER1).c $(SERVER2).c

.IGNORE:

clean:
   @cmd /C del $(RMFILES)  2> /dev/nul

cl:
   @cmd /C del $(RMFILES)  2> /dev/nul
   @rm *.idl *.acf

.IGNORE:

touch:
    touch $(IDLFILE1).idl $(IDLFILE2).idl $(PROGRAM).apf

fmain.obj: fmain.c
