#===================================================================
#   Makefile for MakeDCE examples 
#===================================================================
.SUFFIXES:
.SUFFIXES: .obj .c 
#===================================================================
# Default compilation macros
#
# Compile switchs  that are enabled
# /C       compile don't link
# /Gd+   use dynamic link libraries at run-time
# /Ms     use system linkage for functions
# /Q+     do not display logo at compilation time
# /W3    produce all message types
# /O-    Do not optimize code
# /Ss+    allow  "//" for comment lines
# /Sem     allow cset and migration extensions
#
#DCELOCAL = D:\OPT\DCELOCAL
#MAKEDCE  = D:\MAKEDCE
#
DCEINC    = $(DCELOCAL)\include
IDL       = $(DCELOCAL)\bin\idl
UUIDGEN   = $(DCELOCAL)\bin\uuidgen
GLUEINC   = $(MAKEDCE)\include
IDLGEN    = $(MAKEDCE)\bin\idlgen
GLUEGEN   = $(MAKEDCE)\bin\gluegen
SED       = $(MAKEDCE)\bin\sed.exe

COPY    = copy
REM     = REM
ECHO    = ECHO
CSTUB   = $(CLIENT)_gstub.obj  $(IDLFILE1)_cstub.obj
CHSTUB  = $(CH_SERVER)_gstub.obj $(IDLFILE1)_sstub.obj $(IDLFILE2)_cstub.obj
SSTUB   = $(SERVER)_gstub.obj  $(IDLFILE2)_sstub.obj
FMAINARG =

IDLFLAGS = -no_cpp  -keep c_source
IDLGENFLAGS = -stdin -ibd +v
GLUEGENFLAGS = -keep c_source /I$(GLUEINC) $(FMAINARG)

#===================================================================
#   CFLAGS for CC command
#
CARGS       = /C /Gd+ /Ms /Q+ /W3 /O- /Ss+ /Sem

INCLUDES    = /I. /I$(DCEINC) /I$(GLUEINC)

#SO32FLAGS   = /DMPTN /DMT /DSO32 /DOS2 /DBSD_SELECT
#THREADFLAGS = /D_CMA_PROTO_ /D_CMA_NOWRAPPERS_ /DCMA_UNIPROCESSOR
DSSFLAGS    = /DINTEL80x86 /DIBMOS2 /D__STDC__ /DIDL_PROTOTYPES
DEFINES     = $(DSSFLAGS) $(SO32FLAGS) $(THREADFLAGS)

CFLAGS      = $(CARGS) $(DEFINES) $(INCLUDES)

#===================================================================
#   LDFLAGS for LINK  command
# 
#LDOSFLAGS = /A:16 /BASE:0x10000 /EXEPACK /STACK:64000 /PM:VIO
LDFLAGS   = /PM:VIO /BATCH /E /MAP /NOI /NOL /NOD /DE /CO $(LIBFLAGS)


#===================================================================
#   LDLIBS for LINK  command
# 
MPTNLIBS = so32dll.lib
DCELIBS  = dceos2.lib
OS2LIBS  = dde4mbs.lib os2386.lib
GLUELIB  = $(MAKEDCE)\lib\glue.lib
LDLIBS   = $(GLUELIB) $(DCELIBS) $(MPTNLIBS) $(OS2LIBS)

LINK     = LINK386  $(LDFLAGS)
CC       = ICC $(CFLAGS)

.c.obj:
    @echo Compiling $*.c file
    @$(CC) -Fo$*.obj $*.c

help:
   @echo Do one of the following:
   @echo 1. nmake help  - to display this message
   @echo 2. nmake $(PROGRAM) - to make the Non-DCE '$(PROGRAM)' program
   @echo 3. nmake $(IDLFILE1).idl - to make the IDL file for $(CH_MANAGER).c
   @echo 4. nmake $(IDLFILE2).idl - to make the IDL file for $(MANAGER).c
   @echo 5. nmake /C $(CLIENT) - to make the $(CLIENT) application
   @echo 6. nmake /C $(CH_SERVER) - to make the $(CH_SERVER) application
   @echo 7. nmake /C $(SERVER) - to make the $(SERVER) application
   @echo 8. nmake clean - to clean all non-source files.

$(IDLFILE1).idl: $(CH_MANAGER).c
   @echo "-->Making $(IDLFILE1).idl"
   $(UUIDGEN) -i | $(IDLGEN) $(IDLGENFLAGS) -interface $(IDLFILE1) /I$(GLUEINC) $(DEFINES) $(CH_MANAGER).c > $(IDLFILE1).idl

$(IDLFILE2).idl: $(MANAGER).c
   @echo "-->Making $(IDLFILE2).idl"
   $(UUIDGEN) -i | $(IDLGEN) $(IDLGENFLAGS) -interface $(IDLFILE2) /I$(GLUEINC) $(DEFINES) $(MANAGER).c > $(IDLFILE2).idl

$(IDLFILE1)_cstub.c: $(IDLFILE1).idl
   @echo "--> Making client DCE stub for $(IDLFILE1).idl"
   $(IDL) $(IDLFILE1).idl $(IDLFLAGS) -server none

$(IDLFILE2)_cstub.c: $(IDLFILE2).idl
   @echo "--> Making client DCE stub for $(IDLFILE2).idl"
   $(IDL) $(IDLFILE2).idl $(IDLFLAGS) -server none

$(IDLFILE1)_sstub.c: $(IDLFILE1).idl
   @echo "--> Making  server DCE stub for $(IDLFILE1).idl"
   $(IDL) $(IDLFILE1).idl $(IDLFLAGS) -client none

$(IDLFILE2)_sstub.c: $(IDLFILE2).idl
   @echo "--> Making  server DCE stub for $(IDLFILE2).idl"
   $(IDL) $(IDLFILE2).idl $(IDLFLAGS) -client none

$(APFFILE).apf: $(IDLFILE1).idl $(IDLFILE2).idl

$(CLIENT)_gstub.c $(IDLFILE1).acf: $(APFFILE).apf
   @echo "--> Making glue stub for $(CLIENT) application"
   $(GLUEGEN) $(APFFILE).apf $(CLIENT) $(GLUEGENFLAGS)

$(CH_SERVER)_gstub.c $(IDLFILE1).acf: $(APFFILE).apf
   @echo "--> Making glue stub for $(CH_SERVER) application"
   $(GLUEGEN) $(APFFILE).apf $(CH_SERVER) $(GLUEGENFLAGS)

$(SERVER)_gstub.c $(IDLFILE2).acf: $(APFFILE).apf
   @echo "--> Making glue stub for $(SERVER) application"
   $(GLUEGEN) $(APFFILE).apf $(SERVER) $(GLUEGENFLAGS)

client_OFILES = $(CSTUB) $(CAUX) fmain.obj $(CLIENT).obj $(OTHER_CLIENT_OFILES)

ch_server_OFILES = $(CHSTUB) $(SAUX) $(CH_SERVER).obj $(CH_MANAGER).obj $(OTHER_SERVER_OFILES)

server_OFILES = $(SSTUB) $(SAUX) $(SERVER).obj $(MANAGER).obj $(OTHER_SERVER_OFILES)

$(CLIENT): $(client_OFILES) fmain.c client.exe

client.exe: 
   @echo "-->Linking $(CLIENT) application"
   @$(LINK) $(client_OFILES),$(CLIENT),$(CLIENT),$(LDLIBS);
   @echo Making $(CLIENT) application completed

$(CH_SERVER): $(ch_server_OFILES) chserver.exe

$(SERVER): $(server_OFILES) server.exe

chserver.exe:
   @echo "-->Linking $(CH_SERVER) application"
   @$(LINK) $(ch_server_OFILES),$(CH_SERVER),$(CH_SERVER),$(LDLIBS);
   @echo Making $(CH_SERVER) application completed

server.exe:
   @echo "-->Linking $(SERVER) application"
   @$(LINK) $(server_OFILES),$(SERVER),$(SERVER),$(LDLIBS);
   @echo Making $(SERVER) application completed

$(PROGRAM): $(PROGRAM_OFILES)
   @echo "-->Making $(PROGRAM) application"
   @$(LINK) $(PROGRAM_OFILES),$(PROGRAM),$(PROGRAM),$(LDLIBS);

.IGNORE:

fmain.c : $(PROGRAM).c
   @echo "-->Making fmain.c"
   @cmd /C "$(SED) -e "s/main/fmain/" $(PROGRAM).c  > fmain.c"

.IGNORE:

RMFILES = *.obj *.acf uuidgen.idl *.map copy.lst fmain.c core \
          *_gstub* *_cstub* *_sstub* *_caux* *_saux* \
          $(IDLFILE1).h $(IDLFILE2).h $(CLIENT).exe $(CH_SERVER).exe $(SERVER).exe $(PROGRAM).exe \
          $(CLIENT).c $(CH_SERVER).c $(SERVER).c

.IGNORE:

clean:
   @cmd /C del $(RMFILES)  2> /dev/nul

cl:
   @cmd /C del $(RMFILES)  2> /dev/nul
   @rm *.idl *.acf

.IGNORE:

touch:
    touch $(IDLFILE1).idl $(PROGRAM).apf

fmain.obj: fmain.c

