#ifdef AIX_PROD
static char sccsid[]="@(#)32	1.1  src/test/rpc/idl/array/manager.c, , sdk101, sdk101.205b  7/23/92  20:57:20";
/*
 * COMPONENT_NAME:  rpc.test 
 *
 * FUNCTIONS: 
 *
 * ORIGINS: 72
 *
 * OBJECT CODE ONLY SOURCE MATERIALS
 *
 */
#endif /* AIX_PROD */
/*
 * (c) Copyright 1990, 1991 OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * HISTORY
 * $Log: manager.c,v $
 * Revision 1.1  1992/01/19  03:23:05  devrcs
 * Initial revision
 *
 * $EndLog$
 */
/*
*/
#include "atypes.h"

ndr_long_int array_op1
#ifdef NIDL_PROTOTYPES
(
    /* [in] */handle_t h,
    /* [in] */ndr_long_int arr[N]
)
#else
(h, arr)
    /* [in] */handle_t h;
    /* [in] */ndr_long_int arr[N];
#endif
{
    int i; 
    ndr_long_int checksum = 0;

    for (i = 0; i < N; i++)
        checksum += arr[i];
    
    return checksum;
}

ndr_long_int array_op2
#ifdef NIDL_PROTOTYPES
(
    /* [in] */handle_t h,
    /* [in] */s_t arr[N]
)
#else
(h, arr)
    /* [in] */handle_t h;
    /* [in] */s_t arr[N];
#endif
{
    int i; 
    ndr_long_int checksum = 0;

    for (i = 0; i < N; i++)
    {
        if (arr[i].b != (i & 0xff))
            printf("Byte value[%d] doesn't match in array_op2()!\n", i);
        checksum += arr[i].l;
    }
    
    return checksum;
}

ndr_long_int array_op3
#ifdef NIDL_PROTOTYPES
(
    /* [in] */handle_t h,
    /* [in] */t_t arr[N]
)
#else
(h, arr)
    /* [in] */handle_t h;
    /* [in] */t_t arr[N];
#endif
{
    int i, j; 
    ndr_long_int checksum = 0;

    for (i = 0; i < N; i++)
    {
        if (arr[i].b != (i & 0xff))
            printf("Byte value[%d] doesn't match in array_op3()!\n", i);
        for (j = 0; j < 7; j++)
            checksum += arr[i].a[j];
    }
    
    return checksum;
}

ndr_long_int array_op4
#ifdef NIDL_PROTOTYPES
(
    /* [in] */handle_t h,
    /* [in] */ndr_long_int arr[N],
    /* [in] */ndr_long_int last
)
#else
(h, arr, last)
    /* [in] */handle_t h;
    /* [in] */ndr_long_int arr[N];
    /* [in] */ndr_long_int last;
#endif
{
    int i; 
    ndr_long_int checksum = 0;

    for (i = 0; i <= last; i++)
        checksum += arr[i];
    
    return checksum;
}

ndr_long_int array_op5
#ifdef NIDL_PROTOTYPES
(
    /* [in] */handle_t h,
    /* [in] */my_array arr,
    /* [in] */ndr_long_int max
)
#else
(h, arr, max)
    /* [in] */handle_t h;
    /* [in] */my_array arr;
    /* [in] */ndr_long_int max;
#endif
{
    int i,j; 
    ndr_long_int checksum = 0;


    for (i = 0; i <= max; i++)
        for (j = 0; j < M; j++) 
        {
          checksum += arr[i][j];
#ifdef DEBUG
          printf("m[%d,%d]: %d,%d\n", i,j,arr[i][j], checksum);
#endif
        }    
    return checksum;
}

void array_op6
#ifdef NIDL_PROTOTYPES
(
    /* [in] */handle_t h,
    /* [in] */my_array arr,
    /* [in, out] */ndr_long_int *last,
    /* [in] */ndr_long_int max,
    /* [out] */ndr_long_int *checkin,
    /* [out] */ndr_long_int *checkout
)
#else
(h, arr, last, max, checkin, checkout)
    /* [in] */handle_t h;
    /* [in, out] */my_array arr;
    /* [in, out] */ndr_long_int *last;
    /* [in] */ndr_long_int max;
    /* [out] */ndr_long_int *checkin;
    /* [out] */ndr_long_int *checkout;
#endif
{
    int i,j; 

    *checkin = *checkout = 0;

    for (i = 0; i <= *last; i++)
        for (j = 0; j < M; j++) *checkin += arr[i][j];
    
    *last = max;

    for (i = 0; i <= *last; i++)
        for (j = 0; j < M; j++) *checkout += arr[i][j] = random();
}
