/*
 * COMPONENT_NAME:  MakeDCE/examples/alias/manager.c
 *
 * FUNCTIONS: 
 *
 * ORIGINS: 72
 *
 * OBJECT CODE ONLY SOURCE MATERIALS
 *
 */
/*
 * (c) Copyright 1990, 1991 OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
#include <stdio.h>
#include "umacros.h"
#include "list.h"

long op0
(a, b, c)
      /* [in, out] */ long *a;
      /* [in, out] */ long *b;
      /* [in, out] */ long *c;
{
    long failures = 0;

    if (a != b || a != c)
    {
        fprintf(stderr, "Pointers passed to op0 don't have same values!\n");
        failures++;
    }

    *a *= 2;
    *b *= 3;
    *c *= 4;
    return failures;
}

long op1
(a, b, c)
	/* [in, out] */ long_t *a;
	/* [in, out] */ long_t *b;
	/* [in, out] */ long_t *c;
{
    long failures = 0;

    if (a != b || a != c)
    {
        fprintf(stderr, "Pointers passed to op1 don't have same values!\n");
        failures++;
    }

    *a *= 2;
    *b *= 3;
    *c *= 4;
    return failures;
}

long op2
(a, b, c, s)
	/* [in, out] */ long_t *a;
	/* [in, out] */ long_t *b;
	/* [in, out] */ long_t *c;
	/* [in] */ long s;
{
    long i, failures = 0;

    if (a != b || a != c)
    {
        fprintf(stderr, "Pointers passed to op2 don't have same values!\n");
        failures++;
    }

    for (i = 0 ; i < s ; i++)
    {
        a[i] *= 2;
        b[i] *= 3;
        c[i] *= 4;
    }
    return failures;
}

long op3
(plist)
	/* [in, out] */ node_t **plist;
{
    node_t *node_p, *temp_p;
    int toggle;

    /*
     * Reverse the circular doubly-linked list, creating new storage
     * for half the nodes.
     */
    if (*plist == NULL)
        return;

    /*
     * Make a first pass, replacing half the nodes with new nodes that
     * contain the same non-pointer data.
     */
    node_p = *plist;
    toggle = 0;
    do
    {
        if (toggle++)
        {
            temp_p = (node_t *)malloc(sizeof(node_t));
            temp_p->l = node_p->l;
            temp_p->flink = node_p->flink;
            temp_p->blink = node_p->blink;
            node_p->blink->flink = temp_p;
            node_p->flink->blink = temp_p;
        }
        node_p = node_p->flink;
    } while (node_p != *plist);

    /*
     * Now reverse the list.
     */
    node_p = *plist;
    do
    {
        temp_p = node_p->flink;
        node_p->flink = node_p->blink;
        node_p->blink = temp_p;
        node_p = temp_p;
    } while (node_p != *plist);

    /*
     * Make the listhead point at the new first element.  node_p points at the
     * former first element which has been switched to be the last element, so
     * its forward link points at the new first element.
     */
    *plist = node_p->flink;

    return 0;
}

long op4
(list)
	/* [in, out] */ struct_list_t *list;
{
    while (list != NULL)
    {
        if (list->struct_ptr) list->struct_ptr->l -= 7;
        list->struct_ref->l *= 3;
        list = list->next;
    }

    return 0;
}
