/*
 * COMPONENT_NAME:  MakeDCE/examples/alias/client_aux.c
 *
 * FUNCTIONS: 
 *
 * ORIGINS: 72
 *
 * OBJECT CODE ONLY SOURCE MATERIALS
 *
 */
/*
 * (c) Copyright 1990, 1991 OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
#include <stdio.h>
#include <math.h>
#include "umacros.h"
#include "list.h"

#ifdef IBMOS2
#include <stdlib.h>
#define  random  rand
#endif

int client_aux(passno)
    int passno;
{
    int             i, failures = 0, mgr_failures = 0;
    long	    *longp1, *longp2, *longp3, aliased_long, output_long;
    long_t          *longtp1, *longtp2, *longtp3, aliased_longt, output_longt;
    long_t          *longap1, *longap2, *longap3, aliased_longa[ARRAY_SIZE],
                    output_longa[ARRAY_SIZE];
    node_t          *list = NULL, *node_p;
    struct_list_t   *struct_list_p, *temp;
    struct_t        *struct_ptr;

/*
 * Top-level pointers - pointers can't change but pointees can be aliased.
 * op0 tests the pre-generated routines for pointed-to long that ships with RTL
 * op1 tests the IDL-generated routines for pointed-to long from compiling this
 */
    longp1 = &aliased_long;
    longp2 = &aliased_long;
    longp3 = &aliased_long;
    aliased_long = random();
    output_long = aliased_long * 2 * 3 * 4;
    CALL(op0, (longp1, longp2, longp3), mgr_failures, failures);
    if (aliased_long != output_long)
    {
        FAIL("Top-level pointer aliasing failed in op0\n", failures);
    }
    else
    	SUCCESS("op0: completed sucessfully\n", mgr_failures);

    longtp1 = &aliased_longt;
    longtp2 = &aliased_longt;
    longtp3 = &aliased_longt;
    aliased_longt = random();
    output_longt = aliased_longt * 2 * 3 * 4;
    CALL(op1, (longtp1, longtp2, longtp3), mgr_failures, failures);
    if (aliased_longt != output_longt)
    {
        FAIL("Top-level pointer aliasing failed in op1\n", failures);
    }
    else
    	SUCCESS("op1: completed sucessfully\n", mgr_failures);

/*
 * Top-level pointers to aliased conformant objects.
 */
    longap1 = aliased_longa;
    longap2 = aliased_longa;
    longap3 = aliased_longa;
    for (i = 0 ; i < ARRAY_SIZE ; i++)
    {
        aliased_longa[i] = random();
        output_longa[i] = aliased_longa[i] * 2 * 3 * 4;
    }
    CALL(op2, (longap1, longap2, longap3, ARRAY_SIZE), mgr_failures, failures);
    for (i = 0 ; i < ARRAY_SIZE ; i++)
    {
        if (aliased_longa[i] != output_longa[i])
            FAIL_BREAK("Top-level pointer aliasing failed in op2\n", failures);
    }

    SUCCESS("op2: completed sucessfully\n", mgr_failures);

/*
 * A circular doubly-linked list.
 */
    for (i = NUM_NODES ; i > 0 ; i--)
    {
        /* Insert new entry at head. */
        MALLOC(node_p, node_t);
        node_p->l = i * i;
        node_p->flink = list;
        if (list == NULL)
            node_p->blink = node_p->flink = node_p;
        else
        {
            /* Point forward link of new node at current first node. */
            node_p->flink = list;
            /* Point backward link of new node at current last node. */
            node_p->blink = list->blink;
            /* Point current last node forward link at new node. */
            list->blink->flink = node_p;
            /* Point current first node backward link at new node. */
            list->blink = node_p;
        }
        /* Finally, update listhead to point at new node. */
        list = node_p;
    }
    /* Manager routine reverses the list. */
    CALL(op3, (&list), mgr_failures, failures);
    /* Check accessibility via blinks. */
    if (list == NULL)
    {
        FAIL("Out value of ptr to doubly-linked list NULL in op3\n", failures);
    }
    else
    {
        /* Check accessibility via blinks. */
        i = 0;
        node_p = list->blink;
        do
        {
            i++;
            if (node_p->l != i * i)
                FAIL_BREAK("Aliasing in doubly-linked list failed in op3\n", failures);
            node_p = node_p->blink;
        } while (node_p != list->blink);

        /* Check accessibility via flinks. */
        i = NUM_NODES;
        node_p = list;
        do
        {
            if (node_p->l != i * i)
                FAIL_BREAK("Aliasing in doubly-linked list failed in op3\n", failures);
            node_p = node_p->flink;
            i--;
        } while (node_p != list);
    }

    SUCCESS("op3: completed sucessfully\n", mgr_failures);

/*
 * Aliasing with mixed ref and ptr pointers to the same type.
 */
    MALLOC(struct_ptr, struct_t);
    struct_ptr->l = 0;
    struct_list_p = NULL;
    for (i = LIST_SIZE ; i > 0 ; i--)
    {
        MALLOC(temp, struct_list_t);
        temp->next = struct_list_p;
        MALLOC(temp->struct_ref, struct_t);
        temp->struct_ref->l = i * 2;
        temp->struct_ptr = struct_ptr;
        struct_list_p = temp;
    }
    CALL(op4, (struct_list_p), mgr_failures, failures);
    i = 0;
    do
    {
        i++;
        if (struct_list_p->struct_ref->l != i * 2 * 3
            ||  struct_list_p->struct_ptr == NULL
            ||  struct_list_p->struct_ptr->l != LIST_SIZE * -7)
            FAIL_BREAK("ref/ptr aliasing failed in op4\n", failures);
        struct_list_p = struct_list_p->next;
    } while (struct_list_p != NULL);

    SUCCESS("op4: completed sucessfully\n", mgr_failures);

    if (failures != 0)
        fprintf(stderr, "%d failures.\n", failures);

    return failures;
}

