/* $Id: lxapilib.c,v 1.2 2002/04/26 23:09:44 smilcke Exp $ */

/*
 * lxapilib.c
 * Autor:               Stefan Milcke
 * Erstellt am:         08.01.2002
 * Letzte Aenderung am: 14.04.2002
 *
*/

#ifdef __cplusplus
extern "C" {
#endif

#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>

#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>
#include <linux/mm.h>
#include <asm/uaccess.h>
#include <ioremap.h>
#include <asm/page.h>
#include <linux/types.h>
#include <linux/i2c.h>
#include <linux/i2c-algo-bit.h>
#include <linux/vmalloc.h>

#include <lxapiidc.h>

#ifndef DebugInt3
#define DebugInt3() _asm int 3;
#endif

/******************************************************************************/
/* function pointers                                                          */
/******************************************************************************/
//-------------------------------- OS2 specific --------------------------------
unsigned long (*OS2_lxioctl)(void __far *requestPacketPtr)=NULL;
int (*OS2_add_module)(struct os2lx_module *pModule)=NULL;
int (*OS2_apply_mod_parm)(char *parm,struct os2lx_parm *parmList,int num)=NULL;
int (*OS2_set_module_parm)(char *parm)=NULL;
int (*OS2_get_num_modules)(void)=NULL;
int (*OS2_get_total_num_modules)(void)=NULL;
char *(*OS2_get_module_name)(int nr)=NULL;
int (*OS2_enum_modules)(void *buffer,unsigned long buffer_len)=NULL;

//------------------------------ resource manager ------------------------------
unsigned long __cdecl (*RM32CreateDriver)(DRIVERSTRUCT*,HDRIVER*)=NULL;
unsigned long __cdecl (*RM32DestroyDriver)(HDRIVER)=NULL;
unsigned long __cdecl (*RM32CreateAdapter)(HDRIVER,HADAPTER*,ADAPTERSTRUCT*,HDEVICE,AHRESOURCE*)=NULL;
unsigned long __cdecl (*RM32DestroyAdapter)(HDRIVER,HADAPTER)=NULL;
unsigned long __cdecl (*RM32CreateDevice)(HDRIVER,HDEVICE*,DEVICESTRUCT*,HADAPTER,AHRESOURCE*)=NULL;
unsigned long __cdecl (*RM32DestroyDevice)(HDRIVER,HDEVICE)=NULL;
unsigned long __cdecl (*RM32AllocResource)(HDRIVER,HRESOURCE*,RESOURCESTRUCT*)=NULL;
unsigned long __cdecl (*RM32DeallocResource)(HDRIVER,HRESOURCE)=NULL;
unsigned long __cdecl (*RM32ModifyResources)(HDRIVER,HADAPTER,USHORT,HRESOURCE)=NULL;

//--------------------------- video for linux (V4L) ----------------------------
int (*OS2_v4lx_enum_devices)(void *buffer,unsigned long buffer_len)=NULL;
unsigned long (*OS2_v4lx_get_num_devices)(void)=NULL;
int (*OS2_v4lx_open_device)(char *devname)=NULL;
int (*OS2_v4lx_close_device)(int handle)=NULL;
void (*OS2_v4lx_close_all_opened_devices)(void)=NULL;
struct video_device *(*OS2_v4lx_get_opened_device)(int handle)=NULL;
int (*OS2_v4lx_ioctl)(int handle,int ioctlfn,void *userData)=NULL;

//----------------------------- memory management ------------------------------
void *(*__malloc)(unsigned long size)=NULL;
void *malloc(unsigned long size){ return __malloc(size); }
void (*__free)(void *ptr)=NULL;
void free(void *ptr){ __free(ptr); }
void *(*kmalloc)(int size,int flags)=NULL;
void (*kfree)(const void *ptr)=NULL;
void *(*vmalloc)(unsigned long size)=NULL;
void *(*__vmalloc)(unsigned long size,int gfp_mask,pgprot_t prot)=NULL;
void (*vfree)(void *ptr)=NULL;
void (*kfree_s)(const void *ptr,int size)=NULL;
unsigned long (*virt_to_phys)(void *address)=NULL;
void *(*phys_to_virt)(unsigned long adress)=NULL;
int (*free_pages)(unsigned long addr,unsigned long order)=NULL;
struct page *(*alloc_pages)(int gfp_mask,unsigned long order)=NULL;
int (*remap_page_range)(unsigned long from,unsigned long to,unsigned long size,pgprot_t prot)=NULL;
int (*is_access_ok)(int type,void *addr,unsigned long size)=NULL;
void (*__copy_user)(void *to,const void *from,unsigned long n)=NULL;
unsigned long (*copy_to_user)(void *to,const void *from,unsigned long n)=NULL;
void (*__copy_user_zeroing)(void *to,const void *from,unsigned long n)=NULL;
unsigned long (*copy_from_user)(void *to,const void *from,unsigned long n)=NULL;
int (*get_user)(int size,void *dest,void *src)=NULL;
int (*put_user)(int x,void *ptr)=NULL;
unsigned long (*ioremap)(unsigned long addr,unsigned short usSize)=NULL;
void (*iounmap)(void *addr)=NULL;

//---------------------------- semaphore management ----------------------------
void (*init_MUTEX)(struct semaphore *sem)=NULL;
void (*init_MUTEX_LOCKED)(struct semaphore *sem)=NULL;
void (*down)(struct semaphore *sem)=NULL;
void (*up)(struct semaphore *sem)=NULL;

//---------------------------- spinlock management -----------------------------
void (*spin_lock_init)(spinlock_t *lock)=NULL;
void (*spin_lock)(spinlock_t *lock)=NULL;
void (*spin_lock_flag)(spinlock_t *lock,unsigned long *flag)=NULL;
int (*spin_trylock)(spinlock_t *lock)=NULL;
void (*spin_unlock_wait)(spinlock_t *lock)=NULL;
void (*spin_unlock)(spinlock_t *lock)=NULL;

//----------------------------- module management ------------------------------
int (*request_module)(const char *name)=NULL;
int (*release_module)(const char *name)=NULL;

//---------------------------- schedule management -----------------------------
unsigned long volatile *__jiffies=NULL;
struct task_struct **__current=NULL;
void (*add_wait_queue)(wait_queue_head_t *q,wait_queue_t *wait)=NULL;
void (*add_wait_queue_exclusive)(wait_queue_head_t *q)=NULL;
void (*remove_wait_queue)(wait_queue_head_t *q,wait_queue_t *wait)=NULL;
void (*__wake_up)(wait_queue_head_t *q,unsigned int mode)=NULL;
void (*sleep_on)(wait_queue_head_t *q)=NULL;
long (*sleep_on_timeout)(wait_queue_head_t *q,signed long timeout)=NULL;
void (*interruptible_sleep_on)(wait_queue_head_t *q)=NULL;
long (*interruptible_sleep_on_timeout)(wait_queue_head_t *q,signed long timeout)=NULL;
void (*wake_up_process)(struct task_struct *tsk)=NULL;
signed long (*schedule_timeout)(signed long timeout)=NULL;
void (*schedule)(void)=NULL;
int (*kernel_thread)(int (*initFn)(void*),int (*fn)(void *),int (*exitFn)(void *),void *arg,unsigned long flags)=NULL;
void (*tasklet_hi_schedule)(struct tq_struct *t)=NULL;
void init_waitqueue_head(wait_queue_head_t *q){}

//------------------------------ timer management ------------------------------
void (*add_timer)(struct timer_list * timer)=NULL;
int (*mod_timer)(struct timer_list *timer,unsigned long expires)=NULL;
int (*del_timer)(struct timer_list *timer)=NULL;

//---------------------------- resource management -----------------------------
struct resource *__ioport_resource=NULL;
struct resource *__iomem_resource=NULL;
int (*request_resource)(struct resource *root,struct resource *newr)=NULL;
int (*release_resource)(struct resource *old)=NULL;
int (*allocate_resource)(struct resource *root,struct resource *newr,unsigned long size,unsigned long min,unsigned long max,unsigned long align,void (*alignf)(void *,struct resource*,unsigned long),void *alignf_data)=NULL;
int (*request_irq)(unsigned int irq,void(*handler)(int,void*,struct pt_regs*regs),unsigned long flags,const char *name,void *data,struct lxrm_resource* rm_resource)=NULL;
void (*free_irq)(unsigned int irq,void *data,struct lxrm_resource* rm_resource)=NULL;
void (*eoi_irq)(unsigned int irq)=NULL;
int (*__check_region)(struct resource *a,unsigned long b,unsigned long c)=NULL;
struct resource* (*__request_region)(struct resource *a, unsigned long start, unsigned long n, const char *name,struct lxrm_resource *rm_resource);
void (*__release_region)(struct resource *a,unsigned long b,unsigned long c,struct lxrm_resource *rm_resource)=NULL;

//------------------------------- pci management -------------------------------
int *__pci_pci_problems=NULL;
void (*pcibios_init)(void)=NULL;
void (*pcibios_fixup_bus)(struct pci_bus *bus)=NULL;
int (*pcibios_enable_device)(struct pci_dev *dev)=NULL;
void (*pcibios_align_resource)(void *,struct resource *,unsigned long)=NULL;

struct pci_dev *(*pci_find_device)(unsigned int vendor,unsigned int device,const struct pci_dev *from)=NULL;
struct pci_dev *(*pci_find_subsys)(unsigned int vendor,unsigned int device,unsigned int ss_vendor,unsigned int ss_device,const struct pci_dev *from)=NULL;
struct pci_dev *(*pci_find_class)(unsigned int pciclass,const struct pci_dev *from)=NULL;
struct pci_dev *(*pci_find_slot)(unsigned int bus,unsigned int devfn)=NULL;
int (*pci_find_capability)(struct pci_dev *dev,int cap)=NULL;

int (*pci_read_config_byte)(struct pci_dev *dev, int where, u8 *val)=NULL;
int (*pci_read_config_word)(struct pci_dev *dev, int where, u16 *val)=NULL;
int (*pci_read_config_dword)(struct pci_dev *dev, int where, u32 *val)=NULL;
int (*pci_write_config_byte)(struct pci_dev *dev, int where, u8 val)=NULL;
int (*pci_write_config_word)(struct pci_dev *dev, int where, u16 val)=NULL;
int (*pci_write_config_dword)(struct pci_dev *dev, int where, u32 val)=NULL;

int (*pci_enable_device)(struct pci_dev *dev)=NULL;
void (*pci_disable_device)(struct pci_dev *dev)=NULL;
void (*pci_set_master)(struct pci_dev *dev)=NULL;
int (*pci_assign_resource)(struct pci_dev *dev, int i)=NULL;

int (*pci_register_driver)(struct pci_driver *)=NULL;
void (*pci_unregister_driver)(struct pci_driver *)=NULL;
void (*pci_insert_device)(struct pci_dev *, struct pci_bus *)=NULL;
void (*pci_remove_device)(struct pci_dev *)=NULL;
struct pci_driver *(*pci_dev_driver)(const struct pci_dev *)=NULL;
const struct pci_device_id *(*pci_match_device)(const struct pci_device_id *ids, const struct pci_dev *dev)=NULL;

//------------------------------- i2c management -------------------------------
int (*i2c_probe)(struct i2c_adapter *adapter,struct i2c_client_address_data *adress_data,i2c_client_found_addr_proc *found_proc)=NULL;
int (*i2c_add_driver)(struct i2c_driver *)=NULL;
int (*i2c_del_driver)(struct i2c_driver *)=NULL;
int (*i2c_attach_client)(struct i2c_client *)=NULL;
int (*i2c_detach_client)(struct i2c_client *)=NULL;
int (*i2c_master_send)(struct i2c_client *,const char *,int)=NULL;
int (*i2c_master_recv)(struct i2c_client *,char *,int)=NULL;
int (*i2c_transfer)(struct i2c_adapter *adap,struct i2c_msg *msg,int num)=NULL;

int (*i2c_bit_add_bus)(struct i2c_adapter *)=NULL;
int (*i2c_bit_del_bus)(struct i2c_adapter *)=NULL;

//---------------------------------- videodev ----------------------------------
int (*video_register_device)(struct video_device *,int type,int nr)=NULL;
void (*video_unregister_device)(struct video_device *)=NULL;

/******************************************************************************/
/* Initialisation                                                             */
/******************************************************************************/
struct _IDCTABLE
{
 USHORT Reserved[3];
 VOID (FAR *ProtIDCEntry)(VOID);
 USHORT ProtIDC_DS;
};
typedef struct _IDCTABLE IDCTABLE;
typedef struct _IDCTABLE *PIDCTABLE;

static IDCTABLE IDCTable={0};

extern ULONG __cdecl AttachToDD(char *ddname,IDCTABLE *table);
extern ULONG __cdecl CallIDC(IDCTABLE *table,ULONG cmd,ULONG value);

#define DECLARE_LXAPI_STRUCT(type) \
type api={LXAPI_VERSION};

#define DECLARE_LXAPI_STRUCT_AND_GET(type,cmd) \
type api={LXAPI_VERSION}; \
rc=CallIDC(&IDCTable,(ULONG)cmd,(ULONG)&api); \
if(!rc)


#define GETFROMLXAPI(name)name=api.name;

//------------------------------- OS2_initlxapi --------------------------------
int OS2_initlxapi(void)
{
 int rc=0;
 rc=AttachToDD("LXAPI32$",&IDCTable);
 if(!rc)
 { // get OS2 specific
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETOS2API,LXIDCCMD_GETOS2API)
  {
   GETFROMLXAPI(OS2_lxioctl);
   GETFROMLXAPI(OS2_add_module);
   GETFROMLXAPI(OS2_apply_mod_parm);
   GETFROMLXAPI(OS2_set_module_parm);
   GETFROMLXAPI(OS2_get_num_modules);
   GETFROMLXAPI(OS2_get_total_num_modules);
   GETFROMLXAPI(OS2_get_module_name);
   GETFROMLXAPI(OS2_enum_modules);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETRMAPI,LXIDCCMD_GETRMAPI)
  {
   GETFROMLXAPI(RM32CreateDriver);
   GETFROMLXAPI(RM32DestroyDriver);
   GETFROMLXAPI(RM32CreateAdapter);
   GETFROMLXAPI(RM32DestroyAdapter);
   GETFROMLXAPI(RM32CreateDevice);
   GETFROMLXAPI(RM32DestroyDevice);
   GETFROMLXAPI(RM32AllocResource);
   GETFROMLXAPI(RM32DeallocResource);
   GETFROMLXAPI(RM32ModifyResources);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETV4LAPI,LXIDCCMD_GETV4LAPI)
  {
   GETFROMLXAPI(OS2_v4lx_enum_devices);
   GETFROMLXAPI(OS2_v4lx_get_num_devices);
   GETFROMLXAPI(OS2_v4lx_open_device);
   GETFROMLXAPI(OS2_v4lx_close_device);
   GETFROMLXAPI(OS2_v4lx_close_all_opened_devices);
   GETFROMLXAPI(OS2_v4lx_get_opened_device);
   GETFROMLXAPI(OS2_v4lx_ioctl);
  }
 }
 if(!rc)
 { // get memory management
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETMEMAPI,LXIDCCMD_GETMEMAPI)
  {
   __malloc=api.malloc;
   __free=api.free;
   GETFROMLXAPI(kmalloc);
   GETFROMLXAPI(kfree);
   GETFROMLXAPI(vmalloc);
   GETFROMLXAPI(__vmalloc);
   GETFROMLXAPI(vfree);
   GETFROMLXAPI(kfree_s);
   GETFROMLXAPI(virt_to_phys);
   GETFROMLXAPI(phys_to_virt);
   GETFROMLXAPI(free_pages);
   GETFROMLXAPI(alloc_pages);
   GETFROMLXAPI(remap_page_range);
   GETFROMLXAPI(is_access_ok);
   GETFROMLXAPI(__copy_user);
   GETFROMLXAPI(copy_to_user);
   GETFROMLXAPI(__copy_user_zeroing);
   GETFROMLXAPI(copy_from_user);
   GETFROMLXAPI(get_user);
   GETFROMLXAPI(put_user);
   GETFROMLXAPI(ioremap);
   GETFROMLXAPI(iounmap);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETSEMAPI,LXIDCCMD_GETSEMAPI)
  {
   GETFROMLXAPI(init_MUTEX);
   GETFROMLXAPI(init_MUTEX_LOCKED);
   GETFROMLXAPI(down);
   GETFROMLXAPI(up);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETSLCAPI,LXIDCCMD_GETSLCAPI)
  {
   GETFROMLXAPI(spin_lock_init);
   GETFROMLXAPI(spin_lock);
   GETFROMLXAPI(spin_lock_flag);
   GETFROMLXAPI(spin_trylock);
   GETFROMLXAPI(spin_unlock_wait);
   GETFROMLXAPI(spin_unlock);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETMODAPI,LXIDCCMD_GETMODAPI)
  {
   GETFROMLXAPI(request_module);
   GETFROMLXAPI(release_module);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETSCHAPI,LXIDCCMD_GETSCHAPI)
  {
   GETFROMLXAPI(__jiffies);
   GETFROMLXAPI(__current);
   GETFROMLXAPI(add_wait_queue);
   GETFROMLXAPI(add_wait_queue_exclusive);
   GETFROMLXAPI(remove_wait_queue);
   GETFROMLXAPI(__wake_up);
   GETFROMLXAPI(sleep_on);
   GETFROMLXAPI(sleep_on_timeout);
   GETFROMLXAPI(interruptible_sleep_on);
   GETFROMLXAPI(interruptible_sleep_on_timeout);
   GETFROMLXAPI(wake_up_process);
   GETFROMLXAPI(schedule_timeout);
   GETFROMLXAPI(schedule);
   GETFROMLXAPI(kernel_thread);
   GETFROMLXAPI(tasklet_hi_schedule);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETTIMAPI,LXIDCCMD_GETTIMAPI)
  {
   GETFROMLXAPI(add_timer);
   GETFROMLXAPI(mod_timer);
   GETFROMLXAPI(del_timer);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETRESAPI,LXIDCCMD_GETRESAPI)
  {
   GETFROMLXAPI(__ioport_resource);
   GETFROMLXAPI(__iomem_resource);
   GETFROMLXAPI(request_resource);
   GETFROMLXAPI(release_resource);
   GETFROMLXAPI(allocate_resource);
   GETFROMLXAPI(request_irq);
   GETFROMLXAPI(free_irq);
   GETFROMLXAPI(eoi_irq);
   GETFROMLXAPI(__check_region);
   GETFROMLXAPI(__request_region);
   GETFROMLXAPI(__release_region);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETPCIAPI,LXIDCCMD_GETPCIAPI)
  {
   GETFROMLXAPI(__pci_pci_problems);
   GETFROMLXAPI(pcibios_init);
   GETFROMLXAPI(pcibios_fixup_bus);
   GETFROMLXAPI(pcibios_enable_device);
   GETFROMLXAPI(pcibios_align_resource);

   GETFROMLXAPI(pci_find_device);
   GETFROMLXAPI(pci_find_subsys);
   GETFROMLXAPI(pci_find_class);
   GETFROMLXAPI(pci_find_slot);
   GETFROMLXAPI(pci_find_capability);

   GETFROMLXAPI(pci_read_config_byte);
   GETFROMLXAPI(pci_read_config_word);
   GETFROMLXAPI(pci_read_config_dword);
   GETFROMLXAPI(pci_write_config_byte);
   GETFROMLXAPI(pci_write_config_word);
   GETFROMLXAPI(pci_write_config_dword);

   GETFROMLXAPI(pci_enable_device);
   GETFROMLXAPI(pci_disable_device);
   GETFROMLXAPI(pci_set_master);
   GETFROMLXAPI(pci_assign_resource);

   GETFROMLXAPI(pci_register_driver);
   GETFROMLXAPI(pci_unregister_driver);
   GETFROMLXAPI(pci_insert_device);
   GETFROMLXAPI(pci_remove_device);
   GETFROMLXAPI(pci_dev_driver);
   GETFROMLXAPI(pci_match_device);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETI2CAPI,LXIDCCMD_GETI2CAPI)
  {
   GETFROMLXAPI(i2c_probe);
   GETFROMLXAPI(i2c_add_driver);
   GETFROMLXAPI(i2c_del_driver);
   GETFROMLXAPI(i2c_attach_client);
   GETFROMLXAPI(i2c_detach_client);
   GETFROMLXAPI(i2c_master_send);
   GETFROMLXAPI(i2c_master_recv);
   GETFROMLXAPI(i2c_transfer);
   GETFROMLXAPI(i2c_bit_add_bus);
   GETFROMLXAPI(i2c_bit_del_bus);
  }
 }
 if(!rc)
 {
  DECLARE_LXAPI_STRUCT_AND_GET(LXIDC_GETVIDAPI,LXIDCCMD_GETVIDAPI)
  {
   GETFROMLXAPI(video_register_device);
   GETFROMLXAPI(video_unregister_device);
  }
 }
 return rc;
}

#ifdef __cplusplus
};
#endif