; $Id: lxapihlp.asm,v 1.2 2002/04/26 23:09:44 smilcke Exp $

;
; lxapi.asm
; Autor:               Stefan Milcke
; Erstellt am:         08.12.2001
; Letzte Aenderung am: 27.03.2002
;
       .386p

       include seg32.inc
       include devhlp.inc

DATA16 segment
       extrn DeviceHelp : DWORD

ddname         db[10]  dup (0)
ddtable        db[12] dup (0)
IdcPtr         dd 0
DATA16 ends

CODE16 segment
       assume cs:CODE16, ds:DATA16
thunk3216_attachdd:
       push    ds
       push    DATA16
       pop     ds
       mov     bx,(offset ddname)
       mov     di,(offset ddtable)
       mov     dl,DevHlp_AttachDD
       call    dword ptr ds:(offset DeviceHelp)
       setc    dl
       xor     eax,eax
       mov     al,dl
       pop     ds
       jmp     far ptr FLAT:thunk1632_attachdd

       ALIGN   2
thunk3216_callidc:
       ; eax -> fptr
       ; ecx -> cmd
       ; ebx -> value
       push    ds
       push    DATA16
       pop     ds
       mov     IdcPtr,eax
       mov     edx,ebx         ; Value to edx
       shr     edx,16          ; Shift upper 16 bits of ULONG parameter
       call    dword ptr ds:(offset IdcPtr)  ; Call IDC entry point
       pop     ds
       jmp     far ptr FLAT:thunk1632_callidc

       ALIGN   2
CODE16 ends

CODE32 segment
ASSUME CS:FLAT, DS:FLAT, ES:FLAT
       public _AttachToDD
       public _CallIDC
IFDEF KEE
	extrn  KernThunkStackTo16 : near
	extrn  KernThunkStackTo32 : near
ENDIF

_AttachToDD proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    name
       ; 0ch[ebp] ->    table
       mov     edi,08h[ebp]
       mov     esi,edi
       sub     ecx,ecx
       dec     ecx
       xor     eax,eax
       repne   scasb
       not     ecx
       mov     edi,offset ddname
       repne   movsb
IFDEF  KEE
       push    eax
       call    KernThunkStackTo16
       pop     eax
ENDIF
       jmp     far ptr CODE16:thunk3216_attachdd

       ALIGN   4
thunk1632_attachdd:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     eax,0
       jne     @F
       mov     edi,0ch[ebp]
       mov     esi,offset ddtable
       mov     ecx,3
       repne   movsd
@@:    pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_AttachToDD endp

       ALIGN   4
_CallIDC proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    table
       ; 0ch[ebp] ->    cmd
       ; 10h[ebp] ->    value
       mov     eax,08h[ebp]
       mov     eax,[eax+6]
       mov     ecx,0ch[ebp]
       mov     ebx,10h[ebp]
IFDEF  KEE
       push    eax
       push    edx
       call    KernThunkStackTo16
       pop     edx
       pop     eax
ENDIF
       jmp     far ptr CODE16:thunk3216_callidc
thunk1632_callidc:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_CallIDC endp

CODE32 ends

DATA32 segment
DATA32 ends

end

