/* $Id: makelog.cmd,v 1.2 2002/04/26 23:09:44 smilcke Exp $ */

/* Sample input.

   error num=1  symbol=ErrorMaxOpens text="Maximum number of opens exceeded"
   error num=2  symbol=ErrorBadParm  text="Bad parameter"
   trace num=1  symbol=TraceSHDD     text="SHDD entry"
   status num=1 symbol=TraceSHDD     text="SHDD entry"

   Full ddprintf() formatting symbols are supported for 'text'.
*/

/* Load up REXX extensions. */
CALL RXFUNCADD 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs

msgNumHdrFile = 'logmsg.hpp'
msgDataFile = 'logmsg.cpp'
rc = SysFileDelete( msgNumHdrFile );
rc = SysFileDelete( msgDataFile );

error.lastNum = 0
trace.lastNum = 0
status.lastNum = 0

lineNum = 0
do while lines() <> 0
   lineText = linein();
   lineNum = lineNum + 1
   if Word( lineText, 1 ) = ";" then iterate;
   if Word( lineText, 1 ) = "" then iterate;
   parse value lineText with msg.type "num=" msg.num "symbol=" msg.sym "text=" msg.txt
   msg.type = strip( msg.type );
   msg.num = strip( msg.num );
   msg.sym = strip( msg.sym );
   msg.txt = strip( msg.txt );

   i = msg.num;
   if datatype(i) <> 'NUM' then do
      say "Line" lineNum || ": Expecting a numeric value for a 'num=', found:"
      say "        " i
      return 1
   end
   if words(msg.sym) <> 1 then do
      say "Line" lineNum || ": Expecting a single token for 'symbol=', found :"
      say "        " msg.sym
      return 1
   end
   Select
      When msg.type = 'error' then do
         if error.i.defined = 'TRUE' then do
            say "Line" lineNum || ": redefining error number" i
            return 1;
         end;
         error.i.txt = msg.txt
         error.i.sym = msg.sym
         error.i.defined = TRUE;
         if i > error.lastNum then error.lastNum = i;
      end;
      When msg.type = 'trace' then do
         if trace.i.defined = 'TRUE' then do
            say "Line" lineNum || ": redefining trace number" i
            return 1;
         end;
         trace.i.txt = msg.txt
         trace.i.sym = msg.sym
         trace.i.defined = TRUE;
         if i > trace.lastNum then trace.lastNum = i;
      end;
      When msg.type = 'status' then do
         if status.i.defined = 'TRUE' then do
            say "Line" lineNum || ": redefining status number" i
            return 1;
         end;
         status.i.txt = msg.txt
         status.i.sym = msg.sym
         status.i.defined = TRUE;
         if i > status.lastNum then status.lastNum = i;
      end;
      Otherwise
         say "Line" lineNum || ": expecting <error, trace, status> keyword or comment, found:"
         say "Line" lineNum || ":" lineText
         return 1;
   end;  /* Select */
end;

call lineout msgDataFile , ""
call lineout msgDataFile , "PSZ apszErrorMessage[] = {"
do i = 0 to error.lastNum
   /* If error number 'i' is defined, then print it out. */
   if error.i.defined <> TRUE then do
      call lineout msgDataFile , '   (PSZ) "",'
   end
   else do
      call lineout msgNumHdrFile , "const int" error.i.sym "=" i ";"
      call lineout msgDataFile , "   (PSZ) " || error.i.txt || ","
   end;
end;
call lineout msgDataFile , "};  // apszErrorMessage[] "

call lineout msgDataFile , ""
call lineout msgDataFile , "PSZ apszTraceMessage[] = {"
do i = 0 to trace.lastNum
   /* If trace number 'i' is defined, then print it out. */
   if trace.i.defined <> TRUE then do
      call lineout msgDataFile , '   (PSZ) "",'
   end
   else do
      call lineout msgNumHdrFile , "const int" trace.i.sym "=" i ";"
      call lineout msgDataFile , "   (PSZ) " || trace.i.txt || ","
   end;
end;
call lineout msgDataFile , "};  // apszTraceMessage[] "
call lineout msgDataFile , ""

call lineout msgDataFile , ""
call lineout msgDataFile , "PSZ apszStatusMessage[] = {"
do i = 0 to status.lastNum
   /* If status number 'i' is defined, then print it out. */
   if status.i.defined <> TRUE then do
      call lineout msgDataFile , '   (PSZ) "",'
   end
   else do
      call lineout msgNumHdrFile , "const int" status.i.sym "=" i ";"
      call lineout msgDataFile , "   (PSZ) " || status.i.txt || ","
   end;
end;
call lineout msgDataFile , "};  // apszStatusMessage[] "

