/* $Id: Config.cmd,v 1.2 2002/04/26 23:09:43 smilcke Exp $ */

/*
 * Configuration script.
 * Generates global makefile.inc.
 *
 * Copyright (c) 1999-2000 knut st. osmundsen (knut.stange.osmundsen@pmsc.no)
 * Modified for BT-Drivers 2002 Stefan Milcke
 *
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs';
Call SysLoadFuncs;

Parse Arg sIncFile
if (sIncFile='') Then sIncFile='paths.mak'

Say 'Current directory:'directory()
Say 'Generating 'directory()'\'sIncFile

/* Status */
Say 'Configuring the LXAPI32 driver...'

/* delete old file */
Call SysFileDelete sIncFile

/* open target file */
If (Stream(sIncFile, 'C', 'OPEN WRITE' ) <> '') Then
Do
 Call LineOut sIncFile, '################################################################################'
 Call LineOut sIncFile, '# Generated by 'directory()'\config.cmd'
 Call LineOut sIncFile, '################################################################################'
 Call LineOut sIncFile, ''
 Call LineOut sIncFile, '################################################################################'
 Call LineOut sIncFile, '# Base directories'
 Call LineOut sIncFile, '# Note! These should be absolute paths!'
 Call LineOut sIncFile, '################################################################################'
 Call LineOut sIncFile, ''
 Call LineOut sIncFile, '!ifndef DEVTYPE'
 Call LineOut sIncFile, '!error DEVTYPE not defined!'
 Call LineOut sIncFile, '!endif'
 sBase=directory();
 Call LineOut sIncFile, ''
 Call LineOut sIncFile, 'DRV_BASE        ='sBase
 Call LineOut sIncFile, 'LX_BASE         =$(%LXAPI32DEV)'
 Call LineOut sIncFile, ''
 Call LineOut sIncFile, 'LX_MAINMAKE     =$(%LXAPI32DEV)\makes\mainmake.mak'
 Call LineOut sIncFile, ''
 Call WriteSubDir 'DRV_BIN'	,'bin'
 Call WriteSubDir 'DRV_INC'	,'inc'
 Call LineOut sIncFile, 'DRV_INCLUDE     =..\include;$(%LXAPI32DEV)\include'
 Call WriteSubDir 'DRV_LIB'	,'lib'
 Call WriteSubDir 'DRV_MAKES'	,'makes'
 Call WriteSubDir 'DRV_TOOLS'	,'tools'
 Call WriteSubDir 'DRV_BTTV'	,'bttv'
 Call WriteSubDir 'DRV_LIB32'	,'lib32'
 Call WriteSubDir 'DRV_DEV32'	,'dev32'
 Call WriteSubDir 'DRV_LINUX'	,'linux'
 Call LineOut sIncFile, 'DRV_OBJ         =bin'
 Call LineOut sIncFile, ''
 Call LineOut sIncFile, '!ifeq DEVTYPE DEV32'
 Call WriteSubDir 'DRV_SRC'	,'dev32'
 Call LineOut sIncFile, '!endif'

 Call LineOut sIncFile, ''
 Call LineOut sIncFile, '!ifeq DEVTYPE LIB32'
 Call WriteSubDir 'DRV_SRC'	,'lib32'
 Call LineOut sIncFile, '!endif'

 Call LineOut sIncFile, ''
 Call LineOut sIncFile, '!ifeq DEVTYPE PCI'
 Call WriteSubDir 'DRV_SRC'	,'pci'
 Call LineOut sIncFile, '!endif'

 Call LineOut sIncFile, ''
 Call LineOut sIncFile, '!ifeq DEVTYPE I2C'
 Call WriteSubDir 'DRV_SRC'	,'i2c'
 Call LineOut sIncFile, '!endif'

 Call LineOut sIncFile, ''
 Call LineOut sIncFile, 'CM_TOOLS        =$(LX_BASE)\tools'

 Call Stream sIncFile, 'C', 'CLOSE';

 Call directory(sOldDir);
 Say ''
 Say 'Configuration completed!'
 Say 'To build the LXAPI32 driver release version do:'
 Say '   WMAKE /ms'
 Say 'To build the LXAPI32 driver debug version do:'
 Say '   WMAKE /ms DEBUG=1'
End
Else
Do
 Say 'oops, failed to open outputfile,' sIncFile;
 Exit 1;
End
Exit 0;



/*****************/
/* function area */
/*****************/
WriteSubDir: Procedure Expose sIncFile
 M=Arg(1)
 SubDir=Arg(2)
 If SubDir='' Then
 Do
  SubDir=Right(M,Length(M)-5)
 End
 If Length(M) < 16 Then
 Do
  M=Left(M'                ',16)
 End
 SubDir=Translate(SubDir,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
 Call LineOut sIncFile, M'=$(DRV_BASE)\'SubDir
Return
