/* $Id: sprintf.c,v 1.2 2002/04/26 23:09:41 smilcke Exp $ */

/*
 * sprintf.c
 * Autor:               Stefan Milcke
 * Erstellt am:         05.11.2001
 * Letzte Aenderung am: 01.01.2002
 *
*/
#pragma code_seg ("_inittext");
#pragma data_seg ("_initdata","endds");

#define INCL_NOPMAPI
#define INCL_DOSMISC

#ifdef __cplusplus
extern "C" {
#endif
#include <os2.h>

#include <ldefos2.h>

#define CR 0x0d
#define LF 0x0a


#define LEADING_ZEROES          0x8000
#define SIGNIFICANT_FIELD       0x0007

char *HexLongToASCII(char *StrPtr, unsigned long wHexVal, unsigned short Option,unsigned short nlz);
char *DecLongToASCII(char *StrPtr, unsigned long lDecVal, unsigned short Option,unsigned short nlz);

//---------------------------------- sprintf -----------------------------------
int sprintf (char *buffer, const char *format, ...)
{
 char *BuildPtr=buffer;
 char *pStr = (char *) format;
 char *SubStr;
 int numLeadingZeroes;
 union
 {
  void   *VoidPtr;
  unsigned short *WordPtr;
  unsigned long  *LongPtr;
//#ifdef KEE
  unsigned long  *StringPtr;
//#else
//  double *StringPtr;
//#endif
 } Parm;
 int wBuildOption;
 Parm.VoidPtr=(void *) &format;
 Parm.StringPtr++;                         // skip size of string pointer
 while (*pStr)
 {
  switch (*pStr)
  {
   case '%':
    wBuildOption=0;
    pStr++;
    if(*pStr=='0')
    {
     wBuildOption|=LEADING_ZEROES;
     pStr++;
     if(*pStr>='0' && *pStr<='9')
     {
      numLeadingZeroes=((int)(*pStr))-((int)'0');
      pStr++;
     }
     else
      numLeadingZeroes=0;
    }
    if(*pStr=='u')                      // always unsigned
     pStr++;
    switch(*pStr)
    {
     case 'x':
     case 'X':
      BuildPtr=HexLongToASCII(BuildPtr,*Parm.LongPtr++,wBuildOption,numLeadingZeroes);
      pStr++;
      continue;
     case 'd':
      BuildPtr=DecLongToASCII(BuildPtr, *Parm.LongPtr++,wBuildOption,numLeadingZeroes);
      pStr++;
      continue;
//#ifdef KEE
     case 's':
#ifndef KEE
      DebugInt3();
#endif
      SubStr=(char *)(*Parm.StringPtr);
      if(SubStr && (*SubStr))
      {
       while((*BuildPtr++ = *SubStr++));
       BuildPtr--;                      // remove the \0
      }
      Parm.StringPtr++;
      pStr++;
      continue;
//#endif
     case 'l':
      pStr++;
      switch (*pStr)
      {
       case 'x':
       case 'X':
        BuildPtr=HexLongToASCII(BuildPtr, *Parm.LongPtr++,wBuildOption,numLeadingZeroes);
        pStr++;
        continue;
       case 'd':
        BuildPtr=DecLongToASCII(BuildPtr, *Parm.LongPtr++,wBuildOption,numLeadingZeroes);
        pStr++;
        continue;
      } // end switch
      continue;                        // dunno what he wants
     case 0:
      continue;
    } // end switch
    break;
   case '\\':
    pStr++;
    switch(*pStr)
    {
     case 'n':
      *BuildPtr++=LF;
      pStr++;
      continue;
     case 'r':
      *BuildPtr++=CR;
      pStr++;
      continue;
     case 0:
      continue;
    } // end switch
   break;
  } // end switch
  *BuildPtr++=*pStr++;
 } // end while
 *BuildPtr=0;  // cauterize the string
 return 1; //not correct
}

#ifdef __cplusplus
}
#endif
