/* $Id: ioctl.c,v 1.2 2002/04/26 23:09:38 smilcke Exp $ */

/*
 * ioctl.c
 * Autor:               Stefan Milcke
 * Erstellt am:         12.11.2001
 * Letzte Aenderung am: 28.03.2002
 *
*/

extern "C"
{
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
}

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include "devown.h"
#include <ldefos2.h>
#include <sk_ioctl.h>
#include "Ver_32.h"
#include <string.h>

extern "C"
{
#include <linux/types.h>
#include <linux/kmod.h>
#include <lxapilib.h>
};

extern "C" void *malloc(unsigned long size);
extern "C" void free(void *ptr);

char vendor[]="Stefan Milcke";

//-------------------------------- ioctl_global --------------------------------
extern "C" ULONG ioctl_global(RPIOCtl __far *rp)
{
 ULONG rc=0;
 switch(rp->Function)
 {
  case SKIOCFN_GLO_GETDRIVERINFO:
   {
    DATAPACKET(dp,PSKIOCDP_GLO_GETDRIVERINFO,rp,VERIFY_READWRITE);
    if(dp)
    {
     dp->ulVersionMajor=SK32_DRV_MAJOR_VERSION;
     dp->ulVersionMinor=SK32_DRV_MINOR_VERSION;
     dp->ulBuildLevel=BUILD_LEVEL;
     strcpy(dp->vendor,vendor);
     dp->ulNumModules=OS2_get_total_num_modules();
     dp->ulV4LXNumDevices=OS2_v4lx_get_num_devices();
    }
    else
     rc=RPERR_PARAMETER;
   }
   break;
  default:
   rc=RPERR_COMMAND;
   break;
 }
 return rc | RPDONE;
}

//--------------------------------- StratIOCtl ---------------------------------
extern "C" ULONG StratIOCtl(RPIOCtl __far* rp)
{
 switch(rp->Category)
 {
  case SKIOCCAT_GLO:
   return ioctl_global(rp);
  default:
   if(OS2_lxioctl)
    return OS2_lxioctl((void __far*)rp);
 }
 return RPERR_COMMAND | RPDONE;
}