/* $Id: init.c,v 1.2 2002/04/26 23:09:38 smilcke Exp $ */

/*
 * init.c
 * Autor:               Stefan Milcke
 * Erstellt am:         07.09.2001
 * Letzte Aenderung am: 28.03.2002
 *
*/

// Device support
extern "C"
{
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
};

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include <ldefos2.h>
#include "devown.h"
#include "Ver_32.h"

#include <string.h>
#include "sprintf.h"

extern "C"
{
#include <lxapilib.h>
#include <linux/types.h>
#include <linux/module.h>
#include <linux/kmod.h>
};

#ifdef KEE
#include <kee.h>
#endif

#include <lxapilib.h>

#define PAGE_SIZE 4096

extern "C" int verbose;
extern "C" int verbose_modulelist;
extern "C" int doint3;
extern "C" int nocoremodule;
extern "C" int nomodule;

extern unsigned long build_level;

static char ERR_ERROR[] = "ERROR: ";
static char ERR_LOCK[]  = "Unable to lock 32 bit data & code segments, exiting...\r\r\n";
static char ERR_SIGN[]  = "SK32 skeleton driver V%d.%d Build %d Copyright 2001-2002 by Stefan Milcke\r\n";
static char LOADEDMODULE[] = "Loaded module:";
static char NOMODULE[] = "No module loaded.\r\n";
static char ERR_LXAPI32[] = "Unable to attach to LXAPI32.SYS\r\n";
static char CRLF[]      = "\r\n";
static char buffer[400];

typedef struct {
 USHORT MsgLength;
 WORD32 MsgPtr;
} MSG_TABLE;

extern "C" WORD32 MSG_TABLE32;

extern "C" int sprintf(char *buffer,const char *format, ...);

//------------------------------- DevSaveMessage -------------------------------
//Print messages with DosWrite when init is done or has failed (see startup.asm)
void DevSaveMessage(char __far *str, int length)
{
 MSG_TABLE __far *msg = (MSG_TABLE __far *)__Make48Pointer(MSG_TABLE32);
 char __far *str16 = (char __far *)__Make48Pointer(msg->MsgPtr);
 int i;
 for(i=0;i<length;i++)
  str16[msg->MsgLength + i] = str[i];
 str16[msg->MsgLength + length] = 0;
 msg->MsgLength += length;
 return;
}

//-------------------------------- LockSegments --------------------------------
int LockSegments(void)
{
#ifdef KEE
 KEEVMLock lock;
#else
 char   lock[12];
 ULONG  PgCount;
#endif
 ULONG  segsize;

    /*
     * Locks DGROUP into physical memory
     */
    //NOTE: VMLock rounds base address down to nearest page
    //      So we MUST take this into account when calculating the
    //      size of our code/data
    segsize = OffsetFinalDS32 - ((OffsetBeginDS32) & ~0xFFF);
    if(segsize & 0xFFF) {
	segsize += PAGE_SIZE;
    }
    segsize &= ~0xFFF;
#ifdef KEE
    if(KernVMLock(VMDHL_LONG,
                  (PVOID)((OffsetBeginDS32) & ~0xFFF),
                  segsize,
                  &lock,
                  (KEEVMPageList*)-1,
                  0)) {
#else
    if(DevVMLock(VMDHL_LONG,
                   ((OffsetBeginDS32) & ~0xFFF),
                   segsize,
                   (LINEAR)-1,
                   __StackToFlat((ULONG)lock),
                   (LINEAR)__StackToFlat((ULONG)&PgCount))) {
#endif
	return(1);
    }
    /*
     * Locks CODE32 into physical memory
     */
    segsize = OffsetFinalCS32 - ((OffsetBeginCS32) & ~0xFFF);
    if(segsize & 0xFFF) {
	segsize += PAGE_SIZE;
    }
    segsize &= ~0xFFF;
#ifdef KEE
    if(KernVMLock(VMDHL_LONG,
                  (PVOID)((OffsetBeginCS32) & ~0xFFF),
                  segsize,
                  &lock,
                  (KEEVMPageList*)-1,
                  0)) {
#else
    if(DevVMLock(VMDHL_LONG,
                 ((OffsetBeginCS32) & ~0xFFF),
                 segsize,
                 (LINEAR)-1,
                 __StackToFlat((ULONG)lock),
                 (LINEAR)__StackToFlat((ULONG)&PgCount))) {
#endif
	return(1);
    }
    return 0;
}


//-------------------------------- WriteString ---------------------------------
static VOID WriteString(const char __far* str, int length)
{
  // Write the string
  DevSaveMessage((char __far *)str, length);
  return;
}


extern "C" void parseArgs(RPInit __far *rp);

extern "C" int skel_init_module(void);
extern "C" void skel_cleanup_module(void);

//----------------------------- extern definitions -----------------------------
extern "C"
{
extern struct os2lx_parm *skeldrv_parms;
extern int num_skeldrv_parms;
};

struct os2lx_module skel_module={"skeleton",0,skel_init_module,skel_cleanup_module,&skeldrv_parms,&num_skeldrv_parms};

//------------------------------ DiscardableInit -------------------------------
WORD32 DiscardableInit(RPInit __far* rp)
{
 GetTKSSBase();
 if(LockSegments())
 {
  WriteString(ERR_ERROR, sizeof(ERR_ERROR)-1);
  WriteString(ERR_LOCK, sizeof(ERR_LOCK)-1);
  return RPDONE | RPERR;
 }
 rp->Out.FinalCS = 0;
 rp->Out.FinalDS = 0;
 if(OS2_initlxapi())
 {
  WriteString(ERR_LXAPI32,strlen(ERR_LXAPI32));
  return RPDONE | RPERR;
 }

 // Add all supported modules
 OS2_add_module(&skel_module);

 //Do you init here:
 parseArgs(rp);
 if(doint3)
  DebugInt3();
 if(!nocoremodule)
 {
  request_module("timer");
  request_module("pci core");
  request_module("i2c core");
  request_module("videodev");
 }
 if(!nomodule)
 {
  request_module("skeleton");
 }
 if(verbose)
 {
  sprintf(buffer
          ,ERR_SIGN
          ,SK32_DRV_MAJOR_VERSION
          ,SK32_DRV_MINOR_VERSION
          ,BUILD_LEVEL);
  WriteString(buffer,strlen(buffer));
 }

 // Complete the installation
 rp->Out.FinalCS = _OffsetFinalCS16;
 rp->Out.FinalDS = _OffsetFinalDS16;

 // Confirm a successful installation
 return RPDONE;
}

