/* $Id: pcisetup.c,v 1.2 2002/04/26 23:09:36 smilcke Exp $ */

/*
 * pcisetup.c
 * Autor:    Automatic generation from CnvPciID.CMD
 * All code from setup-res.c, setup-bus.c and setup-irq.c
 *
*/

#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/pci.h>
#include <linux/init.h>

/******************************************************************************/
/* from setup-res.c                                                           */
/******************************************************************************/
//----------------------------- pci_claim_resource -----------------------------
int __init pci_claim_resource(struct pci_dev *dev,int resource)
{
 struct resource *res=&dev->resource[resource];
 struct resource *root=pci_find_parent_resource(dev,res);
 int err=-EINVAL;
 if(root!=NULL)
  err=request_resource(root,res);
 return err;
}

//-------------------------- pci_assign_bus_resource ---------------------------
static int pci_assign_bus_resource(const struct pci_bus *bus
                                   ,struct pci_dev *dev
                                   ,struct resource *res
                                   ,unsigned long size
                                   ,unsigned long min
                                   ,unsigned int type_mask
                                   ,int resno)
{
 int i;
 type_mask|=IORESOURCE_IO | IORESOURCE_MEM;
 for(i=0;i<4;i++)
 {
  struct resource *r=bus->resource[i];
  if(!r)
   continue;
  // type_mask must match
  if((res->flags ^ r->flags) & type_mask)
   continue;
  // We cannot allocate a non-prefetching resource from a pre-fetching area
  if((r->flags & IORESOURCE_PREFETCH) && !(res->flags & IORESOURCE_PREFETCH))
   continue;
  // Ok, try it out ...
  if(allocate_resource(r,res,size,min,-1,size,pcibios_align_resource,dev)<0)
   continue;
  // Update PCI config space
  pcibios_update_resource(dev,r,res,resno);
  return 0;
 }
 return -EBUSY;
}

//---------------------------- pci_assign_resource -----------------------------
int pci_assign_resource(struct pci_dev *dev,int i)
{
 const struct pci_bus *bus=dev->bus;
 struct resource *res=dev->resource+i;
 unsigned long size,min;
 size=res->end-res->start+1;
 min=(res->flags & IORESOURCE_IO) ? PCIBIOS_MIN_IO : PCIBIOS_MIN_MEM;
 if(pci_assign_bus_resource(bus,dev,res,size,min,IORESOURCE_PREFETCH,i)<0)
 {
  // That failed
  // But a prefetching area can handle a non-prefetching
  // window (it will just not perform as well).
  if(!(res->flags & IORESOURCE_PREFETCH) || pci_assign_bus_resource(bus,dev,res,size,min,0,i)<0)
  {
   CPK(printk(KERN_ERR "PCI: Failed to allocate resource %d(%lx-%lx) for %s\n",
          i, res->start, res->end, dev->slot_name));
   return -EBUSY;
  }
 }
// DBGC((KERN_ERR "  got res[%lx:%lx] for resource %d of %s\n", res->start,res->end, i, dev->name));
 return 0;
}