/* $Id: pci-irq.c,v 1.2 2002/04/26 23:09:34 smilcke Exp $ */

/*
 * pci-irq.c
 * Autor:               Stefan Milcke
 * Erstellt am:         01.11.2001
 * Letzte Aenderung am: 20.11.2001
 *
*/

#include <linux/config.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/init.h>
#include <linux/pci.h>

struct irq_router {
	char *name;
	u16 vendor, device;
	int (*get)(struct pci_dev *router, struct pci_dev *dev, int pirq);
	int (*set)(struct pci_dev *router, struct pci_dev *dev, int pirq, int new);
};

static struct irq_routing_table *pirq_table=NULL;
static struct irq_router *pirq_router=NULL;

//----------------------------- pcibios_lookup_irq -----------------------------
static int pcibios_lookup_irq(struct pci_dev *dev,int assign)
{
 u8 pin;
 struct irq_info *info;
 int i,pirq,newirq;
 int irq=0;
 u32 mask;
 struct irq_router *r=pirq_router;
 struct pci_dev *dev2;
 char *msg=NULL;
 if(!pirq_table)
  return 0;
 return 0;
 // Incomplete (SM)
}

//------------------------------ pcibios_irq_init ------------------------------
void __init pcibios_irq_init(void)
{
 // DBG("PCI: IRQ init\n");
 // Incomplete (SM)
}

//----------------------------- pcibios_enable_irq -----------------------------
void pcibios_enable_irq(struct pci_dev *dev)
{
 u8 pin;
 pci_read_config_byte(dev,PCI_INTERRUPT_PIN,&pin);
 if(pin&&!pcibios_lookup_irq(dev,1)&&!dev->irq)
 {
  // Incomplete (SM)
  /*
		char *msg;
		if (io_apic_assign_pci_irqs)
			msg = " Probably buggy MP table.";
		else if (pci_probe & PCI_BIOS_IRQ_SCAN)
			msg = "";
		else
			msg = " Please try using pci=biosirq.";
		printk(KERN_WARNING "PCI: No IRQ known for interrupt pin %c of device %s.%s\n",
		       'A' + pin - 1, dev->slot_name, msg);
  */
 }
}
