# $Id: mainmake.mak,v 1.2 2002/04/26 23:09:34 smilcke Exp $

#===================================================================
# Setup environment
#===================================================================
!ifndef LX_BASE
!error No LX paths defined.
!endif

!ifndef DEVTYPE
!error DEVTYPE not defined. Must be DEV32,LIB32 or BTTV
!endif

!ifndef DEBUG
DEBUG = 0
!endif

!ifndef KEE
KEE = 0
!endif

C16INC=$(%WATCOM)\H;$(%DDK)\BASE\H;$(%DDK)\BASE\SRC\INC;$(%DDK)\BASE\SRC\DEV\MME\WPDDLIB2;$(DRV_INCLUDE)
C32INC=$(%WATCOM)\H;$(DRV_INCLUDE);$(%DDK)\BASE\H;$(%DDK)\BASE\SRC\DEV\MME\WPDDLIB2

COMMONDEP = $(DRV_BASE)\build.cmd $(DRV_BASE)\makefile $(DRV_MAKES)\paths.mak $(LX_MAINMAKE) $(DRV_MAKES)\common.mak makefile
CNUMERRFLAG = -e20

!ifeq DEVTYPE DEV16
CINC	= $(C16INC)
WASMINC= $(DRV_INCLUDE);$(DRV_INC)
AINC	= $(DRV_INCLUDE);$(DRV_INC)
!endif

!ifeq 32BIT 1
CINC	= $(C32INC)
WASMINC= $(DRV_INC);$(%DDK)\BASE\inc
MASMINC= -i$(DRV_INC) -i$(%DDK)\BASEinc
AINC	= -Fdi:$(DRV_INC) -Fdi:$(%DDK)\BASE\inc
!endif

WMAPNAME= $(DRV_BIN)\$(TARGET).WAT
MAPNAME = $(DRV_BIN)\$(TARGET).MAP

.ERASE

.SUFFIXES:
.SUFFIXES: .sys .obj .asm .inc .def .lrf .lnk .ref .lst .sym .map .c .cpp .h .lib

.BEFORE
       @SET LIB=
       @SET INCLUDE=
	@SET DRV_MODEL=32
       @SET PATH=$(%WATCOM)\BINP;$(%WATCOM)\BINW
       @CALL $(BUILDLVL)

#########################################
# Options for Watcom C/CPP compiler
#########################################
COBJ=-fo$(DRV_OBJ)\$^&.obj

###### DEV16 ######
!ifeq DEVTYPE DEV16
CDEFINES=-DTARGET_OS216
!ifeq DEBUG 1
CFLAGS  =-ms -5 $(CNUMERRFLAG) -bt=os2 -hc -d2 -oi -s -j -wx -zl -zfp -zgp -zq -zu -zp1 -DDEBUG
CPPFLAGS=-ms -5 $(CNUMERRFLAG) -bt=os2 -hc -d2 -oi -s -j -wx -zl -zfp -zgp -zq -zu -zp1 -DDEBUG
!else
CFLAGS  =-ms -5 $(CNUMERRFLAG) -bt=os2         -oi -s -j -wx -zl -zfp -zgp -zq -zu -zp1 $(CDEFINES)
CPPFLAGS=-ms -5 $(CNUMERRFLAG) -bt=os2    -olinars -s -j -wx -zl -zfp -zgp -zq -zu -zp1 $(CDEFINES)
!endif
CC=wcc $(CFLAGS) $(CDEFINES) -i$(CINC)
CPP=wpp $(CFLAGS) $(CDEFINES) -i$(CINC)
!endif

###### 32BIT ######
!ifeq 32BIT 1
CDEFINES=-D__KERNEL__ -DMODULE -DCONFIG_KMOD -DCONFIG_PCI -DTARGET_OS2 -DBUILD_LEVEL=$(%BUILD_LEVEL) -DCONFIG_PCI_NAMES
!ifdef NOOS2LXAPI
!ifneq DEVTYPE LXAPILIB
CDEFINES += -DNOOS2LXAPI
!endif
!endif
!ifeq DEBUG 1
CFLAGS  = -dDEBUG -bt=os2v2 $(CNUMERRFLAG) -hc -d2 -5r -omlinear -s -w4 -ze -zdp -zl -zq -nt=CODE32 -zff -zgf -zp1
CPPFLAGS= -xd
!else
CFLAGS  = -bt=os2v2 $(CNUMERRFLAG) -5r -omlinear -s -w4 -ze -zdp -zl -zq -nt=CODE32 -zff -zgf -zp1
CPPFLAGS= -xd
!endif

!ifeq KEE 1
CFLAGS += -mf -DKEE
!else
CFLAGS += -mf -zu
!endif

CC =WCC386 $(CFLAGS) $(CDEFINES) -i$(CINC)
CPP=WPP386 $(CFLAGS) $(CPPFLAGS) $(CDEFINES) -i$(CINC)
!endif

#########################################
# Options for Watcom assembler
#########################################
!ifeq DEVTYPE DEV16
AFLAGS=-bt=os2 -d1 -zq -3p -o
AOPTS=-fo=$(DRV_OBJ)\$^&.obj
ASM=wasm $(AFLAGS) -i$(AINC) $(AOPTS)
!endif

!ifeq 32BIT 1
!ifeq DEBUG 1
AFLAGS=-Mb -Li -Sv:M510 -Ods
!else
AFLAGS=-Mb -Li -Sv:M510
!endif
!ifeq KEE 1
AFLAGS+= -D:KEE
!endif
AOPTS=-Fdo:$(DRV_OBJ) -Fdl:$(DRV_OBJ)
ASM=$(ALP) $(AFLAGS) $(AINC) $(AOPTS)
!endif

#########################################
# Options for Watcom linker
#########################################
!ifeq DEBUG 1
LFLAGS= d codeview
!else
LFLAGS=
!endif

LINK=wlink $(LFLAGS)

#########################################
# Options for Watcom library manager
#########################################
!ifeq DEBUG 1
BFLAGS= -c -b -q -n
!else
BFLAGS= -s -t -c -b -q -n
!endif
LIB=wlib $(BFLAGS)

#########################################
# Options for Import library manager
#########################################
IFLAGS=/nologo
IMPLIB=IMPLIB $(IFLAGS)

#########################################
# Options for Watcom disassembler
#########################################
WDIS=wdis -l -s -e -p


#########################################
# Rules
#########################################
.obj:	$(DRV_OBJ)

.lst:	$(DRV_OBJ)

.lnk:	$(DRV_OBJ)

.lrf:  $(DRV_OBJ)

.sys:	$(DRV_BIN)

.sym:  $(DRV_BIN)

.c:    $(DRV_SRC)

.cpp:  $(DRV_SRC)

!ifdef EVERYTHING_AS_CPP
.c.obj: $(COMMONDEP) .AUTODEPEND
       @echo ------------------- $^&.c
	$(CPP) $(COBJ) $^&.c
	@$(WDIS) $(DRV_OBJ)\$^&.obj
!else
.c.obj: $(COMMONDEP) .AUTODEPEND
       @echo ------------------- $^&.c
	$(CC) $(COBJ) $^&.c
	@$(WDIS) $(DRV_OBJ)\$^&.obj
!endif

.cpp.obj: $(COMMONDEP) .AUTODEPEND
       @echo ------------------- $^&.cpp
	$(CPP) $(COBJ) $^&.cpp
	@$(WDIS) $(DRV_OBJ)\$^&.obj

.asm.obj: $(COMMONDEP) .AUTODEPEND
       @echo ------------------- $^&.asm
	$(ASM) $^&.asm
	@$(WDIS) $(DRV_OBJ)\$^&.obj
