/* $Id: lxspinlock.c,v 1.2 2002/04/26 23:09:25 smilcke Exp $ */

/*
 * spinlock.c
 * Autor:               Stefan Milcke
 * Erstellt am:         08.11.2001
 * Letzte Aenderung am: 14.01.2002
 *
*/
#include <linux/types.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <asm/uaccess.h>
#include <asm/hardirq.h>


//----------------------------------- __lock -----------------------------------
unsigned long __lock(void);
#pragma aux __lock =		\
	"pushfd"		\
	"cli"			\
	"pop eax"		\
	modify exact [eax]	\
	value [eax];


//---------------------------------- __unlock ----------------------------------
void __unlock(unsigned long cpuflags);
#pragma aux __unlock =		\
	"push eax"		\
	"popfd"			\
	modify exact []		\
	parm [eax];



//------------------------------- spin_lock_init -------------------------------
void spin_lock_init(spinlock_t *lock)
{
  *lock = 0;
}

//--------------------------------- spin_lock ----------------------------------
void spin_lock(spinlock_t *lock)
{
  *lock = __lock();
}

//------------------------------- spin_lock_flag -------------------------------
void spin_lock_flag(spinlock_t *lock, unsigned long *flag)
{
  *lock = __lock();
}

//-------------------------------- spin_trylock --------------------------------
int spin_trylock(spinlock_t *lock)
{
  return 0;
}

//------------------------------ spin_unlock_wait ------------------------------
void spin_unlock_wait(spinlock_t *lock)
{

}

//-------------------------------- spin_unlock ---------------------------------
void spin_unlock(spinlock_t *lock)
{
  __unlock(*lock);
}


