/* $Id: lxmisc.c,v 1.2 2002/04/26 23:09:24 smilcke Exp $ */

/*
 * misc.c
 * Autor:               Stefan Milcke
 * Erstellt am:         08.11.2001
 * Letzte Aenderung am: 20.03.2002
 *
*/
#include "hwaccess.h"
#include <linux/init.h>
#include <linux/poll.h>
#include <asm/uaccess.h>
#include <asm/hardirq.h>
#include <linux/ioport.h>
#include <linux/utsname.h>
#include <linux/time.h>

struct new_utsname system_utsname = {0};
struct resource ioport_resource={"PCI IO",0x0000,IO_SPACE_LIMIT,IORESOURCE_IO};
struct resource iomem_resource= {"PCI mem",0x00000000,0xffffffff,IORESOURCE_MEM};
mem_map_t *mem_map = 0;

#ifdef TARGET_OS2
struct lxrm_resource;
#endif
//---------------------------------- set_bit -----------------------------------
void set_bit(int nr, volatile void * addr)
{
 volatile unsigned long *pAddr = (volatile unsigned long *)addr;

   *pAddr = (*pAddr) | (1 << nr);
}

//--------------------------------- clear_bit ----------------------------------
void clear_bit(int nr, volatile void * addr)
{
 volatile unsigned long *pAddr = (volatile unsigned long *)addr;

   *pAddr = (*pAddr) & ~(1 << nr);
}

//----------------------------------- printk -----------------------------------
int printk(const char * fmt, ...)
{
  return 0;
}

//--------------------------------- poll_wait ----------------------------------
void poll_wait(struct file * filp, wait_queue_head_t * wait_address, poll_table *p)
{

}


//------------------------------- __check_region -------------------------------
int __check_region(struct resource *a, unsigned long b, unsigned long c)
{
  return 0;
}

extern unsigned long OS2_request_region(struct lxrm_resource *rm_resource
                                        ,struct resource *a
                                        ,unsigned long start,unsigned long n);
extern unsigned long OS2_release_region(struct lxrm_resource *rm_resource
                                        ,struct resource *a
                                        ,unsigned long start,unsigned long n);
//------------------------------ __release_region ------------------------------
void __release_region(struct resource *a, unsigned long b, unsigned long c,struct lxrm_resource *rm_resource)
{
 OS2_release_region(rm_resource,a,b,c);
}

//------------------------------ __request_region ------------------------------
struct resource * __request_region(struct resource *a, unsigned long start, unsigned long n, const char *name,struct lxrm_resource *rm_resource)
{
 if(0==OS2_request_region(rm_resource,a,start,n))
  return a;
 return NULL;
}

//------------------------------ do_gettimeofday -------------------------------
void do_gettimeofday(struct timeval *tv)
{
 tv->tv_sec=0;    // seconds
 tv->tv_usec=0;   // microseconds
}

void iodelay32(unsigned long);
// Wrong parameter register [eax] ??? (SM)
//#pragma aux iodelay32 parm nomemory [eax] modify nomemory exact [eax ecx];
#pragma aux iodelay32 parm nomemory [ecx] modify nomemory exact [eax ecx];

//---------------------------------- __udelay ----------------------------------
void __udelay(unsigned long usecs)
{
  iodelay32(usecs*2);
}
