/* $Id: lxmemory.cpp,v 1.2 2002/04/26 23:09:24 smilcke Exp $ */

/*
 * memory.cpp
 * Autor:               Stefan Milcke
 * Erstellt am:         26.10.2001
 * Letzte Aenderung am: 25.04.2002
 *
*/
extern "C" {
#define INCL_NOPMAPI
#define INCL_DOSERRORS           // for ERROR_INVALID_FUNCTION
#include <os2.h>
}
#include <devhelp.h>
#include <ldefos2.h>
#include <string.h>
#ifdef KEE
#include <kee.h>
#endif

#include "lxmalloc.hpp"

#pragma off (unreferenced)

#define PAGE_SIZE 4096

extern "C" {

//-------------------------------- virt_to_phys --------------------------------
unsigned long virt_to_phys(void * address)
{
#ifdef KEE
 KEEVMPageList pagelist;
 ULONG         nrpages;

	if(KernLinToPageList(address, PAGE_SIZE, &pagelist, &nrpages)) {
		DebugInt3();
		return 0;
	}
	return pagelist.addr;
#else
 LINEAR addr = (LINEAR)address;
 PAGELIST pagelist;

	if(DevLinToPageList(addr, PAGE_SIZE, (PAGELIST near *)__StackToFlat((ULONG)&pagelist))) {
		DebugInt3();
		return 0;
	}
	return pagelist.physaddr;
#endif
}

//-------------------------------- phys_to_virt --------------------------------
void * phys_to_virt(unsigned long address)
{
	DebugInt3();
	return 0;
}

//------------------------------ __get_free_pages ------------------------------
void *__get_free_pages(int gfp_mask, unsigned long order)
{
 ULONG addr;

	order = (1 << order); //TODO: Is this correct???
#ifdef KEE
 SHORT sel;

    	if(KernVMAlloc(order*PAGE_SIZE, VMDHA_FIXED|VMDHA_CONTIG,
                       (PVOID*)&addr, (PVOID*)-1, &sel)) {
#else
    	if(DevVMAlloc(VMDHA_FIXED|VMDHA_CONTIG, order*PAGE_SIZE, (LINEAR)-1, __StackToFlat((ULONG)&addr))) {
#endif
		DebugInt3();
		return 0;
	}
////	dprintf(("__get_free_pages %d returned %x", order*PAGE_SIZE, addr));
	return (void *)addr;
}

//--------------------------------- free_pages ---------------------------------
int free_pages(unsigned long addr, unsigned long order)
{
#ifdef KEE
	KernVMFree((PVOID)addr);
#else
	DevVMFree((LINEAR)addr);
#endif
////	dprintf(("free_pages %x", addr));
	return 0;
}

//-------------------------------- alloc_pages ---------------------------------
struct page * alloc_pages(int gfp_mask, unsigned long order)
{
	DebugInt3();
	return 0;
}

//------------------------------ remap_page_range ------------------------------
int remap_page_range(unsigned long from, unsigned long to, unsigned long size, unsigned long prot)
{
	DebugInt3();
	return 0;
}

//-------------------------------- is_access_ok --------------------------------
int is_access_ok(int type, void *addr, unsigned long size)
{
	return 1;
}

//-------------------------------- __copy_user ---------------------------------
void __copy_user(void *to, const void *from, unsigned long n)
{
	if(to == NULL || from == NULL) {
		DebugInt3();
		return;
	}
        if(n == 0) return;
#ifdef KEE
	memcpy(to, from, n);
#else
	_fmemcpy(to, from, n);
#endif
}

//-------------------------------- copy_to_user --------------------------------
unsigned long copy_to_user(void *to, const void *from, unsigned long n)
{
	if(to == NULL || from == NULL) {
		DebugInt3();
		return 0;
	}
        if(n == 0) return 0;
#ifdef KEE
	memcpy(to, from, n);
#else
	_fmemcpy(to, from, n);
#endif
	return 0;
}

//---------------------------- __copy_user_zeroing -----------------------------
void __copy_user_zeroing(void *to, const void *from, unsigned long n)
{
	if(to == NULL || from == NULL) {
		DebugInt3();
		return;
	}
        if(n == 0) return;
	copy_to_user(to, from, n);
}

//------------------------------- copy_from_user -------------------------------
unsigned long copy_from_user(void *to, const void *from, unsigned long n)
{
	if(to == NULL || from == NULL) {
		DebugInt3();
		return 0;
	}
        if(n == 0) return 0;
#ifdef KEE
	memcpy(to, from, n);
#else
	_fmemcpy(to, from, n);
#endif
	return 0;
}

//---------------------------------- get_user ----------------------------------
int get_user(int size, void *dest, void *src)
{
	if(size == 0)	return 0;

	if(dest == NULL || src == NULL) {
		DebugInt3();
		return 0;
	}
#ifdef KEE
	memcpy(dest, src, size);
#else
	_fmemcpy(dest, src, size);
#endif
	return 0;
}

//---------------------------------- put_user ----------------------------------
int put_user(int x, void *ptr)
{
	if(ptr == NULL) {
		DebugInt3();
		return 0;
	}

	*(int *)ptr = x;
	return 0;
}

//--------------------------------- __put_user ---------------------------------
#if 0
int __put_user(int size, int x, void *ptr)
{
#ifdef KEE
	memcpy(ptr,
#else
	_fmemcpy(ptr,
#endif
	return 0;
}
#endif

//---------------------------------- kmalloc -----------------------------------
void *kmalloc(int size, int flags)
{
 return malloc(size);
}

//----------------------------------- kfree ------------------------------------
void kfree(const void *ptr)
{
 free((void *)(ULONG)ptr);
}

//---------------------------------- kfree_s -----------------------------------
void kfree_s(const void *ptr,int size)
{
 kfree(ptr);
}

//---------------------------------- vmalloc -----------------------------------
void *vmalloc(unsigned long size)
{
 return kmalloc(size,0);
}
}