/* $Id: lxioremap.cpp,v 1.2 2002/04/26 23:09:23 smilcke Exp $ */

/*
 * ioremap.c
 * Autor:               Stefan Milcke
 * Erstellt am:         08.11.2001
 * Letzte Aenderung am: 15.12.2001
 *
*/

#ifdef __cplusplus
extern "C" {
#endif
#define INCL_NOPMAPI
#define INCL_DOSERRORS
#include <os2.h>
}
#include <devhelp.h>
#include <ldefos2.h>
#ifdef KEE
#include <kee.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct mapped_mem
{
 SEL sel;
 unsigned long linaddr;
};

struct mapped_mem mmem[MAX_GDTSELECTORS]={0};

//---------------------------------- ioremap -----------------------------------
extern "C" unsigned short allocGDTSelector(void);
extern "C" int freeGDTSelector(unsigned short selector);

unsigned long ioremap(unsigned long addr,unsigned short usSize)
{
 unsigned long linaddr=0;
 SEL sel=0;
 sel=(SEL)allocGDTSelector();
 if(!DevPhysToGDTSelector((PHYSICAL)addr,(WORD16)usSize,sel))
 {
  if(DevVirtToLin(sel
                  ,0
#ifdef KEE
                  ,(unsigned char * __far *)&linaddr))
#else
                  ,(unsigned char __near **)&linaddr))
#endif
   linaddr=0;
 }
 if(!linaddr)
  freeGDTSelector(sel);
 else
 {
  int i;
  for(i=0;i<MAX_GDTSELECTORS;i++)
  {
   if(!(mmem[i].sel))
   {
    mmem[i].sel=sel;
    mmem[i].linaddr=linaddr;
    break;
   }
  }
 }
 return linaddr;
}

//---------------------------------- iounmap -----------------------------------
#pragma off(unreferenced)
void iounmap(void *addr)
#pragma on(unreferenced)
{
 int i;
 for(i=0;i<MAX_GDTSELECTORS;i++)
 {
  if(mmem[i].sel && mmem[i].linaddr==(unsigned long)addr)
  {
   freeGDTSelector(mmem[i].sel);
   mmem[i].sel=0;
   break;
  }
 }
}

#ifdef __cplusplus
}
#endif