/*
 * lxapioctl.h
 * Autor:               Stefan Milcke
 * Erstellt am:         27.12.2001
 * Letzte Aenderung am: 31.01.2002
 *
*/

#ifndef LXAPIOCTL_H_INCLUDED
#define LXAPIIOCTL_H_INCLUDED

#pragma pack(1)

// Note: LX IOCtl categories starts at 0xA0
// Own LX IOCtl functions should be between 0x00 and 0x9F
// All unsupported IOCtl categories above 0x9F should be routed to OS2_lxioctl()
#define LXIOCCAT_GLO       0xA0     // Category for global calls
#define LXIOCCAT_MOD       0xA1     // Category for module calls
#define LXIOCCAT_PCI       0xA2     // Category for pci calls
#define LXIOCCAT_I2C       0xA3     // Category for i2c calls

#define LXIOCCAT_V4L       0xB0     // Category for V4L (video for linux) calls

/******************************************************************************/
/* global ioctl functions                                                     */
/******************************************************************************/
#define LXIOCFN_GLO_GETDRIVERINFO                           0x01
typedef struct _LXIOCDP_GLO_GETDRIVERINFO
{
 ULONG ulVersionMajor;
 ULONG ulVersionMinor;
 ULONG ulBuildLevel;
 CHAR vendor[32];
 ULONG ulNumModules;
 ULONG ulV4LXNumDevices;
} LXIOCDP_GLO_GETDRIVERINFO,*PLXIOCDP_GLO_GETDRIVERINFO;


/******************************************************************************/
/* module ioctl functions                                                     */
/******************************************************************************/
#define LXIOCFN_MOD_ENUMMODULES                             0x01
typedef struct _LX_MODINFO
{
 CHAR name[32];
 INT active;
}LX_MODINFO,*PLX_MODINFO;
typedef struct _LXIOCDP_MOD_ENUMMODULES
{
 ULONG ulNumModules;
 LX_MODINFO *modules;
}LXIOCDP_MOD_ENUMMODULES,*PLXIOCDP_MOD_ENUMMODULES;

#define LXIOCFN_MOD_REQUEST_MODULE                          0x02
typedef struct _LXIOCPA_MOD_REQUEST_MODULE
{
 INT rc;
 CHAR name[32];
}LXIOCPA_MOD_REQUEST_MODULE,*PLXIOCPA_MOD_REQUEST_MODULE;

#define LXIOCFN_MOD_RELEASE_MODULE                          0x03
typedef struct _LXIOCPA_MOD_RELEASE_MODULE
{
 INT rc;
 CHAR name[32];
}LXIOCPA_MOD_RELEASE_MODULE,*PLXIOCPA_MOD_RELEASE_MODULE;

#define LXIOCFN_MOD_SETMODPARM                              0x04
typedef struct _LXIOCPA_MOD_SETPARM
{
 INT rc;
 CHAR moduleName[32];
 CHAR *parameter;
}LXIOCPA_MOD_SETPARM,*PLXIOCPA_MOD_SETPARM;

/******************************************************************************/
/* V4L ioctl functions                                                        */
/******************************************************************************/
#define LXIOCFN_V4L_ENUMDEVICES                             0x01
typedef struct _LX_V4L_DEVICEINFO
{
 CHAR name[32];
 CHAR devname[16];
 ULONG type;
 ULONG hardware;
}LX_V4L_DEVICEINFO,*PLX_V4L_DEVICEINFO;
typedef struct _LXIOCDP_V4L_ENUMDEVICES
{
 ULONG ulDevices;
 LX_V4L_DEVICEINFO *devInfos;
}LXIOCDP_V4L_ENUMDEVICES,*PLXIOCDP_V4L_ENUMDEVICES;

#define LXIOCFN_V4L_OPENDEVICE                              0x02
typedef struct _LXIOCPA_V4L_OPENDEVICE
{
 INT rc;
 INT handle;
 CHAR devname[32];
}LXIOCPA_V4L_OPENDEVICE,*PLXIOCPA_V4L_OPENDEVICE;

#define LXIOCFN_V4L_CLOSEDEVICE                             0x03
typedef struct _LXIOCPA_V4L_CLOSEDEVICE
{
 INT rc;
 INT handle;
}LXIOCPA_V4L_CLOSEDEVICE,*PLXIOCPA_V4L_CLOSEDEVICE;

#define LXIOCFN_V4L_IOCTL                                   0x04
typedef struct _LXIOCPA_V4L_IOCTL
{
 INT rc;
 INT handle;
 INT v4l_ioctlfn;
}LXIOCPA_V4L_IOCTL,*PLXIOCPA_V4L_IOCTL;
typedef struct _BTIOCDP_V4L_IOCTL
{
 VOID *userData;
}LXIOCDP_V4L_IOCTL,*PLXIOCDP_V4L_IOCTL;

#pragma pack()
#endif