/*
 * lxapilib.h
 * Autor:               Stefan Milcke
 * Erstellt am:         08.01.2002
 * Letzte Aenderung am: 31.01.2002
 *
*/

#ifndef LXAPILIB_H_INCLUDED
#define LXAPILIB_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include <linux/module.h>

// Returns 0, if successfull, any other value indicates a failure
int OS2_initlxapi(void);

#ifndef NOOS2LXAPI
extern unsigned long (*OS2_lxioctl)(void __far* requestPacketPtr);
extern int (*OS2_add_module)(struct os2lx_module *pModule);
extern int (*OS2_apply_mod_parm)(char *parm,struct os2lx_parm *parmList,int num);
extern int (*OS2_set_module_parm)(char *parm);
extern int (*OS2_get_num_modules)(void);
extern int (*OS2_get_total_num_modules)(void);
extern char *(*OS2_get_module_name)(int nr);
extern int (*OS2_enum_modules)(void *buffer,unsigned long buffer_len);

extern int (*OS2_v4lx_enum_devices)(void *buffer,unsigned long buffer_len);
extern unsigned long (*OS2_v4lx_get_num_devices)(void);
extern int (*OS2_v4lx_open_device)(char *devname);
extern int (*OS2_v4lx_close_device)(int handle);
extern void (*OS2_v4lx_close_all_opened_devices)(void);
extern struct video_device *(*OS2_v4lx_get_opened_device)(int handle);
extern int (*OS2_v4lx_ioctl)(int handle,int ioctlfn,void *userData);
#else
unsigned long OS2_lxioctl(void __far* requestPacketPtr);
int OS2_add_module(struct os2lx_module *pModule);
int OS2_apply_mod_parm(char *parm,struct os2lx_parm *parmList,int num);
int OS2_set_module_parm(char *parm);
int OS2_get_num_modules(void);
int OS2_get_total_num_modules(void);
char *OS2_get_module_name(int nr);
int OS2_enum_modules(void *buffer,unsigned long buffer_len);

int OS2_v4lx_enum_devices(void *buffer,unsigned long buffer_len);
unsigned long OS2_v4lx_get_num_devices(void);
int OS2_v4lx_open_device(char *devname);
int OS2_v4lx_close_device(int handle);
void OS2_v4lx_close_all_opened_devices(void);
struct video_device *OS2_v4lx_get_opened_device(int handle);
int OS2_v4lx_ioctl(int handle,int ioctlfn,void *userData);


//----------------------------- internal use only ------------------------------
int OS2_do_add_module(struct os2lx_module *pModule,int external);
void do_cleanup_all_requested_modules(int external);

#endif

#pragma pack(1)
struct os2_enum_module
{
 char name[32];
 int active;
};

struct os2_enum_video_device
{
 char name[32];
 char devname[16];
 unsigned long type;
 unsigned long hardware;
};
#pragma pack()

#ifdef __cplusplus
};
#endif


#endif //LXAPILIB_H_INCLUDED
