/*
 * lxapiidc.h
 * Autor:               Stefan Milcke
 * Erstellt am:         27.12.2001
 * Letzte Aenderung am: 14.04.2002
 *
*/

#ifndef LXAPIIDC_H_INCLUDED
#define LXAPIIDC_H_INCLUDED

/* defines for OS/2 include */

/* Standard headers */

/* Application headers */

/* OS/2 Headers */
#include <lxrmcall.h>

#define LXAPI_VERSION                           1

//-------------------------------- OS2 specific --------------------------------
#define LXIDCCMD_GETOS2API                      1
#pragma pack(1)
typedef struct _LXIDC_GETOS2API
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 unsigned long (*OS2_lxioctl)(void __far* requestPacketPtr);
 int (*OS2_add_module)(struct os2lx_module *pModule);
 int (*OS2_apply_mod_parm)(char *parm,struct os2lx_parm *parmList,int num);
 int (*OS2_set_module_parm)(char *parm);
 int (*OS2_get_num_modules)(void);
 int (*OS2_get_total_num_modules)(void);
 char *(*OS2_get_module_name)(int nr);
 int (*OS2_enum_modules)(void *buffer,unsigned long buffer_len);
}LXIDC_GETOS2API,*PLXIDC_GETOS2API;

//------------------------------ resource manager ------------------------------
#define LXIDCCMD_GETRMAPI                       2
typedef struct _LXIDC_GETRMAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 unsigned long __cdecl (*RM32CreateDriver)(DRIVERSTRUCT*,HDRIVER*);
 unsigned long __cdecl (*RM32DestroyDriver)(HDRIVER);
 unsigned long __cdecl (*RM32CreateAdapter)(HDRIVER,HADAPTER*,ADAPTERSTRUCT*,HDEVICE,AHRESOURCE*);
 unsigned long __cdecl (*RM32DestroyAdapter)(HDRIVER,HADAPTER);
 unsigned long __cdecl (*RM32CreateDevice)(HDRIVER,HDEVICE*,DEVICESTRUCT*,HADAPTER,AHRESOURCE*);
 unsigned long __cdecl (*RM32DestroyDevice)(HDRIVER,HDEVICE);
 unsigned long __cdecl (*RM32AllocResource)(HDRIVER,HRESOURCE*,RESOURCESTRUCT*);
 unsigned long __cdecl (*RM32DeallocResource)(HDRIVER,HRESOURCE);
 unsigned long __cdecl (*RM32ModifyResources)(HDRIVER,HADAPTER,USHORT,HRESOURCE);
}LXIDC_GETRMAPI,*PLXIDC_GETRMAPI;

//--------------------------- video for linux (V4L) ----------------------------
#define LXIDCCMD_GETV4LAPI                      3
typedef struct _LXIDC_GETV4LAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 int (*OS2_v4lx_enum_devices)(void *buffer,unsigned long buffer_len);
 unsigned long (*OS2_v4lx_get_num_devices)(void);
 int (*OS2_v4lx_open_device)(char *devname);
 int (*OS2_v4lx_close_device)(int handle);
 void (*OS2_v4lx_close_all_opened_devices)(void);
 struct video_device *(*OS2_v4lx_get_opened_device)(int handle);
 int (*OS2_v4lx_ioctl)(int handle,int ioctlfn,void *userData);
}LXIDC_GETV4LAPI,*PLXIDC_GETV4LAPI;

//----------------------------- memory management ------------------------------
#define LXIDCCMD_GETMEMAPI                      101
typedef struct _LXIDC_GETMEMAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 void *(*malloc)(unsigned long size);
 void (*free)(void *ptr);
 void *(*kmalloc)(int size,int flags);
 void (*kfree)(const void *ptr);
 void *(*vmalloc)(unsigned long size);
 void *(*__vmalloc)(unsigned long size,int gfp_mask,pgprot_t prot);
 void (*vfree)(void *ptr);
 void (*kfree_s)(const void *ptr,int size);
 unsigned long (*virt_to_phys)(void *address);
 void *(*phys_to_virt)(unsigned long adress);
 int (*free_pages)(unsigned long addr,unsigned long order);
 struct page *(*alloc_pages)(int gfp_mask,unsigned long order);
 int (*remap_page_range)(unsigned long from,unsigned long to,unsigned long size,pgprot_t prot);
 int (*is_access_ok)(int type,void *addr,unsigned long size);
 void (*__copy_user)(void *to,const void *from,unsigned long n);
 unsigned long (*copy_to_user)(void *to,const void *from,unsigned long n);
 void (*__copy_user_zeroing)(void *to,const void *from,unsigned long n);
 unsigned long (*copy_from_user)(void *to,const void *from,unsigned long n);
 int (*get_user)(int size,void *dest,void *src);
 int (*put_user)(int x,void *ptr);
 unsigned long (*ioremap)(unsigned long addr,unsigned short usSize);
 void (*iounmap)(void *addr);
}LXIDC_GETMEMAPI,*PLXIDC_GETMEMAPI;


//---------------------------- semaphore management ----------------------------
#define LXIDCCMD_GETSEMAPI                      102
typedef struct _LXIDC_GETSEMAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 void (*init_MUTEX)(struct semaphore *sem);
 void (*init_MUTEX_LOCKED)(struct semaphore *sem);
 void (*down)(struct semaphore *sem);
 void (*up)(struct semaphore *sem);
}LXIDC_GETSEMAPI,*PLXIDC_GETSEMAPI;

//---------------------------- spinlock management -----------------------------
#define LXIDCCMD_GETSLCAPI                      103
typedef struct _LXIDC_GETSLCAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 void (*spin_lock_init)(spinlock_t *lock);
 void (*spin_lock)(spinlock_t *lock);
 void (*spin_lock_flag)(spinlock_t *lock,unsigned long *flag);
 int (*spin_trylock)(spinlock_t *lock);
 void (*spin_unlock_wait)(spinlock_t *lock);
 void (*spin_unlock)(spinlock_t *lock);
}LXIDC_GETSLCAPI,*PLXIDC_GETSLCAPI;

//----------------------------- module management ------------------------------
#define LXIDCCMD_GETMODAPI                      104
typedef struct _LXIDC_GETMODAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 int (*request_module)(const char *name);
 int (*release_module)(const char *name);
}LXIDC_GETMODAPI,*PLXIDC_GETMODAPI;

//---------------------------- schedule management -----------------------------
#define LXIDCCMD_GETSCHAPI                      105
typedef struct _LXIDC_GETSCHAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 unsigned long volatile *__jiffies;
 struct task_struct **__current;
 void (*add_wait_queue)(wait_queue_head_t *q,wait_queue_t *wait);
 void (*add_wait_queue_exclusive)(wait_queue_head_t *q);
 void (*remove_wait_queue)(wait_queue_head_t *q,wait_queue_t *wait);
 void (*__wake_up)(wait_queue_head_t *q,unsigned int mode);
 void (*sleep_on)(wait_queue_head_t *q);
 long (*sleep_on_timeout)(wait_queue_head_t *q,signed long timeout);
 void (*interruptible_sleep_on)(wait_queue_head_t *q);
 long (*interruptible_sleep_on_timeout)(wait_queue_head_t *q,signed long timeout);
 void (*wake_up_process)(struct task_struct *tsk);
 signed long (*schedule_timeout)(signed long timeout);
 void (*schedule)(void);
 int (*kernel_thread)(int (*initFn)(void*),int (*fn)(void *),int (*exitFn)(void *),void *arg,unsigned long flags);
 void (*tasklet_hi_schedule)(struct tq_struct *t);
}LXIDC_GETSCHAPI,*PLXIDC_GETSCHAPI;

//------------------------------ timer management ------------------------------
#define LXIDCCMD_GETTIMAPI                      106
typedef struct _LXIDC_GETTIMAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 void (*add_timer)(struct timer_list * timer);
 int (*mod_timer)(struct timer_list *timer,unsigned long expires);
 int (*del_timer)(struct timer_list *timer);
}LXIDC_GETTIMAPI,*PLXIDC_GETTIMAPI;

//---------------------------- resource management -----------------------------
#define LXIDCCMD_GETRESAPI                      107
typedef struct _LXIDC_GETRESAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 struct resource *__ioport_resource;
 struct resource *__iomem_resource;
 int (*request_resource)(struct resource *root,struct resource *newr);
 int (*release_resource)(struct resource *old);
 int (*allocate_resource)(struct resource *root,struct resource *newr,unsigned long size,unsigned long min,unsigned long max,unsigned long align,void (*alignf)(void *,struct resource*,unsigned long),void *alignf_data);
 int (*request_irq)(unsigned int irq,void(*handler)(int,void*,struct pt_regs*regs),unsigned long flags,const char *name,void *data,struct lxrm_resource* rm_resource);
 void (*free_irq)(unsigned int irq,void *data,struct lxrm_resource* rm_resource);
 void (*eoi_irq)(unsigned int irq);
 int (*__check_region)(struct resource *a,unsigned long b,unsigned long c);
 struct resource* (*__request_region)(struct resource *a,unsigned long start,unsigned long n,const char *name,struct lxrm_resource *rm_resource);
 void (*__release_region)(struct resource *a,unsigned long b,unsigned long c,struct lxrm_resource *rm_resource);
}LXIDC_GETRESAPI,*PLXIDC_GETRESAPI;

//------------------------------- pci management -------------------------------
#define LXIDCCMD_GETPCIAPI                      200
typedef struct _LXIDC_GETPCIAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 int *__pci_pci_problems;
 void (*pcibios_init)(void);
 void (*pcibios_fixup_bus)(struct pci_bus *bus);
 int (*pcibios_enable_device)(struct pci_dev *dev);
 void (*pcibios_align_resource)(void *,struct resource *,unsigned long);

 struct pci_dev *(*pci_find_device)(unsigned int vendor,unsigned int device,const struct pci_dev *from);
 struct pci_dev *(*pci_find_subsys)(unsigned int vendor,unsigned int device,unsigned int ss_vendor,unsigned int ss_device,const struct pci_dev *from);
 struct pci_dev *(*pci_find_class)(unsigned int pciclass,const struct pci_dev *from);
 struct pci_dev *(*pci_find_slot)(unsigned int bus,unsigned int devfn);
 int (*pci_find_capability)(struct pci_dev *dev,int cap);

 int (*pci_read_config_byte)(struct pci_dev *dev, int where, u8 *val);
 int (*pci_read_config_word)(struct pci_dev *dev, int where, u16 *val);
 int (*pci_read_config_dword)(struct pci_dev *dev, int where, u32 *val);
 int (*pci_write_config_byte)(struct pci_dev *dev, int where, u8 val);
 int (*pci_write_config_word)(struct pci_dev *dev, int where, u16 val);
 int (*pci_write_config_dword)(struct pci_dev *dev, int where, u32 val);

 int (*pci_enable_device)(struct pci_dev *dev);
 void (*pci_disable_device)(struct pci_dev *dev);
 void (*pci_set_master)(struct pci_dev *dev);
 int (*pci_assign_resource)(struct pci_dev *dev, int i);

 int (*pci_register_driver)(struct pci_driver *);
 void (*pci_unregister_driver)(struct pci_driver *);
 void (*pci_insert_device)(struct pci_dev *, struct pci_bus *);
 void (*pci_remove_device)(struct pci_dev *);
 struct pci_driver *(*pci_dev_driver)(const struct pci_dev *);
 const struct pci_device_id *(*pci_match_device)(const struct pci_device_id *ids, const struct pci_dev *dev);
}LXIDC_GETPCIAPI,*PLXIDC_GETPCIAPI;

//------------------------------- i2c management -------------------------------
#define LXIDCCMD_GETI2CAPI                      201
typedef struct _LXIDC_GETI2CAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 int (*i2c_probe)(struct i2c_adapter *adapter,struct i2c_client_address_data *adress_data,i2c_client_found_addr_proc *found_proc);
 int (*i2c_add_driver)(struct i2c_driver *);
 int (*i2c_del_driver)(struct i2c_driver *);
 int (*i2c_attach_client)(struct i2c_client *);
 int (*i2c_detach_client)(struct i2c_client *);
 int (*i2c_master_send)(struct i2c_client *,const char *,int);
 int (*i2c_master_recv)(struct i2c_client *,char *,int);
 int (*i2c_transfer)(struct i2c_adapter *adap,struct i2c_msg *msg,int num);

 int (*i2c_bit_add_bus)(struct i2c_adapter *);
 int (*i2c_bit_del_bus)(struct i2c_adapter *);
}LXIDC_GETI2CAPI,*PLXIDC_GETI2CAPI;

//---------------------------------- videodev ----------------------------------
#define LXIDCCMD_GETVIDAPI                      300
typedef struct _LXIDC_GETVIDAPI
{
 unsigned long required_version;       // IN: Required version
 unsigned long actual_version;         // OUT: Actual version
 int (*video_register_device)(struct video_device *,int type,int nr);
 void (*video_unregister_device)(struct video_device *);
}LXIDC_GETVIDAPI,*PLXIDC_GETVIDAPI;
#pragma pack()

#endif //LXAPIIDC_H_INCLUDED
