/*
 * ldefos2.h
 * Autor:               Stefan Milcke
 * Erstellt am:         05.11.2001
 * Letzte Aenderung am: 15.12.2001
 *
*/
#ifndef __LDEFOS2_H__
#define __LDEFOS2_H__

#define MAX_GDTSELECTORS   10 // Must match MAX_GDTSELECTORS in startup.asm

#define FAR48 __far
#ifndef FAR
#define FAR   __far
#endif

#ifndef TARGET_OS216

#ifdef DEBUG
#ifdef __cplusplus
extern "C" {
#endif
void _cdecl DPE(char *x, ...) ; /* not debugging: nothing */
void _cdecl DPD(int level, char *x, ...) ; /* not debugging: nothing */
#ifdef __cplusplus
}
#endif
#define dprintf(a)	DPE a
#define DebugInt3()	_asm int 3;
#else
#define dprintf(a)
#define DebugInt3()
#endif

#ifdef USEPRINTK
#define PRINTTK(x) (printk(x))
#else
#define PRINTTK(x) (printk(x))
#endif

#ifdef LINUX
#define NEAR __near

typedef unsigned long ULONG;
typedef unsigned long *PULONG;
typedef unsigned short USHORT;
typedef unsigned short *PUSHORT;
typedef signed long LONG;
typedef signed short SHORT;
typedef signed short *PSHORT;
typedef unsigned long BOOL;
typedef ULONG FARPTR16;
typedef char NEAR *LINEAR;
typedef unsigned long APIRET;
typedef void VOID;
typedef void *PVOID;
typedef signed int INT;
typedef unsigned char UCHAR;
typedef signed char CHAR;
typedef CHAR *PCHAR;
typedef __int64 QWORD;
typedef ULONG HFILE;

#define APIENTRY    _System

#endif

#define __cpu_to_le32(x) ((__u32)(x))
#define cpu_to_le32 __cpu_to_le32

#ifdef __cplusplus
extern "C" {
#endif
#ifndef WORD32
typedef unsigned long WORD32;
#endif
extern WORD32 GDTSelectors32;
#ifdef __cplusplus
}
#endif

#endif //TARGET_OS216

#endif
