/* $Id: vmalloc.h,v 1.2 2002/04/26 23:09:17 smilcke Exp $ */

#ifndef __LINUX_VMALLOC_H
#define __LINUX_VMALLOC_H

//#include <linux/sched.h>
#include <linux/mm.h>

#include <asm/pgtable.h>
#include <asm/page.h>

struct vm_struct {
	unsigned long flags;
	void * addr;
	unsigned long size;
	struct vm_struct * next;
};


#if (defined(TARGET_OS2) && !defined(NOOS2LXAPI))
extern void *(*__vmalloc)(unsigned long size,int gfp_mask,pgprot_t prot);
extern void *(*vmalloc)(unsigned long size);
extern void (*vfree)(void *ptr);
#else
struct vm_struct * get_vm_area(unsigned long size);
void vfree(void * addr);
void * vmalloc(unsigned long size);
void * __vmalloc(unsigned long size,int gfp_mask,pgprot_t prot);
long vread(char *buf, char *addr, unsigned long count);
void vmfree_area_pages(unsigned long address, unsigned long size);
int vmalloc_area_pages(unsigned long address, unsigned long size);
#endif

#define vmalloc_32(size) (__vmalloc((size),(GFP_KERNEL),(0)))

extern struct vm_struct * vmlist;
#endif

