/* $Id: sched.h,v 1.2 2002/04/26 23:09:15 smilcke Exp $ */

#ifndef _LINUX_SCHED_H
#define _LINUX_SCHED_H

#include <asm/param.h>	/* for HZ */

#define TASK_RUNNING		0
#define TASK_INTERRUPTIBLE	1
#define TASK_UNINTERRUPTIBLE	2
#define TASK_ZOMBIE		4
#define TASK_STOPPED		8
#define TASK_SWAPPING		16
#define TASK_EXCLUSIVE		32

struct task_struct {
/* these are hardcoded - don't touch */
	volatile long state;	/* -1 unrunnable, 0 runnable, >0 stopped */
	unsigned long flags;	/* per process flags, defined below */
	int sigpending;
/* open file information */
	struct files_struct *files;
        volatile long need_resched;
};

#ifdef TARGET_OS2
struct lxrm_resource;
#endif
#include <asm\current.h>
#include <linux\wait.h>

#if (defined(TARGET_OS2) && !defined(NOOS2LXAPI))
extern void (*add_wait_queue)(wait_queue_head_t *q, wait_queue_t * wait);
extern void (*add_wait_queue_exclusive)(wait_queue_head_t *q);
extern void (*remove_wait_queue)(wait_queue_head_t *q, wait_queue_t * wait);

extern void (*__wake_up)(wait_queue_head_t *q, unsigned int mode);
extern void (*sleep_on)(wait_queue_head_t *q);
extern long (*sleep_on_timeout)(wait_queue_head_t *q,signed long timeout);
extern void (*interruptible_sleep_on)(wait_queue_head_t *q);
extern long (*interruptible_sleep_on_timeout)(wait_queue_head_t *q,signed long timeout);
extern void (*wake_up_process)(struct task_struct * tsk);
#else
void add_wait_queue(wait_queue_head_t *q, wait_queue_t * wait);
void add_wait_queue_exclusive(wait_queue_head_t *q);
void remove_wait_queue(wait_queue_head_t *q, wait_queue_t * wait);

extern void __wake_up(wait_queue_head_t *q, unsigned int mode);
extern void sleep_on(wait_queue_head_t *q);
extern long sleep_on_timeout(wait_queue_head_t *q,signed long timeout);
extern void interruptible_sleep_on(wait_queue_head_t *q);
extern long interruptible_sleep_on_timeout(wait_queue_head_t *q,signed long timeout);
extern void wake_up_process(struct task_struct * tsk);
#endif

#define wake_up(x)			__wake_up((x),TASK_UNINTERRUPTIBLE | TASK_INTERRUPTIBLE)
#define wake_up_interruptible(x)	__wake_up((x),TASK_INTERRUPTIBLE)

#if (defined(TARGET_OS2) && !defined(NOOS2LXAPI))
extern signed long (*schedule_timeout)(signed long timeout);
extern void (*schedule)(void);
#else
signed long schedule_timeout(signed long timeout);
void schedule(void);
#endif

#if (defined(TARGET_OS2) && !defined(NOOS2LXAPI))
extern int (*request_irq)(unsigned int,
		       void (*handler)(int, void *, struct pt_regs *),
		       unsigned long, const char *, void *
             ,struct lxrm_resource* rm_resource);
extern void (*free_irq)(unsigned int, void *
                        ,struct lxrm_resource* rm_resource);
extern void (*eoi_irq)(unsigned int);
#else
extern int request_irq(unsigned int,
		       void (*handler)(int, void *, struct pt_regs *),
		       unsigned long, const char *, void *
             ,struct lxrm_resource* rm_resource);
extern void free_irq(unsigned int, void *
                     ,struct lxrm_resource* rm_resource);
extern void eoi_irq(unsigned int);
#endif

#if (defined(TARGET_OS2) && !defined(NOOS2LXAPI))
extern unsigned long volatile *__jiffies;
#define jiffies (*__jiffies)
#else
extern unsigned long volatile jiffies;
#endif

#define set_current_state(state_value)		\
	set_mb(current->state, (state_value))

#endif
