/* $Id: process.h,v 1.2 2002/04/26 23:09:14 smilcke Exp $ */

/*
 * process.h
 * Autor:               Stefan Milcke
 * Erstellt am:         20.11.2001
 * Letzte Aenderung am: 11.01.2002
 *
*/

#ifndef PROCESS_H_INCLUDED
#define PROCESS_H_INCLUDED

// Because i don't know how to implement kernel threads in OS2 device driver
// we emulate this via timer calls.
// So this function differs from original kernel_thread in linux
// initFn is called first (one time) and then fn is called periodically until
// it returns nonzero. Then exitFn is called and the thread is removed from
// the list
#if (defined(TARGET_OS2) && !defined(NOOS2LXAPI))
extern int (*kernel_thread)(int (*initFn)(void*)
                          ,int (*fn)(void *)
                          ,int (*exitFn)(void *)
                          ,void *arg,unsigned long flags);
#else
extern int kernel_thread(int (*initFn)(void*)
                         ,int (*fn)(void *)
                         ,int (*exitFn)(void *)
                         ,void *arg,unsigned long flags);
#endif
#endif //PROCESS_H_INCLUDED
