/* $Id: i2c-algo-bit.h,v 1.2 2002/04/26 23:09:05 smilcke Exp $ */

/*
 * i2c-algo-bit.h
 * Autor:               Stefan Milcke
 * Erstellt am:         12.10.2001
 * Letzte Aenderung am: 12.01.2002
 *
*/

#ifndef I2CALGOB_H_INCLUDED
#define I2CALGOB_H_INCLUDED

#include "i2c.h"

#ifdef __cplusplus
extern "C" {
#endif

/* --- Defines for bit-adapters ---------------------------------------	*/
/*
 * This struct contains the hw-dependent functions of bit-style adapters to
 * manipulate the line states, and to init any hw-specific features. This is
 * only used if you have more than one hw-type of adapter running.
 */
struct i2c_algo_bit_data {
	void *data;		/* private data for lowlevel routines */
	void (*setsda) (void *data, int state);
	void (*setscl) (void *data, int state);
	int  (*getsda) (void *data);
	int  (*getscl) (void *data);

	/* local settings */
	int udelay;
	int mdelay;
	int timeout;
};

#define I2C_BIT_ADAP_MAX	16

#if (defined(TARGET_OS2) && !defined(NOOS2LXAPI))
extern int (*i2c_bit_add_bus)(struct i2c_adapter *);
extern int (*i2c_bit_del_bus)(struct i2c_adapter *);
#else
int i2c_bit_add_bus(struct i2c_adapter *);
int i2c_bit_del_bus(struct i2c_adapter *);
#endif

#ifdef __cplusplus
}
#endif

#endif //I2CALGOB_H_INCLUDED
