/* $Id: lxstrategy.c,v 1.2 2002/04/26 23:08:57 smilcke Exp $ */

/*
 * strategy.c
 * Autor:               Stefan Milcke
 * Erstellt am:         07.09.2001
 * Letzte Aenderung am: 27.04.2002
 *
*/

extern "C"
{
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
}

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include "lxdevown.h"

extern "C" WORD32 StratIOCtl(RP __far *_rp);
WORD32 StratClose(RP __far *_rp);
WORD32 StratRemove(RP __far *_rp);

// SvL: Needed in StratOpen
WORD32 deviceOwner = DEV_NO_OWNER; //UltiMOD, PCM, MIDI etc.
WORD32 numOS2Opens = 0;
// SvL: End

extern "C" void OS2_V4lx_close_all_opened_devices(void);
extern "C" unsigned long OS2_get_current_pid(void);
//--------------------------------- StratOpen ----------------------------------
WORD32 StratOpen(RP __far*)
{
 if(numOS2Opens == 0)
 {
  OS2_V4lx_close_all_opened_devices();
  deviceOwner = DEV_PDD_OWNER;
 }
 numOS2Opens++;
 return RPDONE;
}

//--------------------------------- StratWrite ---------------------------------
#pragma off (unreferenced)
static WORD32 StratWrite(RP __far* _rp)
#pragma on (unreferenced)
{
  return RPDONE | RPERR;
}

extern WORD32 DiscardableInit(RPInit __far*);

//--------------------------------- StratInit ----------------------------------
WORD32 StratInit(RP __far* _rp)
{
  RPInit __far* rp = (RPInit __far*)_rp;
  return DiscardableInit(rp);
}


//----------------------------- StratInitComplete ------------------------------
#pragma off (unreferenced)
WORD32 StratInitComplete(RP __far* _rp)
#pragma on (unreferenced)
{
  return(RPDONE);
}

//--------------------------------- StratError ---------------------------------
static WORD32 StratError(RP __far*)
{
  return RPERR_COMMAND | RPDONE;
}

extern "C" void do_cleanup_all_requested_modules(int external);
extern "C" bttv_cleanup_module(void);
extern "C" videodev_exit();

//------------------------------- StratDeinstall -------------------------------
#pragma off (unreferenced)
static WORD32 StratDeinstall(RP __far* rp)
#pragma on (unreferenced)
{
 do_cleanup_all_requested_modules(1);
 do_cleanup_all_requested_modules(0);
 return RPDONE;
}

//------------------------------- StratShutdown --------------------------------
static WORD32 StratShutdown(RP __far* _rp)
{
 RPShutdown __far *rp=(RPShutdown __far *)_rp;
 if(rp->Function==0)
  do_cleanup_all_requested_modules(1);    // Unload external modules
 else
  do_cleanup_all_requested_modules(0);    // Unload internal modules
 return RPDONE;
}

// Strategy dispatch table
//
// This table is used by the strategy routine to dispatch strategy requests

typedef WORD32 (*RPHandler)(RP __far* rp);
RPHandler StratDispatch[] =
{
  StratInit,                  // 00 (BC): Initialization
  StratError,                 // 01 (B ): Media check
  StratError,                 // 02 (B ): Build BIOS parameter block
  StratError,                 // 03 (  ): Unused
  StratError,                 // 04 (BC): Read
  StratError,                 // 05 ( C): Nondestructive read with no wait
  StratError,                 // 06 ( C): Input status
  StratError,                 // 07 ( C): Input flush
  StratWrite,                 // 08 (BC): Write
  StratError,                 // 09 (BC): Write verify
  StratError,                 // 0A ( C): Output status
  StratError,                 // 0B ( C): Output flush
  StratError,                 // 0C (  ): Unused
  StratOpen,                  // 0D (BC): Open
  StratClose,                 // 0E (BC): Close
  StratError,                 // 0F (B ): Removable media check
  StratIOCtl,                 // 10 (BC): IO Control
  StratError,                 // 11 (B ): Reset media
  StratError,                 // 12 (B ): Get logical unit
  StratError,                 // 13 (B ): Set logical unit
  StratDeinstall,             // 14 ( C): Deinstall character device driver
  StratError,                 // 15 (  ): Unused
  StratError,                 // 16 (B ): Count partitionable fixed disks
  StratError,                 // 17 (B ): Get logical unit mapping of fixed disk
  StratError,                 // 18 (  ): Unused
  StratError,                 // 19 (  ): Unused
  StratError,                 // 1A (  ): Unused
  StratError,                 // 1B (  ): Unused
  StratShutdown,              // 1C (BC): Notify start or end of system shutdown
  StratError,                 // 1D (B ): Get driver capabilities
  StratError,                 // 1E (  ): Unused
  StratInitComplete           // 1F (BC): Notify end of initialization
};

//---------------------------------- Strategy ----------------------------------
WORD32 __far Strategy(RP __far* rp);
#pragma aux (STRATEGY) Strategy "STRATEGY_ENTRY";
WORD32 __far Strategy(RP __far* rp)
{
  if (rp->Command < sizeof(StratDispatch)/sizeof(StratDispatch[0]))
       	return(StratDispatch[rp->Command](rp));
  else	return(RPERR_COMMAND | RPDONE);
}



