; $Id: lxstartup.asm,v 1.2 2002/04/26 23:08:57 smilcke Exp $

;
; lxstatup.asm
; Autor:               Stefan Milcke
; Erstellt am:         08.12.2001
; Letzte Aenderung am: 28.04.2002
;
       .386p


       INCL_DOS        equ 1
       INCL_DOSERRORS  equ 1
       include os2.inc
       include seg32.inc
	include r0thunk.inc
       include rp.inc
       include rm.inc
       include devhlp.inc

;        EXTERNDEF DOS32FLATDS:ABS

MAX_GDTSELECTORS       EQU     10
MAX_MESSAGESIZE        EQU     2048

; Status word masks
STERR	EQU	8000H		; Bit 15 - Error
STINTER EQU	0400H		; Bit 10 - Interim character
STBUI	EQU	0200H		; Bit  9 - Busy
STDON	EQU	0100H		; Bit  8 - Done
STECODE EQU	00FFH		; Error code

DATA16 segment
               extrn  DOS32FLATDS : abs                ; ring 0 FLAT kernel data selector
               extrn __OffFinalDS16 : byte
               extrn  LInfoSeg : dword
		public _MSG_TABLE16
		public DevHelpInit
               public DeviceHelp
		public fOpen	
		public InitPktSeg
		public InitPktOff
		public _MESSAGE_STR
		public FileName
               public GDTSelectors
               public ddTable
               public irq_level_ptr

DeviceHelp     label byte
DevHelpInit	dd 0
GDTSelectors   dw[MAX_GDTSELECTORS] dup (0)
ddTable        dw[6] dup (0)
irq_level_ptr  dd 0
fOpen		dd 0
InitPktSeg	dw 0
InitPktOff	dw 0

_MESSAGE_STR   db MAX_MESSAGESIZE dup (0)
_MSG_TABLE16   dw 0	;message length
               dw OFFSET _MESSAGE_STR
		dw SEG    _MESSAGE_STR
FileName 	db "LXAPIH$", 0
hFile          dw 0
PCIIDName      db "PCI.IDS",0
PCIIDFILE      db 256 dup (0)
hPCIID         dw 0
ulFileAction   dw 0
               dw 0

DATA16 ends

CODE16 segment
       assume cs:CODE16, ds:DATA16
       public help_stub_strategy
       public device_stub_strategy
	public device_stub_idc
	public thunk3216_devhelp
	public thunk3216_devhelp_modified_ds
       extrn DOSOPEN       : far
       extrn DOSWRITE      : far
       extrn DOSCLOSE      : far
       extrn __OffFinalCS16 : byte

;DEZE MOET ALS EERSTE blijven staan!!!!
help_stub_strategy proc far
	pushad
	push	ds
	push	es
	push	fs
	push	gs

	mov	ax, DATA16
	mov	ds, ax

       movzx 	eax, byte ptr es:[bx].reqCommand
	cmp	eax, 0				; Init
	je	short @@help_init
       cmp 	eax, 0Dh			; DosOpen
       jne 	short @@help_error
;DosOpen
       cmp     word ptr ds:(offset fOpen),0
	je	short @@help_ret_ok		; not ours
	push	ebx				; later weer nodig
	push	es

       mov     word ptr ds:(offset fOpen),0
       mov     ax, word ptr InitPktSeg
	mov	fs, ax				; fs:ebx = req. packet
	xor	ebx, ebx
       mov     bx, word ptr ds:(offset InitPktOff)
	call	far ptr FLAT:STRATEGY_

	pop	es
	pop	ebx				; oude bx ptr
@@help_ret:
       mov 	word ptr es:[bx].reqStatus, ax
@@help_ret_error:
	pop	gs
	pop	fs
	pop	es
	pop	ds
	popad
	ret
		
@@help_init:
	mov	eax, dword ptr es:[bx].i_devHelp
       mov     dword ptr ds:(offset DevHelpInit ), eax
       mov     word ptr es:[bx].o_codeend,(offset __OffFinalCS16)
       mov     word ptr es:[bx].o_dataend,(offset __OffFinalDS16)
       call    init_data
       jc      short @@help_error
@@help_ret_ok:
	mov	ax, STDON
	jmp	short @@help_ret

@@help_error:
	mov	ax, STDON + STERR + ERROR_I24_BAD_COMMAND
       mov 	word ptr es:[bx].reqStatus, ax
	jmp	short @@help_ret_error
help_stub_strategy endp

init_data proc near
       ; TODO: Check for errors after DevHelp
       ; Do some additional inits
       pushad
       push    ds
       push    es
       push    fs
       push    gs

       push    ds
       pop     es

       ; Get irq_level_ptr from DOS var
       mov     eax,13
       mov     dl,DevHlp_GetDOSVar
       call    dword ptr ds:(offset DevHelpInit)
       movzx   esi,bx
       mov     dl,DevHlp_VirtToLin
       call    dword ptr ds:(offset DevHelpInit)
       add     eax,4
       mov     dword ptr ds:(offset irq_level_ptr),eax

       ; Get LDT InfoSeg
       mov     al,2
       mov     dl,DevHlp_GetDOSVar
       call    dword ptr ds:(offset DevHelpInit)
       jc      @F
       push    es
       mov     es,ax
       mov     ax,es:[bx]
       mov     word ptr LInfoSeg,ax
       mov     ax,es:[bx+2]
       mov     word ptr LInfoSeg+2,ax
       pop     es
@@:
       ; Allocate GDT Selectors
       mov     cx,MAX_GDTSELECTORS
       mov     ax,ds
       mov     bx,(offset GDTSelectors)
       mov     dx,bx
       mov     di,dx
       mov     es,ax
       mov     dl,DevHlp_AllocGDTSelector
       call    dword ptr ds:(offset DevHelpInit)

       pop     gs
       pop     fs
       pop     es
       pop     ds
       popad
       ret
init_data endp

device_stub_strategy proc far
	pushad
	push	ds
	push	es
	push	fs
	push	gs

	mov	ax, DATA16
	mov	ds, ax

       movzx 	eax, byte ptr es:[bx].reqCommand
       cmp 	eax, 0
       jz 	short @@init

	push	ebx
	push	es
	mov	ax, bx
	xor	ebx, ebx			
	mov	bx, ax
	mov	ax, es
	mov	fs, ax				; fs:ebx = req. packet
       call 	far ptr FLAT:STRATEGY_          ; 32 bits strategy entry point

	pop	es
	pop	ebx				; oude bx ptr
       mov 	word ptr es:[bx].reqStatus, ax  ; status code

@@device_ret:

	pop	gs
	pop	fs
	pop	es
	pop	ds
	popad
       ret

@@init:
        ;
        ; DEVICE= initialization
        ;
       mov     word ptr ds:(InitPktSeg), es
       mov     word ptr ds:(InitPktOff), bx
       inc     word ptr ds:(fOpen)

	call 	device_init

       mov 	word ptr es:[bx].reqStatus, ax  ; status code (ret by device_init)
       mov     word ptr es:[bx].o_codeend,(offset __OffFinalCS16)
       mov     word ptr es:[bx].o_dataend,(offset __OffFinalDS16)
	jmp 	short @@device_ret

init_err:
	mov 	dword ptr es:[bx].i_devHelp, 0
	jmp 	short @@device_ret

device_stub_strategy endp

get16_path_from_arg proc near
       ; es:si -> source
       ; ds:di -> destination
       ; on return ds:di points to after the last backslash
       push    di
@@:    mov     al,byte ptr es:[si]
       mov     byte ptr ds:[di],al
       inc     si
       inc     di
       cmp     al,0
       je      short @F
       cmp     al,' '
       jne     short @B
@@:    pop     ax
@@:    cmp     di,ax
       je      short @F
       cmp     byte ptr ds:[di],'\'
       je      short @F
       dec     di
       cmp     di,ax
       jne     @B
@@:    cmp     di,ax
       je      short @F
       inc     di
@@:    ret
get16_path_from_arg endp

device_init proc near
	enter 	24, 0
	push 	ds
	push 	es
	push 	bx
	push 	si
	push 	di

       ; bp      ->  old bp
       ; bp - 2  -> FileHandle
       ; bp - 4  -> ActionTaken
       ; bp - 8  -> IOCTL parm (4 bytes)  : union mwdd32_ioctl_init_device_parm
       ; bp - 24 -> IOCTL data (16 bytes) : union mwdd32_ioctl_init_device_data

       ; Get path from args
       push    es
       mov     si, word ptr es:[bx].i_initArgs
       mov     es, word ptr es:[bx+2].i_initArgs
       mov     di,offset PCIIDFILE
       call    get16_path_from_arg
       mov     si,offset PCIIDName
@@:    mov     al,byte ptr ds:[si]
       mov     byte ptr ds:[di],al
       inc     si
       inc     di
       cmp     al,0
       jne     short @B
       pop     es

       ; Open PCI.IDS
       push    seg DATA16
       push    (offset PCIIDFILE)
       push    seg DATA16
       push    (offset hPCIID)
       push    seg DATA16
       push    (offset ulFileAction)
       push    dword ptr 0              ; File size (ULONG)
       push    0                        ; FileAttribute (USHORT)
       push    OPEN_ACTION_FAIL_IF_NEW + OPEN_ACTION_OPEN_IF_EXISTS
       push 	OPEN_SHARE_DENYNONE + OPEN_ACCESS_READONLY
       push    dword ptr 0              ; Reserved (ULONG)
       call 	DOSOPEN
       cmp     ax,0
       je      short @F
       mov     word ptr hPCIID,0
@@:
       ;
       ; Open wathlp$
       ;
       push 	seg DATA16                 ; seg  FileName
       push    (offset FileName)
       push    seg DATA16
       push    (offset hFile)
       push    seg DATA16
       push    (offset ulFileAction)
       push 	dword ptr 0                ; file size
       push 	0                          ; file attributes
       push 	OPEN_ACTION_FAIL_IF_NEW + OPEN_ACTION_OPEN_IF_EXISTS
       push 	OPEN_SHARE_DENYNONE + OPEN_ACCESS_READONLY
       push 	dword ptr 0                ; reserved
       call 	DOSOPEN
       cmp 	ax, NO_ERROR
       jnz 	short @@error

       ;
       ; Close wathlp$
       ;
       mov     ax,word ptr ds:[hFile]
       push    ax
;       push 	word ptr ds:[hFile]
       call 	DOSCLOSE

       ;
       ; Close PCI.IDS
       ;
       push    ax
       mov     ax,word ptr ds:[hPCIID]
       cmp     ax,0
       je      short @F
       push    ax
       call    DOSCLOSE

@@:    pop     ax

;       cmp 	ax, NO_ERROR
;       jnz 	short @@error
       cmp     word ptr ds:[hFile],0
       je      short @@error

@@out:
       push    eax

       push    0001H
       push    DATA16
       push    (offset _MESSAGE_STR)
       push    word ptr ds:(offset _MSG_TABLE16)
       push    ss
       lea     dx,[bp - 2]
       push    dx
       call    far ptr DOSWRITE

       pop     eax

	pop 	di
	pop 	si
	pop 	bx
	pop 	es
	pop 	ds
	leave
	ret
@@error:
	mov 	ax, STDON + STERR + ERROR_I24_GEN_FAILURE
	jmp 	short @@out

device_init endp

;in: cx = cmd
;    bx = lower 16 bits of ULONG parameter
;    dx = upper 16 bits of ULONG parameter
;return value in dx:ax
device_stub_idc proc far
       enter   0,0
       and     sp, 0fffch
       shl     edx,16
       mov     dx,bx
       push    ds
       push    DATA16
       pop     ds
       call    far ptr FLAT:IDC_
       pop     ds
       mov     dx,ax
       shr     eax,16
       xchg    ax,dx
       leave
       retf
device_stub_idc endp

timer_handler  proc far
       pushad
       push    ds
       push    es
       push    fs
       push    gs
       mov     ax,DATA16
       mov     ds,ax
       call    far ptr FLAT:TIMER_
       pop     gs
       pop     fs
       pop     es
       pop     ds
       popad
       retf
timer_handler  endp

irq_handler16  proc far
       push    DATA16
       pop     ds
       call    far ptr FLAT:IRQ_
       neg     eax
       retf
irq_handler16  endp

	ALIGN   2
;use devhlp pointer stored in 16 bits code segment
thunk3216_devhelp:
	push	ds
	push	DATA16
	pop	ds
       call    dword ptr ds:(offset DevHelpInit)
	pop	ds

       jmp 	far ptr FLAT:thunk1632_devhelp

	ALIGN 	2
thunk3216_devhelp_modified_ds:
	push	gs
	push	DATA16
	pop	gs
       call    dword ptr gs:(offset DevHelpInit)
	pop	gs
       jmp 	far ptr FLAT:thunk1632_devhelp_modified_ds

;***************************
;Resource Manager calls
;***************************
CODE16 ends

CODE32 segment
ASSUME CS:FLAT, DS:FLAT, ES:FLAT
       public __OffBeginCS32
       public __GETDS
       public thunk1632_devhelp
	public thunk1632_devhelp_modified_ds
       public DevHlp
       public DevHlp_ModifiedDS
       public STRATEGY_
       public IDC_
       public TIMER_
       public IRQ_
       extrn   STRATEGY_ENTRY : far
       extrn   IDC_ENTRY : far
       extrn   TIMER_ENTRY : far
       extrn   irq_handler : far
IFDEF KEE
	extrn  KernThunkStackTo16 : near
	extrn  KernThunkStackTo32 : near
ENDIF

__OffBeginCS32:

;Called by Watcom to set the DS
__GETDS proc near
	push	eax
       mov 	eax, DOS32FLATDS
	mov	ds, eax
	pop	eax
	ret
__GETDS endp

__wcpp_2_pure_error__:
__wcpp_2_undef_vfun__:
__wcpp_2_undefed_cdtor__:
__wcpp_2_dtor_array_store__:
DevHelpDebug  proc near
       int 3
       int 3
       ret
DevHelpDebug  endp

	ALIGN 	4

DevHlp proc near
IFDEF  KEE
       push    eax
       call    KernThunkStackTo16
       pop     eax
ENDIF
	jmp	far ptr CODE16:thunk3216_devhelp
	ALIGN 4
thunk1632_devhelp:
IFDEF  KEE
       push    eax
       push    edx
       call    KernThunkStackTo32
       pop     edx     ; trashed by KernThunkStackTo32
       pop     eax     ; trashed by KernThunkStackTo32
ENDIF
	ret
DevHlp endp

	ALIGN 	4
DevHlp_ModifiedDS proc near
IFDEF  KEE
       push    eax
       call    KernThunkStackTo16
       pop     eax
ENDIF
	jmp	far ptr CODE16:thunk3216_devhelp_modified_ds
	ALIGN 4
thunk1632_devhelp_modified_ds:
IFDEF  KEE
       push    eax
       push    edx
       call    KernThunkStackTo32
       pop     edx     ; trashed by KernThunkStackTo32
       pop     eax     ; trashed by KernThunkStackTo32
ENDIF
	ret
DevHlp_ModifiedDS endp

STRATEGY_ proc far
       push    ds
       push    es
       push    fs
       push    gs
       mov     eax,DOS32FLATDS
       mov     ds,eax
       mov     es,eax
IFDEF  KEE
       push    stacksel
       push    stackbase
       push    edx
       mov     edx,ss
       mov     stacksel,edx
       call    KernThunkStackTo32
       mov     stackbase,edx
       pop     edx
       call    STRATEGY_ENTRY
       push    eax
       call    KernThunkStackTo16
       pop     eax
       pop     stackbase
       pop     stacksel
ELSE
       call    STRATEGY_ENTRY
ENDIF
       pop     gs
       pop     fs
       pop     es
       pop     ds
       retf
STRATEGY_ endp

;in: ecx = cmd
;    edx = ULONG parameter
;return value in eax
IDC_ proc far
       push    ds
       push    es
       push    fs
       push    gs
       push    ebx
       mov     eax,DOS32FLATDS
       mov     ds,eax
       mov     es,eax
IFDEF  KEE
       push    stacksel
       push    stackbase
       push    edx
       mov     edx,ss
       mov     stacksel,edx
       call    KernThunkStackTo32
       mov     stackbase,edx
       pop     edx
       call    IDC_ENTRY
       push    eax
       call    KernThunkStackTo16
       pop     eax
       pop     stackbase
       pop     stacksel
ELSE
       call    IDC_ENTRY
ENDIF
       pop     ebx
       pop     gs
       pop     fs
       pop     es
       pop     ds
       retf
IDC_ endp

TIMER_ proc far
       mov     eax,DOS32FLATDS
       mov     ds,eax
       mov     es,eax
IFDEF KEE
       push    stacksel
       push    stackbase
       push    edx
       mov     edx,ss
       mov     stacksel,edx
       call    KernThunkStackTo32
       mov     stackbase,edx
       pop     edx
       call    TIMER_ENTRY
       push    eax
       call    KernThunkStackTo16
       pop     eax
       pop     stackbase
       pop     stacksel
ELSE
       call    TIMER_ENTRY
ENDIF
       retf
TIMER_ endp

IRQ_   proc    far
       ; TODO: Check, if irq_level_ptr is valid
       mov     edx,DOS32FLATDS
       mov     ds,edx
       mov     es,edx
IFDEF  KEE
       push    stacksel
       push    stackbase
       push    edx
       mov     edx,ss
       mov     stacksel,edx
       call    KernThunkStackTo32
       mov     stackbase,edx
       pop     edx

; New irq level variable !!!
       mov     eax,dword ptr irq_level_ptr
       mov     eax,[eax]
       call    irq_handler
       push    eax
       call    KernThunkStackTo16
       pop     eax
       pop     stackbase
       pop     stacksel
ELSE
; New irq level variable !!!
       mov     eax,word ptr irq_level_ptr
       mov     eax,[eax]
       call    irq_handler
ENDIF
       retf
IRQ_   endp

CODE32 ends

DATA32 segment
       public  __OffsetFinalCS16
       public  __OffsetFinalDS16
       public  __wcpp_2_pure_error__
       public  __wcpp_2_undef_vfun__
       public  __wcpp_2_undefed_cdtor__
       public  __wcpp_2_dtor_array_store__
       public  _MSG_TABLE32
       public  __OffBeginDS32
       public stackbase
       public stacksel
       public _GDTSelectors32
       public  _IRQLEVELPTR
       public  _IRQ_HDLRPTR
       public  _TIMER_HDLRPTR
       public  _PHPCIID

__OffBeginDS32         dd 0
stacksel               dd 0
stackbase              dd 0

__OffsetFinalCS16  dw (OFFSET CODE16:__OffFinalCS16)
__OffsetFinalDS16  dw (OFFSET DATA16:__OffFinalDS16)

_MSG_TABLE32       dw (OFFSET  DATA16:_MSG_TABLE16)
                   dw SEG     DATA16:_MSG_TABLE16
_GDTSelectors32    dw (OFFSET DATA16:GDTSelectors)
                   dw SEG DATA16:GDTSelectors
_IRQ_HDLRPTR   dw (offset CODE16:irq_handler16)
               dw SEG CODE16
_TIMER_HDLRPTR dw (offset CODE16:timer_handler)
               dw SEG CODE16
_IRQLEVELPTR   dw (offset DATA16:irq_level_ptr)
               dw SEG DATA16:irq_level_ptr
_PHPCIID       dw (OFFSET DATA16:hPCIID)
               dw SEG DATA16:hPCIID

DATA32 ends

end

