; $Id: lxrmcall.asm,v 1.2 2002/04/26 23:08:56 smilcke Exp $

;
; lxrmcall.asm
; Autor:               Stefan Milcke
; Erstellt am:         02.03.2002
; Letzte Aenderung am: 29.03.2002
;
       .386p
       include seg32.inc
       include rm.inc

;************************
; Common variables for RM
;************************
DATA16 segment
       extrn   DeviceHelp : DWORD
       public  _RM_Help0
       public  _RM_Help1
       public  _RM_Help3
       public  _RMFlags
       public  _RMIDCTable
       public  _RMNAME
       public  rm_hDriver
       public  rm_hAdapter
       public  rm_hDevice
       public  rm_hResource
       public  rm_tmpStr1
       public  rm_tmpStr2
       public  rm_tmpStr3
       public  rm_DriverStruct
       public  rm_AdapterStruct
       public  rm_DeviceStruct
_RM_Help0      DWORD 0
_RM_Help1      DWORD 0
_RM_Help3      DWORD 0
_RMFlags       DWORD 0
_RMIDCTable    BYTE[12] dup (0)
_RMNAME        BYTE "RESMGR$ ",0
rm_hDriver     dword   0
rm_hAdapter    dword   0
rm_hDevice     dword   0
rm_hResource   dword   0
rm_ModifyAction dword  0
rm_tmpStr1     BYTE[255] dup (0)
rm_ResourceList label byte
rm_tmpStr2     BYTE[255] dup (0)
rm_tmpStr3     BYTE[255] dup (0)
rm_DriverStruct RM_DRIVERSTRUCT <DATA16:rm_tmpStr1,DATA16:rm_tmpStr2,DATA16:rm_tmpStr3>
rm_AdapterStruct RM_ADAPTERSTRUCT <DATA16:rm_tmpStr1>
rm_DeviceStruct RM_DEVICESTRUCT <DATA16:rm_tmpStr1>
rm_ResourceStruct DWORD 0      ; Resource type
               BYTE    12 DUP (0)
               DWORD   0       ; Reserved
rm_AdjunctBuffer BYTE 1024 DUP (0)
DATA16 ends

;***********************
; Common routines for RM
;***********************
CODE16 segment
       assume cs:CODE16,ds:DATA16
       public  RM_ATTACHDD
       public  _GetCS
       public  _CallRM
       public  __GetAdjList
RM_ATTACHDD    proc near
       push    bp
       mov     bp,sp
       push    di
       mov     bx,08h[bp]
       mov     di,06h[bp]
       mov     dl,2ah
       call    dword ptr ds:(offset DeviceHelp)
       jb      short @RMATT1
       sub     ax,ax
       pop     di
       leave
       retf    4
       ALIGN   2
@RMATT1:
       leave
       ret
       pop     di
       leave
       retf    4
RM_ATTACHDD    endp

_GetCS proc    near
       enter   2,0
       push    cs
       pop     word ptr -02h[bp]
       mov     ax,-02h[bp]
       leave
       ret
_GetCS endp

_CallRM        proc near
       enter   2,0
       call    _GetCS
       test    al,03h
       je      short @CALLRM1
       push    word ptr 0ah[bp]
       push    word ptr 08h[bp]
       push    word ptr 06h[bp]
       call    dword ptr ds:(offset _RM_Help3)
       add     sp,6
       leave
       retf
       ALIGN   2
@CALLRM1:
       push    word ptr 06h[bp]
       call    dword ptr ds:(offset _RM_Help0)
       leave
       retf
_CallRM        endp

;******************************************************************************
; __GetAdjList
; Get pointer to adjunct list in ax:si
;******************************************************************************
__GetAdjList proc near
       mov     si,offset rm_AdjunctBuffer
@@:    mov     ax,ds:[si]
       or      ax,ds:[si+2]
       je      @F
       mov     ax,ds:[si+4]
       add     ax,si
       mov     ds:[si],ax
       mov     ds:[si+2],ds
       mov     si,ax
       jmp     short @B
@@:    mov     si,offset rm_AdjunctBuffer
       cmp     word ptr ds:[si+4],0
       je      @F
       mov     ax,ds
       ret
@@:    mov     ax,0
       mov     si,0
       ret
__GetAdjList endp

CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  __scpy32
       public  __CpyAdjToBuffer
IFDEF KEE
	extrn  KernThunkStackTo16 : near
	extrn  KernThunkStackTo32 : near
ENDIF
;******************************************************************************
; __scpy32
; Copy string esi->edi
;******************************************************************************
__scpy32 proc    near
       push    ecx
       push    edi         ; Search
       mov     edi,esi     ; for
       sub     ecx,ecx     ; end
       dec     ecx         ; of
       xor     eax,eax     ; string
       repne   scasb
       not     ecx
       pop     edi
       repne   movsb       ; copy string
       pop     ecx
       ret
__scpy32 endp

;******************************************************************************
; __CpyAdjToBuffer
;   Copy Adjunct to buffer
;******************************************************************************
__CpyAdjToBuffer proc near
       ; EAX -> pointer to first adjunct
       cmp     eax,0
       jne     @F
       mov     dword ptr rm_AdjunctBuffer,0
       ret
@@:    push    ecx
       push    edi
       push    esi
       xor     ecx,ecx
       mov     edi,offset rm_AdjunctBuffer
@@:    mov     esi,eax
       mov     eax,[esi].rm_ADJ_pNextAdj                     ; pNextAdj
       mov     cx,[esi].rm_ADJ_AdjLength                     ; AdjLength
       repne   movsb
       cmp     eax,0
       jne     @B
       pop     esi
       pop     edi
       pop     ecx
       ret
__CpyAdjToBuffer endp
CODE32 ends

;******************************************************************************
; RMCreateDriver
;******************************************************************************
CODE16 segment
       assume cs:CODE16,ds:DATA16
       public  _RMCreateDriver
       public  th3216_rmcreatedriver
       ALIGN   2
_RMCreateDriver proc near
       enter   4,0
       test    byte ptr ds:(offset _RMFlags),1
       je      short @RMCDRVR4
@RMCDRVR3:
       lea     ax,06h[bp]
       push    ss
       push    ax
       push    02h
       push    cs
       call    _CallRM
       add     sp,06h
       leave
       retf
       ALIGN   2
@RMCDRVR4:
       test    byte ptr ds:(offset _RMFlags),2
       je      short @RMCDRVR6
@RMCDRVR5:
       les     bx,0ah[bp]
       mov     word ptr es:[bx],0ffffh
       mov     word ptr es:02h[bx],0ffffh
       sub     ax,ax
       leave
       retf
       ALIGN   2
@RMCDRVR6:
       mov     ax,word ptr (offset DeviceHelp + 02h)
       or      ax,word ptr (offset DeviceHelp)
       jne     short @RMCDRVR7
       mov     ax,8
       leave
       retf
       ALIGN   2
@RMCDRVR7:
       push    (offset _RMNAME)
       push    (offset _RMIDCTable)
       push    cs
       call    RM_ATTACHDD
       or      ax,ax
       je      short @RMCDRVR8
       or      byte ptr ds:(offset _RMFlags),2
       jmp     @RMCDRVR5
       ALIGN   2
@RMCDRVR8:
       mov     ax,word ptr ds:(offset _RMIDCTable +04h)
       mov     word ptr ds:(offset _RM_Help3 +02h),ax
       mov     word ptr ds:(offset _RM_Help3),0
       mov     ax,word ptr ds:(offset _RMIDCTable +02h)
       mov     word ptr ds:(offset _RM_Help0 +02h),ax
       mov     ax,word ptr ds:(offset _RMIDCTable +06h)
       mov     word ptr ds:(offset _RM_Help0),ax
       or      byte ptr ds:(offset _RMFlags),05h
       jmp     short @RMCDRVR3
_RMCreateDriver endp
th3216_rmcreatedriver:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       push    ds
       push    (offset rm_hDriver)
       push    ds
       push    (offset rm_DriverStruct)
       call    far ptr _RMCreateDriver
       add     sp,8
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmcreatedriver
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       extrn   DevHlp : near
       public  _RM32CreateDriver
       public  th1632_rmcreatedriver
_RM32CreateDriver      proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    DRIVERSTRUCT*
       ; 0ch[ebp] ->    HDRIVER*

       mov     esi,08h[ebp]
       add     esi,12
       mov     edi,(OFFSET rm_DriverStruct + 12)
       mov     ecx,16 ; (24 Complete !!!)
       cld
       rep     movsb
       mov     edx,08[ebp]
       mov     esi,[edx]
       mov     edi,offset rm_tmpStr1
       call    __scpy32
       add     edx,4
       mov     esi,[edx]
       mov     edi,offset rm_tmpStr2
       call    __scpy32
       add     edx,4
       mov     esi,[edx]
       mov     edi,offset rm_tmpStr3
       call    __scpy32
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmcreatedriver
th1632_rmcreatedriver:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32CDRI_01
       mov     ebx,dword ptr DATA16:(OFFSET rm_hDriver)
       mov     edx,0ch[ebp]
       mov     [edx],ebx
       xor     eax,eax
@RM32CDRI_01:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32CreateDriver      endp
CODE32 ends

;******************************************************************************
; RMDestroyDriver
;******************************************************************************
CODE16 segment
       assume  cs:CODE16,ds:DATA16
       public  _RMDestroyDriver
       public  th3216_rmdestroydriver
       ALIGN   2
_RMDestroyDriver proc near
       push    bp
       mov     bp,sp
       test    byte ptr ds:(offset _RMFlags),1
       je      @RMDDRVR1
       lea     ax,06[bp]
       push    ss
       push    ax
       push    03h
       push    cs
       call    _CallRM
       mov     sp,bp
       leave
       retf
       ALIGN   2
@RMDDRVR1:
       test    byte ptr ds:(offset _RMFlags),2
       je      @RMDDRVR2
       sub     ax,ax
       leave
       retf
       nop
@RMDDRVR2:
       mov     ax,1
       leave
       retf
_RMDestroyDriver endp
th3216_rmdestroydriver:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       push    dword ptr (rm_hDriver)
       call    far ptr _RMDestroyDriver
       add     sp,4
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmdestroydriver
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  _RM32DestroyDriver
       public  th1632_rmdestroydriver
_RM32DestroyDriver proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    HDRIVER
       mov     eax,08[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDriver),eax
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmdestroydriver
th1632_rmdestroydriver:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32DDRI_01
       mov     eax,eax
@RM32DDRI_01:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32DestroyDriver endp
CODE32 ends

;******************************************************************************
; RMCreateAdapter
;******************************************************************************
CODE16 segment
       assume cs:CODE16,ds:DATA16
       public  _RMCreateAdapter
       public  th3216_rmcreateadapter
       ALIGN   2
_RMCreateAdapter proc near
       push    bp
       mov     bp,sp
       test    byte ptr ds:(offset _RMFlags),1
       je      short @RMCADPT1
       lea     ax,06h[bp]
       push    ss
       push    ax
       push    04h
       push    cs
       call    _CallRM
       mov     sp,bp
       leave
       retf
       ALIGN   2
@RMCADPT1:
       test    byte ptr ds:(offset _RMFlags),2
       je      short @RMCADPT2
       les     bx,0ah[bp]
       mov     word ptr es:[bx],0ffffh
       mov     word ptr es:02h[bx],0ffffh
       sub     ax,ax
       leave
       retf
       ALIGN   2
@RMCADPT2:
       mov     ax,1
       leave
       retf
_RMCreateAdapter endp
th3216_rmcreateadapter:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       call    __GetAdjList
       mov     word ptr (rm_AdapterStruct.rm_AD_pAdjunctList),si
       mov     word ptr (rm_AdapterStruct.rm_AD_pAdjunctList+2),ax

       mov     ax,0
       mov     bx,0
       cmp     dword ptr (rm_ResourceList),0
       je      @F
       mov     ax,DATA16
       mov     bx,offset rm_ResourceList
@@:    push    ax
       push    bx
       push    dword ptr (rm_hDevice)
       push    ds
       push    offset rm_AdapterStruct
       push    ds
       push    offset rm_hAdapter
       push    dword ptr (rm_hDriver)
       call    far ptr _RMCreateAdapter
       add     sp,20
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmcreateadapter
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  _RM32CreateAdapter
       public  th1632_rmcreateadapter
_RM32CreateAdapter     proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    HDRIVER
       ; 0ch[ebp] ->    HADAPTER*
       ; 10h[ebp] ->    ADAPTERSTRUCT*
       ; 14h[ebp] ->    HDEVICE
       ; 18h[ebp] ->    AHRESOURCE*
       mov     esi,10h[ebp]
       add     esi,04h
       mov     edi,(OFFSET rm_AdapterStruct + 4)
       mov     ecx,20 ; (24 Complete !!)
       cld
       rep     movsb
       mov     edx,10h[ebp]
       mov     esi,[edx]
       mov     edi,offset rm_tmpStr1
       call    __scpy32
       mov     eax,08h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDriver),eax
       mov     eax,14h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDevice),eax
       mov     esi,18h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_ResourceList),esi
       cmp     esi,0
       je      short @RM32CADAPT_01
       mov     ecx,[esi]
       sub     ecx,4
       mov     edi,offset rm_ResourceList
       repne   movsb
@RM32CADAPT_01:
       mov     eax,10h[ebp]            ; ADAPTERSTRUCT
       mov     eax,[eax].rm_AD_pAdjunctList
       call    __CpyAdjToBuffer        ; Copy adjuncts
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmcreateadapter
th1632_rmcreateadapter:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32CADAPT_03
       mov     edx,0ch[ebp]
       mov     ebx,dword ptr DATA16:(OFFSET rm_hAdapter)
       mov     [edx],ebx
       mov     edx,18h[ebp]
       cmp     edx,0
       je      short @RM32CADAPT_02
       mov     ebx,dword ptr DATA16:(OFFSET rm_ResourceList)
       mov     [edx],ebx
@RM32CADAPT_02:
       xor     eax,eax
@RM32CADAPT_03:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32CreateAdapter     endp
CODE32 ends

;******************************************************************************
; RMDestroyAdapter
;******************************************************************************
CODE16 segment
       assume  cs:CODE16,ds:DATA16
       public  _RMDestroyAdapter
       public  th3216_rmdestroyadapter
       ALIGN   2
_RMDestroyAdapter proc near
       push    bp
       mov     bp,sp
       test    byte ptr ds:(offset _RMFlags),1
       je      @RMDADPT1
       lea     ax,06[bp]
       push    ss
       push    ax
       push    05h
       push    cs
       call    _CallRM
       mov     sp,bp
       leave
       retf
       ALIGN   2
@RMDADPT1:
       test    byte ptr ds:(offset _RMFlags),2
       je      @RMDADPT2
       sub     ax,ax
       leave
       retf
       nop
@RMDADPT2:
       mov     ax,1
       leave
       retf
_RMDestroyAdapter endp
th3216_rmdestroyadapter:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       push    dword ptr (rm_hAdapter)
       push    dword ptr (rm_hDriver)
       call    far ptr _RMDestroyAdapter
       add     sp,8
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmdestroyadapter
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  _RM32DestroyAdapter
       public  th1632_rmdestroyadapter
_RM32DestroyAdapter proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    HDRIVER
       ; 0ch[ebp] ->    HADAPTER
       mov     eax,08h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDriver),eax
       mov     eax,0ch[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hAdapter),eax
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmdestroyadapter
th1632_rmdestroyadapter:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32DADPT_01
       mov     eax,eax
@RM32DADPT_01:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32DestroyAdapter endp
CODE32 ends

;******************************************************************************
; RMCreateDevice
;******************************************************************************
CODE16 segment
       assume cs:CODE16,ds:DATA16
       public  _RMCreateDevice
       public  th3216_rmcreatedevice
       ALIGN   2
_RMCreateDevice proc near
       push    bp
       mov     bp,sp
       test    byte ptr ds:(offset _RMFlags),1
       je      short @RMCDEV1
       lea     ax,06h[bp]
       push    ss
       push    ax
       push    06h
       push    cs
       call    _CallRM
       mov     sp,bp
       leave
       retf
       ALIGN   2
@RMCDEV1:
       test    byte ptr ds:(offset _RMFlags),2
       je      short @RMCDEV2
       les     bx,0ah[bp]
       mov     word ptr es:[bx],0ffffh
       mov     word ptr es:02h[bx],0ffffh
       sub     ax,ax
       leave
       retf
       ALIGN   2
@RMCDEV2:
       mov     ax,1
       leave
       retf
_RMCreateDevice endp
th3216_rmcreatedevice:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       call    __GetAdjList
       mov     word ptr (rm_DeviceStruct.rm_DE_pAdjunctList),si
       mov     word ptr (rm_DeviceStruct.rm_DE_pAdjunctList+2),ax

       mov     ax,0
       mov     bx,0
       cmp     dword ptr (rm_ResourceList),0
       je      @F
       mov     ax,DATA16
       mov     bx,offset rm_ResourceList
@@:    push    ax
       push    bx
       push    dword ptr (rm_hAdapter)
       push    ds
       push    offset rm_DeviceStruct
       push    ds
       push    offset rm_hDevice
       push    dword ptr (rm_hDriver)
       call    far ptr _RMCreateDevice
       add     sp,20
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmcreatedevice
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  _RM32CreateDevice
       public  th1632_rmcreatedevice
_RM32CreateDevice     proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    HDRIVER
       ; 0ch[ebp] ->    HDEVICE*
       ; 10h[ebp] ->    DEVICESTRUCT*
       ; 14h[ebp] ->    HADAPTER
       ; 18h[ebp] ->    AHRESOURCE*
       mov     esi,10h[ebp]
       add     esi,04h
       mov     edi,(OFFSET rm_DeviceStruct + 4)
       mov     ecx,8 ; (12 Complete !!)
       cld
       rep     movsb
       mov     edx,10h[ebp]
       mov     esi,[edx]
       mov     edi,offset rm_tmpStr1
       call    __scpy32
       mov     eax,08h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDriver),eax
       mov     eax,14h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hAdapter),eax
       mov     esi,18h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_ResourceList),esi
       cmp     esi,0
       je      short @RM32CDEV_01
       mov     ecx,[esi]
       sub     ecx,4
       mov     edi,offset rm_ResourceList
       repne   movsb
@RM32CDEV_01:
       mov     eax,10h[ebp]            ; DEVICESTRUCT
       mov     eax,[eax].rm_DE_pAdjunctList
       call    __CpyAdjToBuffer        ; Copy adjuncts
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmcreatedevice
th1632_rmcreatedevice:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32CDEV_03
       mov     edx,0ch[ebp]
       mov     ebx,dword ptr DATA16:(OFFSET rm_hDevice)
       mov     [edx],ebx
       mov     edx,18h[ebp]
       cmp     edx,0
       je      short @RM32CDEV_02
       mov     ebx,dword ptr DATA16:(OFFSET rm_ResourceList)
       mov     [edx],ebx
@RM32CDEV_02:
       xor     eax,eax
@RM32CDEV_03:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32CreateDevice     endp
CODE32 ends

;******************************************************************************
; RMDestroyDevice
;******************************************************************************
CODE16 segment
       assume  cs:CODE16,ds:DATA16
       public  _RMDestroyDevice
       public  th3216_rmdestroydevice
       ALIGN   2
_RMDestroyDevice proc near
       push    bp
       mov     bp,sp
       test    byte ptr ds:(offset _RMFlags),1
       je      @RMDDEV1
       lea     ax,06h[bp]
       push    ss
       push    ax
       push    07h
       push    cs
       call    _CallRM
       mov     sp,bp
       leave
       retf
       ALIGN   2
@RMDDEV1:
       test    byte ptr ds:(offset _RMFlags),2
       je      @RMDDEV2
       sub     ax,ax
       leave
       retf
       nop
@RMDDEV2:
       mov     ax,1
       leave
       retf
_RMDestroyDevice endp
th3216_rmdestroydevice:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       push    dword ptr (rm_hDevice)
       push    dword ptr (rm_hDriver)
       call    far ptr _RMDestroyDevice
       add     sp,8
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmdestroydevice
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  _RM32DestroyDevice
       public  th1632_rmdestroydevice
_RM32DestroyDevice proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    HDRIVER
       ; 0ch[ebp] ->    HDEVICE
       mov     eax,08h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDriver),eax
       mov     eax,0ch[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDevice),eax
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmdestroydevice
th1632_rmdestroydevice:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32DDEV_01
       xor     eax,eax
@RM32DDEV_01:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32DestroyDevice endp
CODE32 ends

;******************************************************************************
; RMAllocResource
;******************************************************************************
CODE16 segment
       assume  cs:CODE16,ds:DATA16
       public  _RMAllocResource
       public  th3216_rmallocresource
       ALIGN   2
_RMAllocResource proc near
       push    bp
       mov     bp,sp
       test    byte ptr ds:(offset _RMFlags),1
       je      @RMARES1
       lea     ax,06h[bp]
       push    ss
       push    ax
       push    08h
       push    cs
       call    _CallRM
       mov     sp,bp
       leave
       retf
       ALIGN   2
@RMARES1:
       test    byte ptr ds:(offset _RMFlags),2
       je      @RMARES2
       les     bx,0ah[bp]
       mov     word ptr es:[bx],0ffffh
       mov     word ptr es:02h[bx],0ffffh
       sub     ax,ax
       leave
       retf
       ALIGN   2
@RMARES2:
       mov     ax,1
       leave
       retf
_RMAllocResource endp
th3216_rmallocresource:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       push    ds
       push    offset rm_ResourceStruct
       push    ds
       push    offset rm_hResource
       push    dword ptr (rm_hDriver)
       call    far ptr _RMAllocResource
       add     sp,12
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmallocresource
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  _RM32AllocResource
       public  th1632_rmallocresource
_RM32AllocResource proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    HDRIVER
       ; 0ch[ebp] ->    HRESOURCE*
       ; 10h[ebp] ->    RESOURCESTRUCT*
       mov     esi,10h[ebp]
       mov     edi,(OFFSET rm_ResourceStruct)
       mov     ecx,20
       cld
       rep     movsb
       mov     eax,08h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDriver),eax
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmallocresource
th1632_rmallocresource:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32ARES_01
       mov     edx,0ch[ebp]
       mov     ebx,dword ptr DATA16:(OFFSET rm_hResource)
       mov     [edx],ebx
       xor     eax,eax
@RM32ARES_01:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32AllocResource endp
CODE32 ends

;******************************************************************************
; RMDeallocResource
;******************************************************************************
CODE16 segment
       assume  cs:CODE16,ds:DATA16
       public  _RMDeallocResource
       public  th3216_rmdeallocresource
       ALIGN   2
_RMDeallocResource proc near
       push    bp
       mov     bp,sp
       test    byte ptr ds:(offset _RMFlags),1
       je      @RMDRES1
       lea     ax,06h[bp]
       push    ss
       push    ax
       push    09h
       push    cs
       call    _CallRM
       mov     sp,bp
       leave
       retf
       ALIGN   2
@RMDRES1:
       test    byte ptr ds:(offset _RMFlags),2
       je      @RMDRES2
       sub     ax,ax
       leave
       retf
       nop
@RMDRES2:
       mov     ax,1
       leave
       retf
_RMDeallocResource endp
th3216_rmdeallocresource:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       push    dword ptr (rm_hResource)
       push    dword ptr (rm_hDriver)
       call    far ptr _RMDeallocResource
       add     sp,8
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmdeallocresource
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  _RM32DeallocResource
       public  th1632_rmdeallocresource
_RM32DeallocResource proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    HDRIVER
       ; 0ch[ebp] ->    HRESOURCE
       mov     eax,08h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDriver),eax
       mov     eax,0ch[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hResource),eax
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmdeallocresource
th1632_rmdeallocresource:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32DRES_01
       mov     eax,eax
@RM32DRES_01:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32DeallocResource endp
CODE32 ends

;******************************************************************************
; RMCreateLDev
;******************************************************************************

;******************************************************************************
; RMDestroyLDev
;******************************************************************************

;******************************************************************************
; RMCreateSysName
;******************************************************************************

;******************************************************************************
; RMDestroySysName
;******************************************************************************

;******************************************************************************
; RMADDToHDEVICE
;******************************************************************************

;******************************************************************************
; RMKeyToHandleList
;******************************************************************************

;******************************************************************************
; RMHandleToType
;******************************************************************************

;******************************************************************************
; RMHandleToParent
;******************************************************************************

;******************************************************************************
; RMModifyResources
;******************************************************************************
CODE16 segment
       assume  cs:CODE16,ds:DATA16
       public  _RMModifyResources
       public  th3216_rmmodifyresources
       ALIGN   2
_RMModifyResources proc near
       push    bp
       mov     bp,sp
       test    byte ptr ds:(offset _RMFlags),1
       je      @RMMRES1
       lea     ax,06h[bp]
       push    ss
       push    ax
       push    1bh
       push    cs
       call    _CallRM
       mov     sp,bp
       leave
       retf
       ALIGN   2
@RMMRES1:
       test    byte ptr ds:(offset _RMFlags),2
       je      @RMMRES2
       mov     ax,15h
       leave
       retf
@RMMRES2:
       mov     ax,1
       leave
       retf
_RMModifyResources endp
th3216_rmmodifyresources:
       push    ds
       push    es
       push    DATA16
       push    DATA16
       pop     es
       pop     ds

       push    dword ptr (rm_hResource)
       push    word ptr (rm_ModifyAction)
       push    dword ptr (rm_hAdapter)
       push    dword ptr (rm_hDriver)
       call    far ptr _RMModifyResources
       add     sp,14
       pop     es
       pop     ds
       jmp     far ptr FLAT:th1632_rmmodifyresources
CODE16 ends

CODE32 segment
       assume  cs:FLAT, ds:FLAT, es:FLAT
       public  _RM32ModifyResources
       public  th1632_rmmodifyresources
_RM32ModifyResources proc near
       push    ebp
       mov     ebp,esp
       push    ebx
       push    ecx
       push    edx
       push    esi
       push    edi
       ; 08h[ebp] ->    HDRIVER
       ; 0ch[ebp] ->    HADAPTER
       ; 10h[ebp] ->    ModifyAction
       ; 14h[ebp] ->    HRESOURCE
       mov     eax,08h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hDriver),eax
       mov     eax,0ch[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hAdapter),eax
       mov     eax,10h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_ModifyAction),eax
       mov     eax,14h[ebp]
       mov     dword ptr DATA16:(OFFSET rm_hResource),eax
IFDEF  KEE
       call    KernThunkStackTo16
ENDIF
       xor     eax,eax
       jmp     far ptr CODE16:th3216_rmmodifyresources
th1632_rmmodifyresources:
IFDEF  KEE
       push    eax
       call    KernThunkStackTo32
       pop     eax
ENDIF
       cmp     ax,0
       jne     short @RM32MRES_01
       xor     eax,eax
@RM32MRES_01:
       pop     edi
       pop     esi
       pop     edx
       pop     ecx
       pop     ebx
       pop     ebp
       ret
_RM32ModifyResources endp
CODE32 ends

;******************************************************************************
; RMParseScsiInquiry
;******************************************************************************

;******************************************************************************
; RMUpdateAdjunct
;******************************************************************************

;******************************************************************************
; RMAdjToHandleList
;******************************************************************************

;******************************************************************************
; RMHDevToHLDev
;******************************************************************************

;******************************************************************************
; RMResToHandleList
;******************************************************************************

;******************************************************************************
; RMGetNodeInfo
;******************************************************************************

;******************************************************************************
; RMCreateDetected
;******************************************************************************

;******************************************************************************
; RMDestroyDetected
;******************************************************************************

;******************************************************************************
; RMDevIDToHandleList
;******************************************************************************

;******************************************************************************
; RMHandleToResourceHandleList
;******************************************************************************

;******************************************************************************
; RMModifyNodeFlags
;******************************************************************************

;******************************************************************************
; RMConvertID
;******************************************************************************

;******************************************************************************
; RMGetCommandLine
;******************************************************************************

;******************************************************************************
; RMGetVersion
;******************************************************************************

;******************************************************************************
; RMSetSnoopLevel
;******************************************************************************

;******************************************************************************
; RMSaveDetectedData
;******************************************************************************

;******************************************************************************
; RMDeleteDetectedData
;******************************************************************************

end
