/* $Id: lxrm.c,v 1.2 2002/04/26 23:08:56 smilcke Exp $ */

/*
 * lxrm.c
 * Autor:               Stefan Milcke
 * Erstellt am:         20.02.2002
 * Letzte Aenderung am: 08.04.2002
 *
*/

extern "C"
{
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
#include <lxrmcall.h>
#include <kee.h>
}

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include <ldefos2.h>

#include "ver_32.h"

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <asm/uaccess.h>
#include <asm/hardirq.h>
#include <asm/io.h>
#include <asm/delay.h>
#include <linux/pci.h>
#include <linux/slab.h>
#include <linux/i2c.h>

static HDRIVER hDriver=NULL;
static HADAPTER hPCIAdap=NULL;
static HDEVICE hPCIDev=NULL;
static HADAPTER hI2CAdap=NULL;
static HADAPTER hIRQAdap=NULL;
static HADAPTER hMEMAdap=NULL;
static char LXDRIVER_NAME[]="LXAPI32.SYS";
static char LXVENDOR_NAME[]="Stefan Milcke";

extern int getBuildDay(void);
extern int getBuildMonth(void);
extern int getBuildYear(void);

//--------------------------- OS2_init_driver_struct ---------------------------
extern "C"
void OS2_init_driver_struct(PDRIVERSTRUCT pDriver)
{
 pDriver->DrvrName=(PSZ)LXDRIVER_NAME;
 pDriver->DrvrDescript=(PSZ)"Linux driver";
 pDriver->VendorName=(PSZ)LXVENDOR_NAME;
 pDriver->MajorVer=LX32_DRV_MAJOR_VERSION;
 pDriver->MinorVer=LX32_DRV_MINOR_VERSION;
 pDriver->Date.Year=getBuildYear();
 pDriver->Date.Month=getBuildMonth();
 pDriver->Date.Day=getBuildDay();
 pDriver->DrvrFlags=0;
 pDriver->DrvrType=0;
 pDriver->DrvrSubType=0;
 pDriver->DrvrCallback=NULL;
}

//--------------------------- OS2_create_pci_adapter ---------------------------
extern "C"
unsigned long OS2_create_pci_adapter(void)
{
 unsigned long rc=0;
 if(!hPCIAdap)
 {
  ADAPTERSTRUCT AdapterStruct;
  ADJUNCT AdapNum;
  AdapterStruct.AdaptDescriptName=(PSZ)"Linux PCI bus";
  AdapterStruct.AdaptFlags=AS_NO16MB_ADDRESS_LIMIT;
  AdapterStruct.BaseType=AS_BASE_RESERVED;
  AdapterStruct.SubType=AS_SUB_OTHER;
  AdapterStruct.InterfaceType=AS_INTF_GENERIC;
  AdapterStruct.HostBusType=AS_HOSTBUS_PCI;
  AdapterStruct.HostBusWidth=AS_BUSWIDTH_32BIT;
  AdapterStruct.pAdjunctList=&AdapNum;
  AdapNum.pNextAdj=NULL;
  AdapNum.AdjLength=sizeof(ADJUNCT);
  AdapNum.AdjType=ADJ_ADAPTER_NUMBER;
  AdapNum.Adapter_Number=0;
  rc=RM32CreateAdapter(hDriver,&hPCIAdap,&AdapterStruct,0,NULL);
 }
 if(!rc && !hPCIDev)
 {
  DEVICESTRUCT DevStruct;
  DevStruct.DevDescriptName=(PSZ)"Linux PCI device tree";
  DevStruct.DevFlags=DS_FIXED_LOGICALNAME;
  DevStruct.DevType=DS_TYPE_UNKNOWN;
  DevStruct.pAdjunctList=NULL;
  rc=RM32CreateDevice(hDriver,&hPCIDev,&DevStruct,hPCIAdap,NULL);
 }
 return rc;
}

//---------------------------- initResourceManager -----------------------------
extern "C"
unsigned long initResourceManager(void)
{
 unsigned long rc;
 DRIVERSTRUCT DriverStruct;
// TestContextHook();
 OS2_init_driver_struct(&DriverStruct);
 DriverStruct.DrvrDescript=(PSZ)"Linux API support layer";
 DriverStruct.DrvrType=DRT_SERVICE;
 DriverStruct.DrvrSubType=DRS_CONFIG;
 rc=RM32CreateDriver(&DriverStruct,&hDriver);
 return rc;
}

//--------------------------- OS2_pci_convert_class ----------------------------
static void OS2_pci_convert_class(struct pci_dev *dev,PULONG pCl,PULONG pScl)
{
 ULONG cv=128;
 ULONG cl=(dev->pciclass>>16)&0x0f;
 ULONG scl=(dev->pciclass>>8)&0x0f;
 ULONG pi=(dev->pciclass)&0x0f;
 if(cl<=0x0d)
 {
  if(scl<128)
  {
   scl++;
   switch(cl)
   {
    case AS_BASE_MSD:
    case AS_BASE_PERIPH:
     cv=4;
     break;
    case AS_BASE_NETWORK:
    case AS_BASE_COMM:
    case AS_BASE_INPUT:
     cv=3;
     break;
    case AS_BASE_DISPLAY:
    case AS_BASE_MMEDIA:
     cv=2;
     break;
    case AS_BASE_MEMORY:
    case AS_BASE_PCMCIA:
     cv=1;
     break;
    case AS_BASE_BRIDGE:
    case AS_BASE_DOCK:
    case AS_BASE_CPU:
    case AS_BASE_BIOS_ROM:
     cv=0;
     break;
    default:
     cv=0;
     break;
   }
   if(scl>cv)
    scl=AS_SUB_OTHER;
  }
 }
 else
 {
  cl=AS_BASE_RESERVED;
  scl=AS_SUB_OTHER;
 }
 *pCl=cl;
 *pScl=scl;
}

//---------------------------- OS2_pci_name_device -----------------------------
extern "C"
unsigned long OS2_pci_name_device(struct pci_dev *dev,char *vname,char *dname,char *sname)
{
 unsigned long rc=0;
 struct lxrm_subadapter *rm_adap=dev->rm_subadapter;
 ULONG cl=AS_BASE_RESERVED,scl=AS_SUB_OTHER;
 if(rm_adap && !rm_adap->hAdapter)
 {
  ADAPTERSTRUCT AdapStruct;
  PADAPTERSTRUCT pAdap=rm_adap->pAdapter;
  static int devno=0;
  ADJUNCT AdapNumber;
  ADJUNCT AdapDeviceNr;
  ADJUNCT AdapPCI_DevFunc;
  AdapNumber.pNextAdj=&AdapDeviceNr;
  AdapDeviceNr.pNextAdj=&AdapPCI_DevFunc;
  AdapPCI_DevFunc.pNextAdj=NULL;
  AdapNumber.AdjLength=sizeof(ADJUNCT);
  AdapDeviceNr.AdjLength=sizeof(ADJUNCT);
  AdapPCI_DevFunc.AdjLength=sizeof(ADJUNCT);
  AdapNumber.AdjType=ADJ_ADAPTER_NUMBER;
  AdapDeviceNr.AdjType=ADJ_DEVICE_NUMBER;
  AdapPCI_DevFunc.AdjType=ADJ_PCI_DEVFUNC;
  if(dev->bus)
   AdapNumber.Adapter_Number=dev->bus->number;
  else
   AdapNumber.Adapter_Number=0;
  AdapDeviceNr.Device_Number=devno;
  AdapPCI_DevFunc.PCI_DevFunc=(USHORT)dev->devfn;
  if(NULL==rm_adap->hDriver)
   rm_adap->hDriver=hDriver;
  if(NULL==rm_adap->hParentDevice)
  {
   rc=OS2_create_pci_adapter();
   if(rc)
    return rc;
   rm_adap->hParentDevice=hPCIDev;
  }
  if(NULL==pAdap)
  {
   pAdap=&AdapStruct;
   OS2_pci_convert_class(dev,&cl,&scl);
   AdapStruct.AdaptDescriptName=(PSZ)dev->name;
   AdapStruct.AdaptFlags=AS_NO16MB_ADDRESS_LIMIT;
   AdapStruct.BaseType=(USHORT)cl;
   AdapStruct.SubType=(USHORT)scl;
   AdapStruct.InterfaceType=AS_INTF_GENERIC;
   AdapStruct.HostBusType=AS_HOSTBUS_PCI;
   AdapStruct.HostBusWidth=AS_BUSWIDTH_32BIT;
   AdapStruct.pAdjunctList=&AdapNumber;
   AdapDeviceNr.Device_Number=devno++;
   AdapPCI_DevFunc.PCI_DevFunc=(unsigned short)dev->devfn;
  }
  rc=RM32CreateAdapter(rm_adap->hDriver
                       ,&(rm_adap->hAdapter)
                       ,pAdap
                       ,rm_adap->hParentDevice
                       ,NULL);
  if(0==rc && 0!=dev->subsystem_vendor)
  {
   struct lxrm_subdevice *rm_dev=dev->rm_subdevice;
   if(rm_dev && !rm_dev->hDevice)
   {
    DEVICESTRUCT DevStruct;
    PDEVICESTRUCT pDev=rm_dev->pDevice;
    if(NULL==rm_dev->hParentAdapter)
     rm_dev->hParentAdapter=rm_adap->hAdapter;
    if(NULL==pDev)
    {
     pDev=&DevStruct;
     DevStruct.DevDescriptName=(PSZ)sname;
     DevStruct.DevFlags=DS_FIXED_LOGICALNAME;
     DevStruct.DevType=DS_TYPE_UNKNOWN;
     DevStruct.pAdjunctList=NULL;
    }
    if(NULL==rm_dev->hDriver)
     rm_dev->hDriver=hDriver;
    rc=RM32CreateDevice(rm_dev->hDriver
                        ,&(dev->rm_subdevice->hDevice)
                        ,pDev
                        ,rm_dev->hParentAdapter
                        ,NULL);
   }
  }
 }
 return rc;
}

//-------------------------- OS2_pci_register_driver ---------------------------
extern "C"
unsigned long OS2_pci_register_driver(struct pci_driver *drv)
{
 unsigned long rc=0;
 if((NULL!=drv->rm_driver) && (0==drv->rm_driver->hDriver))
 {
  DRIVERSTRUCT DrvStruct;
  PDRIVERSTRUCT pDrv=drv->rm_driver->pDriver;
  if(NULL==pDrv)
  {
   pDrv=&DrvStruct;
   OS2_init_driver_struct(pDrv);
   DrvStruct.DrvrDescript=(PSZ)"Linux PCI support layer";
   DrvStruct.DrvrType=DRT_SERVICE;
  }
  rc=RM32CreateDriver(pDrv,&(drv->rm_driver->hDriver));
 }
 return rc;
}

//------------------------- OS2_pci_unregister_driver --------------------------
extern "C"
unsigned long OS2_pci_unregister_driver(struct pci_driver *drv)
{
 unsigned long rc=0;
 if((NULL!=drv->rm_driver) && (0!=drv->rm_driver->hDriver))
 {
  rc=RM32DestroyDriver(drv->rm_driver->hDriver);
  drv->rm_driver->hDriver=0;
 }
 return rc;
}

//-------------------------- OS2_pci_announce_device ---------------------------
extern "C"
unsigned long OS2_pci_announce_device(struct pci_driver *drv,struct pci_dev *dev)
{
 unsigned long rc=0;
 if((NULL!=dev->rm_device) && (0==dev->rm_device->hDevice))
 {
  DEVICESTRUCT DevStruct;
  PDEVICESTRUCT pDev=dev->rm_device->pDevice;
  HDRIVER hDrvr=dev->rm_device->hDriver;
  HADAPTER hAdap=dev->rm_device->hAdapter;
  if(NULL==hDrvr)
   hDrvr=hDriver;
  if(NULL==pDev)
  {
   pDev=&DevStruct;
   DevStruct.DevDescriptName=(PSZ)dev->name;
   DevStruct.DevFlags=DS_FIXED_LOGICALNAME;
   DevStruct.DevType=DS_TYPE_UNKNOWN;
   DevStruct.pAdjunctList=NULL;
  }
  rc=RM32CreateDevice(hDrvr,&(dev->rm_device->hDevice),pDev,hAdap,NULL);
 }
 return rc;
}

//----------------------------- OS2_i2c_add_driver -----------------------------
extern "C"
unsigned long OS2_i2c_add_driver(struct i2c_driver *driver)
{
 unsigned long rc=0;
 if((NULL!=driver->rm_device) && (0==driver->rm_device->hDevice))
 {
  DEVICESTRUCT DevStruct;
  PDEVICESTRUCT pDev=driver->rm_device->pDevice;
  HDRIVER hDrvr=driver->rm_device->hDriver;
  HADAPTER hAdap=driver->rm_device->hAdapter;
  if(NULL==hDrvr)
   hDrvr=hDriver;
  if(NULL==pDev)
  {
   pDev=&DevStruct;
   DevStruct.DevDescriptName=(PSZ)driver->name;
   DevStruct.DevFlags=DS_FIXED_LOGICALNAME;
   DevStruct.DevType=DS_TYPE_UNKNOWN;
   DevStruct.pAdjunctList=NULL;
  }
  rc=RM32CreateDevice(hDrvr,&(driver->rm_device->hDevice),pDev,hAdap,NULL);
 }
 return rc;
}

//----------------------------- OS2_i2c_del_driver -----------------------------
extern "C"
unsigned long OS2_i2c_del_driver(struct i2c_driver *driver)
{
 unsigned long rc=0;
 if((NULL!=driver->rm_device) && (0==driver->rm_device->hDevice))
 {
  HDRIVER hDrvr=driver->rm_device->hDriver;
  HADAPTER hAdap=driver->rm_device->hAdapter;
  if(NULL==hDrvr)
   hDrvr=hDriver;
  rc=RM32DestroyDevice(hDrvr,driver->rm_device->hDevice);
  driver->rm_device->hDevice=0;
 }
 return rc;
}

//------------------------------ OS2_request_irq -------------------------------
extern "C"
unsigned long OS2_request_irq(struct lxrm_resource *rm_resource
                              ,unsigned int irq,unsigned long flags)
{
 unsigned long rc=0;
 if(rm_resource && (0==rm_resource->hResource))
 {
  RESOURCESTRUCT IRQResStruct;
  PRESOURCESTRUCT pIRQResStruct=rm_resource->pResource;
  if(0==rm_resource->hDriver)
   rm_resource->hDriver=hDriver;
  if(0==rm_resource->hAdapterOrDevice)
   rm_resource->hAdapterOrDevice=hIRQAdap;
  if(NULL==pIRQResStruct)
  {
   pIRQResStruct=&IRQResStruct;
   pIRQResStruct->ResourceType=RS_TYPE_IRQ;
   pIRQResStruct->IRQResource.IRQLevel=(unsigned short)irq;
   pIRQResStruct->IRQResource.PCIIrqPin=RS_PCI_INT_NONE;
   if(flags&SA_SHIRQ)
    pIRQResStruct->IRQResource.IRQFlags=RS_IRQ_SHARED;
   else
    pIRQResStruct->IRQResource.IRQFlags=0;
   pIRQResStruct->IRQResource.pfnIntHandler=0;
  }
  rc=RM32AllocResource(rm_resource->hDriver,&(rm_resource->hResource),pIRQResStruct);
  if(0==rc)
   rc=RM32ModifyResources(rm_resource->hDriver,rm_resource->hAdapterOrDevice
                          ,RM_MODIFY_ADD,rm_resource->hResource);
 }
 return rc;
}

//-------------------------------- OS2_free_irq --------------------------------
extern "C"
unsigned long OS2_free_irq(struct lxrm_resource *rm_resource,unsigned int irq)
{
 unsigned long rc=0;
 if(rm_resource && (0!=rm_resource->hResource))
 {
  rc=RM32ModifyResources(rm_resource->hDriver,rm_resource->hAdapterOrDevice
                         ,RM_MODIFY_DELETE,rm_resource->hResource);
  if(0==rc)
  {
   rc=RM32DeallocResource(rm_resource->hDriver,rm_resource->hResource);
   if(0==rc)
    rm_resource->hAdapterOrDevice=0;
  }
 }
 return rc;
}

//----------------------------- OS2_request_region -----------------------------
extern "C"
unsigned long OS2_request_region(struct lxrm_resource *rm_resource
                                 ,struct resource *a
                                 ,unsigned long start,unsigned long n)
{
 unsigned long rc=0;
 if(rm_resource && (0==rm_resource->hResource))
 {
  RESOURCESTRUCT MEMResStruct;
  PRESOURCESTRUCT pMEMResStruct=rm_resource->pResource;
  if(0==rm_resource->hDriver)
   rm_resource->hDriver=hDriver;
  if(0==rm_resource->hAdapterOrDevice)
   rm_resource->hAdapterOrDevice=hMEMAdap;
  if(NULL==pMEMResStruct)
  {
   pMEMResStruct=&MEMResStruct;
   pMEMResStruct->ResourceType=RS_TYPE_MEM;
   pMEMResStruct->MEMResource.MemBase=start;
   pMEMResStruct->MEMResource.MemSize=n;
   pMEMResStruct->MEMResource.MemFlags=RS_MEM_EXCLUSIVE;
   pMEMResStruct->MEMResource.ReservedAlign=0;
  }
  rc=RM32AllocResource(rm_resource->hDriver,&(rm_resource->hResource),pMEMResStruct);
  if(0==rc)
   rc=RM32ModifyResources(rm_resource->hDriver,rm_resource->hAdapterOrDevice
                          ,RM_MODIFY_ADD,rm_resource->hResource);
 }
 return rc;
}
//----------------------------- OS2_release_region -----------------------------
extern "C"
unsigned long OS2_release_region(struct lxrm_resource *rm_resource
                                 ,struct resource *a
                                 ,unsigned long start,unsigned long n)
{
 unsigned long rc=0;
 if(rm_resource && (0!=rm_resource->hResource))
 {
  rc=RM32ModifyResources(rm_resource->hDriver,rm_resource->hAdapterOrDevice
                         ,RM_MODIFY_DELETE,rm_resource->hResource);
  if(0==rc)
  {
   rc=RM32DeallocResource(rm_resource->hDriver,rm_resource->hResource);
   if(0==rc)
    rm_resource->hAdapterOrDevice=0;
  }
 }
 return rc;
}
