/* $Id: lxparam.c,v 1.2 2002/04/26 23:08:56 smilcke Exp $ */

/*
 * param.c
 * Autor:               Stefan Milcke
 * Erstellt am:         10.12.2001
 * Letzte Aenderung am: 01.04.2002
 *
*/

extern "C"
{
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
}

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include <ldefos2.h>

#include <string.h>


extern "C"
{

#include <linux/module.h>
#include <linux/types.h>

#include <lxapilib.h>

#define MAX_PARM_LENGTH 256

int verbose=0;
int verbose_modulelist=0;
int doint3=0;
int nocoremodule=0;
int nomodule=0;

static char PARM_LENGTH_ERROR[]="LXAPI32: Parameter to long: ";
static char PARM_UNKNOWN[]="LXAPI32: Unknown parameter: ";
static char CRLF[]="\r\n";

char *parmList[]=
{
 "/3",
 "/VM",
 "/V",
 "/NOCOREMODULE",
 "/NOMODULE",
 "/MODPARM:",
 "/LOADMODULE:",
};

int numParms=sizeof(parmList)/sizeof(char *);

//-------------------------------- load_module ---------------------------------
int load_module(char *moduleName)
{
 int rc=0;
 if(moduleName)
  rc=0;
 return rc;
}

extern "C" int sprintf(char *buffer,const char *format, ...);
extern "C" void WriteString(const char __far *str,int length);

//--------------------------------- parseArgs ----------------------------------
void parseArgs(RPInit __far *rp)
{
 char FAR48 *args;
 char carg[MAX_PARM_LENGTH];
 char *p;
 int i;
 args=__Make48Pointer(rp->In.Args);
 while(*args && *args==' ') args++;
 while(*args && *args!=' ') args++;
 while(*args)
 {
  p=carg;
  while(*args && *args==' ') args++;
  i=0;
  while(*args && *args!=' ' && i<MAX_PARM_LENGTH-1)
  {
   *p++=*args++;
   i++;
  }
  if(i>=MAX_PARM_LENGTH-1)
  {
   WriteString(PARM_LENGTH_ERROR,strlen(PARM_LENGTH_ERROR));
   WriteString(carg,i);
   WriteString(CRLF,strlen(CRLF));
  }
  else
  {
   *p=(char)0;
   for(i=0;i<numParms;i++)
   {
    if(!strncmp(carg,parmList[i],strlen(parmList[i])))
    {
     switch(i)
     {
      case 0:
       doint3=1;
       break;
      case 1:
       verbose_modulelist=1;
      case 2:
       verbose=1;
       break;
      case 3:
       nocoremodule=1;
      case 4:
       nomodule=1;
       break;
      case 5:
       OS2_set_module_parm(&(carg[strlen(parmList[i])]));
       break;
      case 6:
       load_module(&(carg[strlen(parmList[i])]));
       break;
     }
     break;
    }
   }
   if(i>=numParms)
   {
    WriteString(PARM_UNKNOWN,strlen(PARM_UNKNOWN));
    WriteString(carg,strlen(carg));
    WriteString(CRLF,strlen(CRLF));
    break;
   }
  }
 }
}

};