/* $Id: lxioctlv4l.c,v 1.2 2002/04/26 23:08:56 smilcke Exp $ */

/*
 * ioctlv4l.c
 * Autor:               Stefan Milcke
 * Erstellt am:         16.11.2001
 * Letzte Aenderung am: 14.01.2002
 *
*/

extern "C"
{
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
}

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include <ldefos2.h>
#include <lxapioctl.h>
#include <lxapiv4l.h>

extern "C"
{
#include <linux/types.h>
#include <lxapilib.h>
};

//-------------------------------- map_lx_error --------------------------------
ULONG map_lx_error(int err)
{
 return RPDEV | (-err);
}

//--------------------------------- ioctl_v4l ----------------------------------
extern "C" ULONG ioctl_v4l(RPIOCtl __far* rp)
{
 ULONG rc=RPDONE;
 switch(rp->Function)
 {
  case LXIOCFN_V4L_ENUMDEVICES:
   {
    PLXIOCDP_V4L_ENUMDEVICES pEnum=(PLXIOCDP_V4L_ENUMDEVICES)
              VDPFROMRP(rp,rp->DataLength,VERIFY_READWRITE);
    rc=RPERR_PARAMETER | RPDONE;
    if(pEnum)
    {
     PLX_V4L_DEVICEINFO p=(PLX_V4L_DEVICEINFO)pEnum->devInfos;
     if(p)
     {
      pEnum->ulDevices=OS2_v4lx_enum_devices(p,((ULONG)rp->DataLength)-sizeof(LXIOCDP_V4L_ENUMDEVICES));
      rc=RPDONE;
     }
    }
   }
   break;
  case LXIOCFN_V4L_OPENDEVICE:
   {
    PLXIOCPA_V4L_OPENDEVICE paOpen=(PLXIOCPA_V4L_OPENDEVICE)
              VPAFROMRP(rp,rp->ParmLength,VERIFY_READWRITE);
    paOpen->rc=OS2_v4lx_open_device(paOpen->devname);
    if(paOpen->rc>0)
    {
     paOpen->handle=paOpen->rc;
     paOpen->rc=0;
     rc=RPDONE;
    }
    else
     rc=RPDONE | map_lx_error(paOpen->rc);
   }
   break;
  case LXIOCFN_V4L_CLOSEDEVICE:
   {
    PLXIOCPA_V4L_CLOSEDEVICE paClose=(PLXIOCPA_V4L_CLOSEDEVICE)
              VPAFROMRP(rp,rp->ParmLength,VERIFY_READWRITE);
    paClose->rc=OS2_v4lx_close_device(paClose->handle);
    rc=RPDONE | map_lx_error(paClose->rc);
   }
   break;
  case LXIOCFN_V4L_IOCTL:
   {
    PLXIOCPA_V4L_IOCTL paIoctl=(PLXIOCPA_V4L_IOCTL)
              VPAFROMRP(rp,rp->ParmLength,VERIFY_READWRITE);
    PLXIOCDP_V4L_IOCTL dpIoctl=(PLXIOCDP_V4L_IOCTL)
              VDPFROMRP(rp,rp->DataLength,VERIFY_READWRITE);
    paIoctl->rc=OS2_v4lx_ioctl(paIoctl->handle
                               ,paIoctl->v4l_ioctlfn
                               ,dpIoctl);
   }
   break;
  default:
   rc=RPERR_COMMAND | RPDONE;
   break;
 }
 return rc;
}
