/* $Id: lxioctl.c,v 1.2 2002/04/26 23:08:56 smilcke Exp $ */

/*
 * ioctl.c
 * Autor:               Stefan Milcke
 * Erstellt am:         12.11.2001
 * Letzte Aenderung am: 27.04.2002
 *
*/

extern "C"
{
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
}

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include "lxdevown.h"
#include <ldefos2.h>
#include <lxapioctl.h>
#include "Ver_32.h"
#include <string.h>

#include <lxapios2.h>

extern "C"
{
#include <linux/types.h>
#include <lxapilib.h>
};

extern "C" ULONG ioctl_v4lx(RPIOCtl __far* rp);
extern "C" int total_modules;
extern "C" int request_module(char *modName);
extern "C" int release_module(char *modName);
extern "C" int set_module_parm(char *parm);
extern "C" void *malloc(unsigned long size);
extern "C" void free(void *ptr);

char vendor[]="Stefan Milcke";

//-------------------------------- ioctl_global --------------------------------
extern "C" ULONG ioctl_global(RPIOCtl __far *rp)
{
 ULONG rc=0;
 switch(rp->Function)
 {
  case LXIOCFN_GLO_GETDRIVERINFO:
   {
    DATAPACKET(dp,PLXIOCDP_GLO_GETDRIVERINFO,rp,VERIFY_READWRITE);
    if(dp)
    {
     dp->ulVersionMajor=LX32_DRV_MAJOR_VERSION;
     dp->ulVersionMinor=LX32_DRV_MINOR_VERSION;
     dp->ulBuildLevel=BUILD_LEVEL;
     strcpy(dp->vendor,vendor);
     dp->ulNumModules=OS2_get_total_num_modules();
     dp->ulV4LXNumDevices=OS2_v4lx_get_num_devices();
    }
    else
     rc=RPERR_PARAMETER;
   }
   break;
  default:
   rc=RPERR_COMMAND;
   break;
 }
 return rc | RPDONE;
}

//--------------------------------- ioctl_mod ----------------------------------
extern "C" ULONG ioctl_mod(RPIOCtl __far *rp)
{
 ULONG rc=0;
 switch(rp->Function)
 {
  case LXIOCFN_MOD_ENUMMODULES:
   {
    DATAPACKET(dp,PLXIOCDP_MOD_ENUMMODULES,rp,VERIFY_READWRITE);
    if(dp)
    {
     PLX_MODINFO pModInfo=dp->modules;
     if(pModInfo)
      dp->ulNumModules=OS2_enum_modules(pModInfo,((ULONG)rp->DataLength)-sizeof(LXIOCDP_MOD_ENUMMODULES));
    }
   }
   break;
  case LXIOCFN_MOD_REQUEST_MODULE:
   {
    PARMPACKET(p,PLXIOCPA_MOD_REQUEST_MODULE,rp,VERIFY_READWRITE);
    if(p)
     p->rc=request_module(p->name);
    else
     rc=RPERR_PARAMETER;
   }
   break;
  case LXIOCFN_MOD_RELEASE_MODULE:
   {
    PARMPACKET(p,PLXIOCPA_MOD_RELEASE_MODULE,rp,VERIFY_READWRITE);
    if(p)
     p->rc=release_module(p->name);
    else
     rc=RPERR_PARAMETER;
   }
   break;
  case LXIOCFN_MOD_SETMODPARM:
   {
    PARMPACKET(p,PLXIOCPA_MOD_SETPARM,rp,VERIFY_READWRITE);
    if(p)
    {
     int sz=rp->ParmLength;
     char *mp=(char *)malloc(sz);
     if(mp)
     {
      memset(mp,0,sz);
      strcpy(mp,p->moduleName);
      mp[strlen(mp)+1]=(char)0;
      mp[strlen(mp)]=':';
      memcpy(&(mp[strlen(mp)]),p->parameter,strlen(p->parameter));
      p->rc=OS2_set_module_parm(mp);
      free(mp);
     }
     else
     {
      p->rc=-12;
      rc=RPERR;
     }
    }
    else
     rc=RPERR_PARAMETER;
   }
   break;
  default:
   rc=RPERR_COMMAND;
   break;
 }
 return rc | RPDONE;
}

//--------------------------------- ioctl_pci ----------------------------------
extern "C" ULONG ioctl_pci(RPIOCtl __far *rp)
{
 ULONG rc=0;
 /*
 switch(rp->Function)
 {
  default:
   rc=RPERR_COMMAND;
   break;
 }
 */
 rc=RPERR_COMMAND;
 return rc | RPDONE;
}

//--------------------------------- ioctl_i2c ----------------------------------
extern "C" ULONG ioctl_i2c(RPIOCtl __far *rp)
{
 ULONG rc=0;
 /*
 switch(rp->Function)
 {
  default:
   rc=RPERR_COMMAND;
   break;
 }
 */
 rc=RPERR_COMMAND;
 return rc | RPDONE;
}

extern "C" ULONG ioctl_v4l(RPIOCtl __far *rp);

//--------------------------------- StratIOCtl ---------------------------------
extern "C" ULONG StratIOCtl(RPIOCtl __far* rp)
{
 switch(rp->Category)
 {
  case LXIOCCAT_GLO:
   return ioctl_global(rp);
  case LXIOCCAT_MOD:
   return ioctl_mod(rp);
  case LXIOCCAT_PCI:
   return ioctl_pci(rp);
  case LXIOCCAT_I2C:
   return ioctl_i2c(rp);
  case LXIOCCAT_V4L:
   return ioctl_v4l(rp);
 }
 return RPERR_COMMAND | RPDONE;
}

//-------------------------------- OS2_lxioctl ---------------------------------
extern "C" unsigned long OS2_lxioctl(void __far* requestPacketPtr)
{
 RPIOCtl __far *rp=(RPIOCtl __far *)requestPacketPtr;
 if(rp->Category >= LXIOCCAT_GLO)
  return StratIOCtl(rp);
 else
  return RPERR_COMMAND | RPDONE;
}