/* $Id: lxinit.c,v 1.2 2002/04/26 23:08:56 smilcke Exp $ */

/*
 * init.c
 * Autor:               Stefan Milcke
 * Erstellt am:         07.09.2001
 * Letzte Aenderung am: 09.04.2002
 *
*/

// Device support
extern "C"
{
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
}

#include <devhelp.h>
#include <devtype.h>
#include <devrp.h>
#include <ldefos2.h>
#include "lxdevown.h"
#include "Ver_32.h"

#include <string.h>
#include "sprintf.h"
extern "C"
{
#include <lxapios2.h>
#include <lxapilib.h>
#include <linux/types.h>
#include <linux/module.h>
};

#ifdef KEE
#include <kee.h>
#endif

#define PAGE_SIZE 4096

extern "C" int verbose;
extern "C" int verbose_modulelist;
extern "C" int doint3;
extern "C" int nocoremodule;
extern "C" int nomodule;

extern unsigned long build_level;

static const char ERR_ERROR[] = "ERROR: ";
static const char ERR_LOCK[]  = "Unable to lock 32 bit data & code segments, exiting...\r\r\n";
static const char ERR_SIGN[]  = "LXAPI support driver V%d.%d Build %d Copyright 2001-2002 by Stefan Milcke\r\n";
static const char LOADEDMODULE[] = "Loaded module:";
static const char NOMODULE[] = "No module loaded. Use LXAPICFG to configure driver.\r\n";
static const char CRLF[]      = "\r\n";
static char buffer[400];

typedef struct {
 USHORT MsgLength;
 WORD32 MsgPtr;
} MSG_TABLE;

extern "C" WORD32 MSG_TABLE32;

extern "C" int sprintf(char *buffer,const char *format, ...);

//------------------------------- DevSaveMessage -------------------------------
//Print messages with DosWrite when init is done or has failed (see startup.asm)
void DevSaveMessage(char __far *str, int length)
{
 MSG_TABLE __far *msg = (MSG_TABLE __far *)__Make48Pointer(MSG_TABLE32);
 char __far *str16 = (char __far *)__Make48Pointer(msg->MsgPtr);
 int i;
 for(i=0;i<length;i++)
  str16[msg->MsgLength + i] = str[i];
 str16[msg->MsgLength + length] = 0;
 msg->MsgLength += length;
 return;
}

//-------------------------------- LockSegments --------------------------------
int LockSegments(void)
{
#ifdef KEE
 KEEVMLock lock;
#else
 char   lock[12];
 ULONG  PgCount;
#endif
 ULONG  segsize;
 // Locks DGROUP into physical memory
 //NOTE: VMLock rounds base address down to nearest page
 //      So we MUST take this into account when calculating the
 //      size of our code/data
 segsize = OffsetFinalDS32 - ((OffsetBeginDS32) & ~0xFFF);
 if(segsize & 0xFFF)
	segsize += PAGE_SIZE;
  segsize &= ~0xFFF;
#ifdef KEE
 if(KernVMLock(VMDHL_LONG,
               (PVOID)((OffsetBeginDS32) & ~0xFFF),
               segsize,
               &lock,
               (KEEVMPageList*)-1,
               0))
#else
 if(DevVMLock(VMDHL_LONG,
              ((OffsetBeginDS32) & ~0xFFF),
              segsize,
              (LINEAR)-1,
              __StackToFlat((ULONG)lock),
             (LINEAR)__StackToFlat((ULONG)&PgCount)))
#endif
  return(1);
 // Locks CODE32 into physical memory
 segsize = OffsetFinalCS32 - ((OffsetBeginCS32) & ~0xFFF);
 if(segsize & 0xFFF)
  segsize += PAGE_SIZE;
 segsize &= ~0xFFF;
#ifdef KEE
 if(KernVMLock(VMDHL_LONG,
               (PVOID)((OffsetBeginCS32) & ~0xFFF),
               segsize,
               &lock,
               (KEEVMPageList*)-1,
               0))
#else
 if(DevVMLock(VMDHL_LONG,
              ((OffsetBeginCS32) & ~0xFFF),
              segsize,
              (LINEAR)-1,
              __StackToFlat((ULONG)lock),
              (LINEAR)__StackToFlat((ULONG)&PgCount)))
#endif
  return(1);
 return 0;
}


//-------------------------------- WriteString ---------------------------------
extern "C" VOID WriteString(const char __far* str, int length)
{
  // Write the string
  DevSaveMessage((char __far *)str, length);
  return;
}

extern "C" DWORD TIMER_HDLRPTR;

extern "C"
{
void parseArgs(RPInit __far *rp);
int __mallocInit(void);
void *malloc(unsigned long size);
void request_module(char *modName);

int init_timervecs(void);
void pci_init(void);
int videodev_init(void);
void videodev_exit(void);

extern struct os2lx_parm *pcidrv_parms;
extern int num_pcidrv_parms;
};
int init_pci(){ pci_init(); return 0; }

struct os2lx_module timer_module={"timer",0,init_timervecs,NULL,NULL,0};
struct os2lx_module pci_module={"pci_core",0,init_pci,NULL,&pcidrv_parms,&num_pcidrv_parms};
struct os2lx_module i2c_module={"i2c_core",0,NULL,NULL,NULL,0};
struct os2lx_module videodev_module={"videodev",0,videodev_init,videodev_exit,NULL,0};

extern "C" unsigned long initResourceManager(void);
extern "C" void pci_name_device_init(void);
extern "C" void pci_name_device_free(void);

//------------------------------ DiscardableInit -------------------------------
WORD32 DiscardableInit(RPInit __far* rp)
{
 GetTKSSBase();
 if(LockSegments())
 {
  WriteString(ERR_ERROR, sizeof(ERR_ERROR)-1);
  WriteString(ERR_LOCK, sizeof(ERR_LOCK)-1);
  return RPDONE | RPERR;
 }
 rp->Out.FinalCS = 0;
 rp->Out.FinalDS = 0;

 //Do you init here:
 __mallocInit(); // Init heap for malloc
 // Add all supported modules
 OS2_do_add_module(&timer_module,0);
 OS2_do_add_module(&pci_module,0);
 OS2_do_add_module(&i2c_module,0);
 OS2_do_add_module(&videodev_module,0);
 // Init timer
 DevSetTimer(TIMER_HDLRPTR);
 parseArgs(rp);
 if(doint3)
  DebugInt3();
 initResourceManager();
#ifdef CONFIG_PCI_NAMES
 pci_name_device_init();
#endif
 if(!nocoremodule)
 {
  request_module("timer");
  request_module("pci_core");
  request_module("i2c_core");
  request_module("videodev");
 }
 if(verbose)
 {
  sprintf(buffer
          ,ERR_SIGN
          ,LX32_DRV_MAJOR_VERSION
          ,LX32_DRV_MINOR_VERSION
          ,BUILD_LEVEL);
  WriteString(buffer,strlen(buffer));
  if(!nomodule)
  {
   if(verbose_modulelist)
   {
    int n,i;
    n=OS2_get_num_modules();
    for(i=0;i<n;i++)
    {
     char *pName=NULL;
     WriteString(LOADEDMODULE,strlen(LOADEDMODULE));
     pName=OS2_get_module_name(i);
     WriteString(pName,strlen(pName));
     WriteString(CRLF,strlen(CRLF));
    }
   }
  }
  else
  {
   WriteString(NOMODULE,strlen(NOMODULE));
  }
 }
 // Complete the installation
 rp->Out.FinalCS = _OffsetFinalCS16;
 rp->Out.FinalDS = _OffsetFinalDS16;

 // Confirm a successful installation
 return RPDONE;
}

