/* $Id: lxidc.c,v 1.2 2002/04/26 23:08:55 smilcke Exp $ */

/*
 * idc.c
 * Autor:               Stefan Milcke
 * Erstellt am:         08.11.2001
 * Letzte Aenderung am: 14.04.2002
 *
*/
extern "C" {               // 16-bit header files are not C++ aware
#define INCL_NOPMAPI
#define INCL_DOSINFOSEG
#include <os2.h>
}
#include <devtype.h>
#include <devhelp.h>
#include <strategy.h>
#include <stacktoflat.h>
extern "C" {
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/slab.h>
#include <linux/mm.h>
#include <linux/version.h>
#include <linux/module.h>
#include <linux/timer.h>
#include <linux/ioctl.h>
#include <linux/init.h>
#include <linux/vmalloc.h>
#include <linux/kmod.h>
#include <asm/uaccess.h>
#include <linux/process.h>
#include <linux/pci.h>
#include <linux/i2c.h>
#include <linux/i2c-algo-bit.h>
#include <linux/videodev.h>
#include <ioremap.h>

#include <lxapiidc.h>
#include <lxapilib.h>
#include <lxrmcall.h>
}

extern "C" void *malloc(unsigned long size);
extern "C" void free(void *ptr);
extern "C" unsigned long OS2_lxioctl(void __far* requestPacketPtr);

#define DECLARE_LXIDCGETAPIPTR(type,packet) \
type *pApi=(type*)packet; \
if(LXAPI_VERSION<pApi->required_version) return 2; \
pApi->actual_version=LXAPI_VERSION;

#define SETTOLXAPI(name) pApi->name=name;

WORD32 __far IDCEntry(ULONG cmd, ULONG packet);
#pragma aux IDCEntry "IDC_ENTRY" parm reverse [ecx edx]
WORD32 __far IDCEntry(ULONG cmd, ULONG packet)
{
 WORD32 rc=0;
 switch(cmd)
 {
  case LXIDCCMD_GETOS2API:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETOS2API,packet);
    SETTOLXAPI(OS2_lxioctl);
    SETTOLXAPI(OS2_add_module);
    SETTOLXAPI(OS2_apply_mod_parm);
    SETTOLXAPI(OS2_set_module_parm);
    SETTOLXAPI(OS2_get_num_modules);
    SETTOLXAPI(OS2_get_total_num_modules);
    SETTOLXAPI(OS2_get_module_name);
    SETTOLXAPI(OS2_enum_modules);
   }
   break;
  case LXIDCCMD_GETRMAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETRMAPI,packet);
    SETTOLXAPI(RM32CreateDriver);
    SETTOLXAPI(RM32DestroyDriver);
    SETTOLXAPI(RM32CreateAdapter);
    SETTOLXAPI(RM32DestroyAdapter);
    SETTOLXAPI(RM32CreateDevice);
    SETTOLXAPI(RM32DestroyDevice);
    SETTOLXAPI(RM32AllocResource);
    SETTOLXAPI(RM32DeallocResource);
    SETTOLXAPI(RM32ModifyResources);
   }
   break;
  case LXIDCCMD_GETV4LAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETV4LAPI,packet);
    SETTOLXAPI(OS2_v4lx_enum_devices);
    SETTOLXAPI(OS2_v4lx_get_num_devices);
    SETTOLXAPI(OS2_v4lx_open_device);
    SETTOLXAPI(OS2_v4lx_close_device);
    SETTOLXAPI(OS2_v4lx_close_all_opened_devices);
    SETTOLXAPI(OS2_v4lx_get_opened_device);
    SETTOLXAPI(OS2_v4lx_ioctl);
   }
   break;
  case LXIDCCMD_GETMEMAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETMEMAPI,packet);
    pApi->malloc=malloc;
    pApi->free=free;
    SETTOLXAPI(kmalloc);
    SETTOLXAPI(kfree);
    SETTOLXAPI(vmalloc);
    SETTOLXAPI(__vmalloc);
    SETTOLXAPI(vfree);
    SETTOLXAPI(kfree_s);
    SETTOLXAPI(virt_to_phys);
    SETTOLXAPI(phys_to_virt);
    SETTOLXAPI(free_pages);
    SETTOLXAPI(alloc_pages);
    SETTOLXAPI(remap_page_range);
    SETTOLXAPI(is_access_ok);
    SETTOLXAPI(__copy_user);
    SETTOLXAPI(copy_to_user);
    SETTOLXAPI(__copy_user_zeroing);
    SETTOLXAPI(copy_from_user);
    SETTOLXAPI(get_user);
    SETTOLXAPI(put_user);
    SETTOLXAPI(ioremap);
    SETTOLXAPI(iounmap);
   }
   break;
  case LXIDCCMD_GETSEMAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETSEMAPI,packet);
    SETTOLXAPI(init_MUTEX);
    SETTOLXAPI(init_MUTEX_LOCKED);
    SETTOLXAPI(down);
    SETTOLXAPI(up);
   }
   break;
  case LXIDCCMD_GETSLCAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETSLCAPI,packet);
    SETTOLXAPI(spin_lock_init);
    SETTOLXAPI(spin_lock);
    SETTOLXAPI(spin_lock_flag);
    SETTOLXAPI(spin_trylock);
    SETTOLXAPI(spin_unlock_wait);
    SETTOLXAPI(spin_unlock);
   }
   break;
  case LXIDCCMD_GETMODAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETMODAPI,packet);
    SETTOLXAPI(request_module);
    SETTOLXAPI(release_module);
   }
   break;
  case LXIDCCMD_GETSCHAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETSCHAPI,packet);
    pApi->__jiffies=&jiffies;
    pApi->__current=&current;
    SETTOLXAPI(add_wait_queue);
    SETTOLXAPI(add_wait_queue_exclusive);
    SETTOLXAPI(remove_wait_queue);
    SETTOLXAPI(__wake_up);
    SETTOLXAPI(sleep_on);
    SETTOLXAPI(sleep_on_timeout);
    SETTOLXAPI(interruptible_sleep_on);
    SETTOLXAPI(interruptible_sleep_on_timeout);
    SETTOLXAPI(wake_up_process);
    SETTOLXAPI(schedule_timeout);
    SETTOLXAPI(schedule);
    SETTOLXAPI(kernel_thread);
   }
   break;
  case LXIDCCMD_GETTIMAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETTIMAPI,packet);
    SETTOLXAPI(add_timer);
    SETTOLXAPI(mod_timer);
    SETTOLXAPI(del_timer);
   }
   break;
  case LXIDCCMD_GETRESAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETRESAPI,packet);
    pApi->__ioport_resource=&ioport_resource;
    pApi->__iomem_resource=&iomem_resource;
    SETTOLXAPI(request_resource);
    SETTOLXAPI(release_resource);
    SETTOLXAPI(allocate_resource);
    SETTOLXAPI(request_irq);
    SETTOLXAPI(free_irq);
    SETTOLXAPI(eoi_irq);
    SETTOLXAPI(__check_region);
    SETTOLXAPI(__request_region);
    SETTOLXAPI(__release_region);
   }
   break;
  case LXIDCCMD_GETPCIAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETPCIAPI,packet);
    pApi->__pci_pci_problems=&pci_pci_problems;
    SETTOLXAPI(pcibios_init);
    SETTOLXAPI(pcibios_fixup_bus);
    SETTOLXAPI(pcibios_enable_device);
    SETTOLXAPI(pcibios_align_resource);

    SETTOLXAPI(pci_find_device);
    SETTOLXAPI(pci_find_subsys);
    SETTOLXAPI(pci_find_class);
    SETTOLXAPI(pci_find_slot);
    SETTOLXAPI(pci_find_capability);

    SETTOLXAPI(pci_read_config_byte);
    SETTOLXAPI(pci_read_config_word);
    SETTOLXAPI(pci_read_config_dword);
    SETTOLXAPI(pci_write_config_byte);
    SETTOLXAPI(pci_write_config_word);
    SETTOLXAPI(pci_write_config_dword);

    SETTOLXAPI(pci_enable_device);
    SETTOLXAPI(pci_disable_device);
    SETTOLXAPI(pci_set_master);
    SETTOLXAPI(pci_assign_resource);

    SETTOLXAPI(pci_register_driver);
    SETTOLXAPI(pci_unregister_driver);
    SETTOLXAPI(pci_insert_device);
    SETTOLXAPI(pci_remove_device);
    SETTOLXAPI(pci_dev_driver);
    SETTOLXAPI(pci_match_device);
   }
   break;
  case LXIDCCMD_GETI2CAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETI2CAPI,packet);
    SETTOLXAPI(i2c_probe);
    SETTOLXAPI(i2c_add_driver);
    SETTOLXAPI(i2c_del_driver);
    SETTOLXAPI(i2c_attach_client);
    SETTOLXAPI(i2c_detach_client);
    SETTOLXAPI(i2c_master_send);
    SETTOLXAPI(i2c_master_recv);
    SETTOLXAPI(i2c_transfer);
    SETTOLXAPI(i2c_bit_add_bus);
    SETTOLXAPI(i2c_bit_del_bus);
   }
   break;
  case LXIDCCMD_GETVIDAPI:
   {
    DECLARE_LXIDCGETAPIPTR(LXIDC_GETVIDAPI,packet);
    SETTOLXAPI(video_register_device);
    SETTOLXAPI(video_unregister_device);
   }
   break;
  default:
   rc=1;
   break;
 }
 return rc;
}
